/*
** Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.
**
** Unlimited use, reproduction, and distribution of this software is
** permitted.  Any copy of this software must include both the above
** copyright notice of Xerox Corporation and this paragraph.  Any
** distribution of this software must comply with all applicable United
** States export control laws.  This software is made available AS IS,
** and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
** INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
** PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
** THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
** CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
** XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: common.c,v 1.53 1996/03/08 03:35:14 janssen Exp $ */
/* Last edited by Mike Spreitzer January 9, 1996 11:04 pm PST */
 

#include "cstubber.h"

static Interface	CurrentInterface = NULL;
static list 		InterfacesToInclude = NULL;
cardinal 		MethodRecordID;

boolean IsCacheableMethod (Procedure m)
{
    enum PrimitiveTypes         t = type_ur_kind (m->returnType);
 
    return (m->functional && list_size (m->arguments) == 0
          &&  (t == object_Type || t == enumeration_Type || t == byte_Type
              || t == integer_Type || t == shortinteger_Type
              || t == cardinal_Type || t == shortcardinal_Type
              || t == real_Type || t == shortreal_Type
              || t == character_Type || t == shortcharacter_Type));
}
 
Interface OriginalInterface (Type type)
{
  return (ur_type(type)->interface);
}

Type UltimateType (Type type)
{
  return (ur_type(type));
}

boolean IsSequenceObject(
    Type 	type,
    Interface 	i)
{
    return ((i == NULL || type->interface == i)
	  && type->importInterfaceName == NULL
	  && type_ur_kind(type) == sequence_Type
	  &&  (type_ur_kind (type_description (type)->
		structuredDes.sequence.type) != shortcharacter_Type)
	  &&  (type_ur_kind (type_description (type)->
		structuredDes.sequence.type) != byte_Type));
}

boolean IsPipeObject(
    Type 	type,
    Interface 	i)
{
    return ((i == NULL || type->interface == i)
	  && type->importInterfaceName == NULL
	  && type_ur_kind (type) == pipe_Type);
}

boolean PassedByRef (Type type)
{
    enum PrimitiveTypes t;

    if (type == NULL)
        return (False);
    t = type_ur_kind (type);
    return  (t == record_Type
	  || t == union_Type
	  || t == array_Type
	  || t == object_Type
	  || t == pipe_Type
	  || t == sequence_Type
	  || t == longcardinal_Type
	  || t == longinteger_Type);
}

boolean TypeIsNonObjectStruct(
     Type 	type)
{
    enum PrimitiveTypes t;

    if (type == NULL)
        return (False);
    t = type_ur_kind (type);
    return (t == record_Type || t == union_Type);
}

boolean TypeIsArray (Type type)
{
  if (type == NULL)
    return  (False);
  
  return (type_ur_kind (type) == array_Type);
}

boolean TypeIsString (Type type)
{
  return (type_ur_kind (type) == sequence_Type AND
	  (type_ur_kind (type_description (type)->structuredDes.sequence.type) == shortcharacter_Type));
}

boolean TypeIsWString (Type type)
{
  return (type_ur_kind (type) == sequence_Type AND
	  (type_ur_kind (type_description (type)->structuredDes.sequence.type) == character_Type));
}

boolean NonStringSequence (Type type)
{
  return (type_ur_kind (type) == sequence_Type AND NOT
	  ((type_ur_kind (type_description (type)->structuredDes.sequence.type) == character_Type) OR
	   (type_ur_kind (type_description (type)->structuredDes.sequence.type) == shortcharacter_Type)));
}

boolean TypeIsPointer (Type type)
{
  return (type_ur_kind(type) == object_Type OR
	  type_ur_kind(type) == array_Type);
}

boolean HasFreeRoutine (Type type)
{
  enum PrimitiveTypes t = type_ur_kind(type);

  return (type->importInterfaceName == NULL AND
	  (t == union_Type OR
	   t == record_Type OR
	   t == optional_Type OR
	   t == sequence_Type OR
	   t == array_Type));    
}

boolean HasAllocRoutine (Type type)
{
  enum PrimitiveTypes t = type_ur_kind(type);

  return (type->importInterfaceName == NULL AND
	  (t == union_Type OR
	   t == record_Type OR
	   t == optional_Type OR
	   t == sequence_Type OR
	   t == array_Type)); 
}

void SizeValue (Context context, Type type, string name)
{
    TypeDescription d = type_description (type);
    enum PrimitiveTypes t = type_basic_type (type);

    if (t == integer_Type)
      fprintf (context->file, "ilu_SizeOfInteger(_call, %s, _err)", name);
    else if (t == enumeration_Type)
      fprintf (context->file, "ilu_SizeOfEnum(_call, (ilu_shortcardinal) %s, _err)", name);
    else if (t == cardinal_Type)
        fprintf (context->file, "ilu_SizeOfCardinal(_call, %s, _err)", name);
    else if (t == shortinteger_Type)
        fprintf (context->file, "ilu_SizeOfShortInteger(_call, %s, _err)", name);
    else if (t == shortcardinal_Type)
        fprintf (context->file, "ilu_SizeOfShortCardinal(_call, %s, _err)", name);
    else if (t == longinteger_Type)
        fprintf (context->file, "ilu_SizeOfLongInteger(_call, %s, _err)", name);
    else if (t == boolean_Type)
        fprintf (context->file, "ILU_C_SizeOfBoolean(_call, %s, _err)", name);
    else if (t == longcardinal_Type)
        fprintf (context->file, "ilu_SizeOfLongCardinal(_call, %s, _err)", name);
    else if (t == character_Type)
        fprintf (context->file, "ilu_SizeOfCharacter(_call, %s, _err)", name);
    else if (t == shortcharacter_Type)
        fprintf (context->file, "ilu_SizeOfByte(_call, %s, _err)", name);
    else if (t == real_Type)
        fprintf (context->file, "ilu_SizeOfReal(_call, %s, _err)", name);
    else if (t == shortreal_Type)
        fprintf (context->file, "ilu_SizeOfShortReal(_call, %s, _err)", name);
    else if (t == longreal_Type)
        fprintf (context->file, "ilu_SizeOfLongReal(_call, %s, _err)", name);
    else if (t == byte_Type)
        fprintf (context->file, "ilu_SizeOfByte(_call, %s, _err)", name);
    else if (t == alias_Type)
      SizeValue (context, ur_type(type), name);
    else if (t == record_Type OR
	     t == optional_Type OR
	     t == union_Type OR
	     t == sequence_Type OR
	     t == array_Type)
      fprintf (context->file, "_%s__SizeOf (_call, %s, _err)", 
	       c_type_name(type), name);
    else if (t == object_Type)
      fprintf (context->file, 
	       "_ILU_C_SizeOfObject(_call, (%s) %s, _%s__ILUType, ilu_FALSE, _err)",
	       c_return_type(type), name, c_type_name(type));
    else if (t == void_Type)
      fprintf (context->file, "0");
    else
      fatal ("Error:  Can't figure size of argument of type %s (line %d) yet.\n",
	    type_name(type), type->def);
}

void MarshallValue (Context context, Type type, string name, int indent)
{
  enum PrimitiveTypes t = type_basic_type(type);
  TypeDescription d = type_description(type);

  fprintf (context->file, "%*.*s", indent, indent, "");

  if (t == integer_Type)
    fprintf (context->file, "ilu_OutputInteger (_call, %s, _err);\n", name);
  else if (t == enumeration_Type)
    fprintf (context->file, "ilu_OutputEnum (_call, (ilu_shortcardinal) %s, _err);\n", name);
  else if (t == cardinal_Type)
    fprintf (context->file, "ilu_OutputCardinal (_call, %s, _err);\n", name);
  else if (t == shortinteger_Type)
    fprintf (context->file, "ilu_OutputShortInteger (_call, %s, _err);\n", name);
  else if (t == shortcardinal_Type)
    fprintf (context->file, "ilu_OutputShortCardinal (_call, %s, _err);\n", name);
  else if (t == boolean_Type)
    fprintf (context->file, "ILU_C_OutputBoolean(_call, %s, _err);\n", name);
  else if (t == longinteger_Type)
    fprintf (context->file, "ilu_OutputLongInteger(_call, %s, _err);\n", name);
  else if (t == longcardinal_Type)
    fprintf (context->file, "ilu_OutputLongCardinal(_call, %s, _err);\n", name);
  else if (t == character_Type)
    fprintf (context->file, "ilu_OutputCharacter(_call, %s, _err);\n", name);
  else if (t == shortcharacter_Type)
    fprintf (context->file, "ilu_OutputByte(_call, %s, _err);\n", name);
  else if (t == real_Type)
    fprintf (context->file, "ilu_OutputReal(_call, %s, _err);\n", name);
  else if (t == shortreal_Type)
    fprintf (context->file, "ilu_OutputShortReal(_call, %s, _err);\n", name);
  else if (t == longreal_Type)
    fprintf (context->file, "ilu_OutputLongReal(_call, %s, _err);\n", name);
  else if (t == byte_Type)
    fprintf (context->file, "ilu_OutputByte(_call, %s, _err);\n", name);
  else if (t ==  alias_Type)
    MarshallValue (context, ur_type(type), name, 0);
  else if (t == record_Type OR
	   t == union_Type OR
	   t == sequence_Type OR
	   t == optional_Type OR
	   t == array_Type)
    fprintf (context->file, "_%s__Output(_call, %s, _err);\n",
	     c_type_name(type), name);
  else if (t == object_Type)
    fprintf (context->file, 
	     "_ILU_C_OutputObject(_call, (%s) %s, _%s__ILUType, ilu_FALSE, _err);\n",
	     c_type_name(type), name, c_type_name(type));
  else if (t == void_Type)
    ;
  else
    fatal("Error:  Can't cope with argument of type %s yet.\n", c_type_name(type));
}

void encodeArgument(Argument arg, Context context)
{
  char b[1000];
  enum PrimitiveTypes t = type_basic_type (ur_type(arg->type));

  if (arg->direction == Out)
    return;
  b[ 0 ] = 0;
  b[ 1 ] = 0;
  if (arg->direction == InOut) {
    if ( (t != array_Type) && 
	(t != sequence_Type) && 
	(t != record_Type) && 
	(t != union_Type)) {
      strcat (b, "*");
    }
  }
  strcat (b, (char *) c_argument_name (arg));
  MarshallValue (context, ur_type(arg->type), b, 2);
}

void UnmarshallValue (Context	 context,
		      Type	 type,
		      LineNumber line,
		      string	 buffer,
		      int	 indent,
		      boolean	 terminate,
		      boolean	 allocate)
{
  enum PrimitiveTypes t = type_basic_type(type);
  TypeDescription d = type_description(type);

  if (indent > 0)
    {
      fprintf (context->file, "%*.*s", indent, indent, "");
    }

  if (t == integer_Type)
    fprintf (context->file, "ilu_InputInteger (_call, %s, _err);\n", buffer);
  else if (t == cardinal_Type)
    fprintf (context->file, "ilu_InputCardinal (_call, %s, _err);\n", buffer);
  else if (t == shortinteger_Type)
    fprintf (context->file, "ilu_InputShortInteger (_call, %s, _err);\n", buffer);
  else if (t == shortcardinal_Type)
    fprintf (context->file, "ilu_InputShortCardinal (_call, %s, _err);\n", buffer);
  else if (t == boolean_Type)
    fprintf (context->file, "ILU_C_InputBoolean (_call, %s, _err);\n", buffer);
  else if (t == longinteger_Type)
    fprintf (context->file, "ilu_InputLongInteger (_call, %s, _err);\n", buffer);
  else if (t == longcardinal_Type)
    fprintf (context->file, "ilu_InputLongCardinal (_call, %s, _err);\n", buffer);
  else if (t == character_Type)
    fprintf (context->file, "ilu_InputCharacter (_call, %s, _err);\n", buffer);
  else if (t == shortcharacter_Type)
    fprintf (context->file, "ilu_InputByte (_call, %s, _err);\n", buffer);
  else if (t == real_Type)
    fprintf (context->file, "ilu_InputReal (_call, %s, _err);\n", buffer);
  else if (t == shortreal_Type)
    fprintf (context->file, "ilu_InputShortReal (_call, %s, _err);\n", buffer);
  else if (t == longreal_Type)
    fprintf (context->file, "ilu_InputLongReal (_call, %s, _err);\n", buffer);
  else if (t == byte_Type)
    fprintf (context->file, "ilu_InputByte (_call, %s, _err);\n", buffer);
  else if (t == alias_Type)
    UnmarshallValue (context, ur_type(type), line, buffer, 0, terminate, allocate);
  else if (t == enumeration_Type)
    {
      fprintf (context->file, "{\n%*.*silu_shortcardinal _xxx;\n", indent+2, indent+2, "");
      fprintf (context->file, "%*.*silu_InputEnum (_call, &_xxx, _err);\n", indent+2, indent+2, "");
      fprintf (context->file, "%*.*s*%s = (%s) _xxx;\n%*.*s};\n", indent+2, indent+2, "",
	       buffer, c_type_name (type), indent, indent, "");
    }
  else if (TypeIsString(type))
    {
      if (allocate)
	fprintf (context->file, "%s = (ilu_CString) _ilu_CString__Input (_call, ILU_NIL, _err);\n", buffer);
      else
	fprintf (context->file, "(void) _ilu_CString__Input (_call, (ilu_CString *) %s, _err);\n", buffer);
    }
  else if (t == array_Type OR
	   t == sequence_Type OR
	   t == optional_Type OR
	   t == record_Type OR
	   t == union_Type)
    {
      if (allocate)
	fprintf (context->file, "%s = (%s) _%s__Input (_call, ILU_NIL, _err);\n",
		 buffer, (t == array_Type) ? c_return_type(type) : c_parameter_type (type, Out),
		 c_type_name(ur_type(type)));
      else
	fprintf (context->file, "(void) _%s__Input (_call, %s, _err);\n",
		 c_type_name(ur_type(type)), buffer);
    }
  else if (t == object_Type)
    fprintf (context->file, "%s = (%s) _ILU_C_InputObject (_call, _%s__ILUType, ilu_FALSE, _err);\n",
	     buffer, c_return_type (type), c_type_name (type));
  else if (t == void_Type)
    ;
  else
    fatal ("Error:  Can't cope with procedure of type %s (line %d) yet.\n", c_type_name (type), line);
}

boolean BlockingCall (Procedure proc)
{
  return (!(proc->asynch)
	  || type_basic_type(proc->returnType) != void_Type
	  || list_size(proc->exceptions) > 0);
}

static boolean matchString(
    char 	*s1, 
    char	*s2)
{
    return (strcmp (s1,s2) == 0);
}

static void PrintInclude(
    char 	*interfacename,
    Context 	context)
{
 /* get any translation of what the header file for the interface is */
 interfacename = interface_header_name(interfacename);

 fprintf (context->file, "#include \"%s.h\"\n", interfacename);
}


static void listIncludes(
    Imported 	i,
    list 	l)
{
    Interface 	imported;

    if ((imported = GetInterface (i->name, i->filename)) != NULL
	&& imported != CurrentInterface
	&& (strcmp(i->name, "ilu") != 0)
	&& (list_find (l, (iluparser_FindProc) matchString, c_simple_name(imported->name)) == NULL))
      list_insert (l, c_simple_name (imported->name));    
}

void generateNecessaryIncludes(
    Context 	context)
{
  if (InterfacesToInclude == NULL)
    InterfacesToInclude = (list) new_list();
  list_clear (InterfacesToInclude, FALSE);
  CurrentInterface = context->interface;
  list_enumerate (context->interface->imports, (void (*)(refany, refany)) listIncludes, InterfacesToInclude);
  list_enumerate (InterfacesToInclude, (void (*)(refany, refany)) PrintInclude, context);
}

