/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include <stdio.h>
#include "_scm.h"



/* {Ports - string ports}
 * 
 */

#ifdef __STDC__
static int 
prinstpt (SCM exp, SCM port, int writing)
#else
static int 
prinstpt (exp, port, writing)
     SCM exp;
     SCM port;
     int writing;
#endif
{
  scm_prinport (exp, port, "string");
  return !0;
}

#ifdef __STDC__
static int 
stputc (int c, SCM p)
#else
static int 
stputc (c, p)
     int c;
     SCM p;
#endif
{
  sizet ind = INUM (CAR (p));
  if (ind >= LENGTH (CDR (p)))
    scm_resizuve (CDR (p), MAKINUM (ind + (ind >> 1)));
  CHARS (CDR (p))[ind] = c;
  CAR (p) = MAKINUM (ind + 1);
  return c;
}

#ifdef __STDC__
static sizet 
stwrite (char *str, sizet siz, sizet num, SCM p)
#else
static sizet 
stwrite (str, siz, num, p)
     char *str;
     sizet siz;
     sizet num;
     SCM p;
#endif
{
  sizet ind = INUM (CAR (p));
  sizet len = siz * num;
  char *dst;
  if (ind + len >= LENGTH (CDR (p)))
    scm_resizuve (CDR (p), MAKINUM (ind + len + ((ind + len) >> 1)));
  dst = &(CHARS (CDR (p))[ind]);
  while (len--)
    dst[len] = str[len];
  CAR (p) = MAKINUM (ind + siz * num);
  return num;
}

#ifdef __STDC__
static int 
stputs (char *s, SCM p)
#else
static int 
stputs (s, p)
     char *s;
     SCM p;
#endif
{
  stwrite (s, 1, strlen (s), p);
  return 0;
}

#ifdef __STDC__
static int 
stgetc (SCM p)
#else
static int 
stgetc (p)
     SCM p;
#endif
{
  sizet ind = INUM (CAR (p));
  if (ind >= LENGTH (CDR (p)))
    return EOF;
  CAR (p) = MAKINUM (ind + 1);
  return CHARS (CDR (p))[ind];
}

#ifdef __STDC__
SCM 
scm_mkstrport (SCM pos, SCM str, long modes, char * caller)
#else
SCM 
scm_mkstrport (pos, str, modes, caller)
     SCM pos;
     SCM str;
     long modes;
     char * caller;
#endif
{
  SCM z;
  ASSERT(INUMP(pos) && INUM(pos) >= 0, pos, ARG1, caller);
  ASSERT(NIMP(str) && (STRINGP(str) || SYMBOLP(str)), str, ARG1, caller);
  str = scm_cons(pos, str);
  NEWCELL (z);
  DEFER_INTS;
  SETCHARS(z, str);
  CAR (z) = tc16_strport | modes;
  scm_add_to_port_table (z);
  ALLOW_INTS;
  return z;
}

PROC (s_call_with_output_string, "call-with-output-string", 1, 0, 0, scm_call_with_output_string);
#ifdef __STDC__
SCM 
scm_call_with_output_string (SCM proc)
#else
SCM 
scm_call_with_output_string (proc)
     SCM proc;
#endif
{
  SCM p = scm_mkstrport(INUM0, scm_make_string(MAKINUM(30), SCM_UNDEFINED),
			OPN | WRTNG,
			s_call_with_output_string);
  scm_apply (proc, p, listofnull);
  return scm_resizuve (CDR (CDR (p)), CAR (CDR (p)));
}

PROC (s_call_with_input_string, "call-with-input-string", 2, 0, 0, scm_call_with_input_string);
#ifdef __STDC__
SCM 
scm_call_with_input_string (SCM str, SCM proc)
#else
SCM 
scm_call_with_input_string (str, proc)
     SCM str;
     SCM proc;
#endif
{
  SCM p = scm_mkstrport(INUM0, str, OPN | RDNG, s_call_with_input_string);
  return scm_apply (proc, p, listofnull);
}

#ifdef __STDC__
static int 
noop0 (FILE *stream)
#else
static int 
noop0 (stream)
     FILE *stream;
#endif
{
  return 0;
}


scm_ptobfuns scm_stptob =
{
  scm_markcdr,
  noop0,
  prinstpt,
  0,
  stputc,
  stputs,
  stwrite,
  noop0,
  stgetc,
  0
};


#ifdef __STDC__
void
scm_init_strports (void)
#else
void
scm_init_strports ()
#endif
{
#include "strports.x"
}

