/* `compat.c' -- Routines for backward-compatibility to earlier versions of
   the ecc library.  This file may disappear in future releases.

   Copyright (C) 1993, 1996 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Developed by Paul Flaherty (paulf@stanford.edu).
   Munged for speed by Fung-Chai Lim (fclim@acm.org).

   This file is part of GNU ecc.  */

#include "gf256.h"

     unsigned char
gfmul (x, y)
     unsigned char x, y;
{
  return gf256_mul (x, y);
}

     unsigned char
gfadd (a, b)
     unsigned char a, b;
{
  return gf256_add (a, b);
}

     unsigned char
gfinv (x)
     unsigned char x;
{
  return gf256_inv (x);
}

     unsigned char
gfexp (a, n)
     unsigned char a, n;
{
  return gf256_exp (a, n);
}

#include "rsff-f9.h"

rsencode (msg, code)
     unsigned char msg[249], code[255];
{
  int i;
  unsigned char parity[6];

  rs255_249_encode (msg, parity);

  for (i = 0; i < 6; i++)
    code[i] = parity[5 - i];
  for (i = 0; i < 249; i++)
    code[i + 6] = msg[248 - i];
}

rsdecode (code, msg, num_errs)
     unsigned char code[255], msg[249];
     int *num_errs;
{
  int i;
  int status;
  unsigned char buf[255];

  for (i = 0; i < 255; i++)
    buf[i] = code[254 - i];

  status = rs255_249_decode (buf);

  for (i = 0; i < 249; i++)
    msg[i] = buf[i];

  *num_errs = rs255_249_number_of_errors (status);
}
