select_not_mounted () {
	local message="$1"
	local partitions="`non_mounted_partitions`"
	if [ $? -ne 0 -o -z "$partitions" ]; then
		msgBox \
"No \"Linux native\" disk partitions that had not
already been mounted were detected." \
		"Problem"
		return 1
	fi
	cat >$TempFile <<EOF
	menu \\
	 "$message" \\
	 "Select Disk Partition" \\
EOF
	local index=0
	for p in $partitions; do
		index=`math $index 1 add`
		echo -n " "$p" " >>$TempFile
		echo " \"\" \\" >>$TempFile
	done
	echo "">>$TempFile
	local partition="`. $TempFile`"
	local status=$?
	if [ $status -ne 0 -o -z "$partition" ]; then return 1; fi
	echo $partition
	return 0
}
