mounted_partitions () {
	local partitions="`< /etc/mtab sed -e 's/[ 	].*$//' -e '/proc$/d' \
	 -e '/ramdisk0$/d' -e '/ram$/d' `"
	if [ $? -ne 0 -o -z "$partitions" ]; then return 1; fi
	# Reverse the partitions from the mount-table order, as this is the order
	# in which they would be un-mounted.
	echo `reverse "$partitions"`
	return 0
}

non_mounted_partitions () {
	local partitions="`scan_partitions \"Linux native\"`"
	if [ $? -ne 0 -o -z "$partitions" ]; then return 1; fi
	exclude "`mounted_partitions`" "$partitions"
	return $?
}
