run_lilo () {
	echo "$clear$bold\
Running LILO to make the kernel able to boot from the hard disk without a
boot floppy...$norm"
	echo ""
	cat >/target/etc/lilo.conf << EOF
boot=$Root
root=$Root
compact
install=/boot/boot.b
map=/boot/map
vga=normal
delay=20
image=/vmlinuz
label=Linux
read-only
EOF
	if [ $? -ne 0 ]; then return 1; fi
	chmod 644 /target/etc/lilo.conf
	if [ $? -ne 0 ]; then return 1; fi
	(export LD_LIBRARY_PATH="/target/lib:/target/usr/lib"; \
	 /target/sbin/lilo -r /target >/dev/null)
	return $?
}

install_mbr ()
{
	local device=`echo $Root | sed -e 's/[0-9]$//'`

	yesNoBox \
"A master boot record is required to boot the system.
If you are already using a boot manager, and want to
keep it, answer "no" to the following question. If you
don't know what a boot manager is or whether you have
one, answer "yes".

Install a master boot record on $device""?" "Create Master Boot Record?"

	if [ $? -eq 0 ]; then
		cp /target/boot/mbr.b $device
		if [ $? -ne 0 ]; then return 1; fi
	fi
	return 0
}

set_boot_default () {
	local device=`echo $Root | sed -e 's/[0-9]$//'`
	local partition=`echo $Root | sed -e 's/^[^0-9]*//'`

	yesNoBox \
"If you want the Debian system to boot automatically from the
hard disk when you turn your system on, answer \"yes\" to the
following question.  If you have another operating system
that you'd prefer to be the one that boots automatically,
answer \"no\".

Boot the Debian system on $Root as the default?" \
	"Make Linux the Default Boot Partition?"
	if [ $? -eq 0 ]; then
		(export LD_LIBRARY_PATH="/target/lib:/target/usr/lib"; \
		/target/sbin/activate $device $partition)
		if [ $? -ne 0 ]; then return 1; fi
	fi
	return 0
}

make_bootable () {
	run_lilo
	status=$?
	if [ $status -ne 0 ]; then
		write_it_down
		msgBox \
"LILO wasn't able to install. You'll still be able to boot
your system if you create a boot floppy, but it won't be able
to boot without a floppy.

The most common reason for LILO to fail is an over-large
root (\"/\") partition. LILO is unable to load any block
of the kernel from a disk cylinder numbered higher than 1023.
This is often a problem with disks larger than a Gigabyte
(1024 MB) or so. One way to solve the problem is to make a
separate \"/\" and \"/usr\" disk partition, so that the
entire \"/\" partition will be below the 1023rd cylinder." \
		"Problem"
		return 1
	fi
	if [ $status -eq 0 ]; then
		install_mbr
		status=$?
	fi
	if [ $status -eq 0 ]; then
		set_boot_default
		status=$?
	fi
}
