init_swap () {
	if [ ! -z "$Swap" -a "$Swap" != "None" ]; then
		yesNoBox \
"You have already activated $Swap as your swap partition. If you
choose to initialize another swap partition, $Swap will be de-activated
as your swap partition. If you wish to have multiple swap partitions,
you can set them up after you've installed the system - this installer
can only handle one at a time. Answer \"no\" to the following question
if you wish to keep your present swap partition active.

Initialize and activate a new swap partition?" "Initialize Another Swap Partition?"
		if [ $? -ne 0 ]; then return 1; fi
		swapoff $Swap
		Swap=""
	fi

	local partition=`select_partition \
"Please select the partition to initialize as a swap device." "Linux swap"`
	if [ $? -ne 0 -o -z "$partition" ]; then return 1; fi
	yesNoBox \
"The system can scan the entire partition for un-readable disk
blocks and will mark any such bad blocks it finds so that they
will not be used. This requires that every block be read, and
thus could take a long time, but may save you trouble later.

Should the bad-block scan be performed on $partition?" \
	"Scan for Bad Blocks?"
	if [ $? -eq 0 ]; then
		local cflag="-c "
	elif [ $? -eq 1 ]; then
		local cflag=""
	else
		return 1
	fi
	yesNoBox \
"You have chosen to initialize $partition as a swap device. This
will permanently erase any data on this disk partition. Are
you sure you want to do this?" "Are You Sure?"
	if [ $? -ne 0 ]; then return 1; fi
	echo $clear$bold"Initializing swap partition..."$norm
	echo ""
	mkswap $cflag""$partition
	local status=$?
	if [ $status -eq 0 ]; then
		swapon $partition
		status=$?
	fi
	if [ $status -ne 0 ]; then
		write_it_down
		msgBox \
"The swap partion was not created." "Problem"
		return 1
	fi
	Swap=$partition
	return 0
}
