# Shell interface to "dialog"
# Bruce Perens, November 1995
# This is free software under the GNU General Public License.

# Global options
#	The variable $BACKTITLE specifies the back title.
#	The variable $DIALOG_OPTIONS, initialized here to --clear, provides
#	options you want on the command line of each dialog invocation.
#	The variable $DIALOG_TEST can be set to "echo" to see the calls
#	to dialog without executing them.

DIALOG_OPTIONS=""

# Make any dialogue box, with default settings and backtitle from
# $BACKTITLE in the environment.
#
# dialog --type arg arg ...
#
dialogBox () {
	local type="$1"
	shift
	local title=""
	local backtitle=""

	local text="$1"
	shift

	if [ $# -ge 1 ]; then
		title="$1"
		shift
	fi

	if [ -n "$BACKTITLE" ]; then
		backtitle="$BACKTITLE"
	fi

	$DIALOG_TEST dialog $DIALOG_OPTIONS --title "$title" --backtitle \
	 "$backtitle" "$type" "$text" 0 0 "$@" 2>&1 1>/dev/tty
	local result=$?
	return $result
}

# Display a file.
#
# fileBox filename [title]
#
fileBox () {
	dialogBox --textbox "$1" "$2"
}

# textBox takes presents its standard input in a dialog box. This
# is useful for "here documents" and pipes.
#
# textBox [title]
#
textBox () {
	cat >$TempFile

	if [ $? -ne 0 ]; then
		echo "Can't make temporary file for dialog box." 1>&2
		return 255
	fi

	# Note that dialog needs stdin to be the terminal, so I redirect here.
	< /dev/tty dialogBox --textbox $TempFile "$1"
	local result=$?
	rm -f $TempFile
	return $result
}

msgBox () {
	dialogBox --msgbox "$1" "$2"
}

infoBox () {
	dialogBox --infobox "$1" "$2"
}

yesNoBox () {
	dialogBox --yesno "$1" "$2"
}

inputBox () {
	dialogBox --inputbox "$1" "$2" "$3"
}

# menu text title tag1 item1 ...
menu () {
	local text="$1"
	shift
	local title="$1"
	shift
	dialogBox --menu "$text" "$title" 0 "$@"
}

# menu text title tag1 item1 status1 ...
checklist () {
	local text="$1"
	shift
	local title="$1"
	shift
	dialogBox --checklist "$text" "$title" 0 "$@"
}

# menu text title tag1 item1 status1 ...
radiolist () {
	local text="$1"
	shift
	local title="$1"
	shift
	dialogBox --radiolist "$text" "$title" 0 "$@"
}
