get_required_parameters () {
	host="`inputBox \
"Every Debian Linux system has a name - even if it is not on a
network. This name is called its \"hostname\". You should now
specify a hostname for your new system.

If your system is going to be on a network, you should talk to the
administrator of the network before you choose a hostname. If not,
you may choose any name you like.

If you can't think of a hostname for your new system, you may press
<ENTER> to use the default hostname of \"debian\"." \
	"Please enter your Host name" "debian"`"
	if [ $? -ne 0 ]; then return 255; fi

	if [ -z "$host" ]; then
		host="debian";
	elif [ `count_words $host` -ne 1 ]; then
		infoBox "Problem" "The host name must be one word."
		return 1
	fi

	return 0
}

get_net_parameters () {
	local I1 I2 I3 I4 R1 R2 R3 R4 N1 N2 N3 N4 ipa netm

	while true; do
		domain="`inputBox \
"As with individual systems, every network has a name.
This name is called the domain name. Please enter your
Domain Name." "Please enter your Domain name" "$domain"`"
		if [ $? -ne 0 ]; then return 255; fi
		if [ ! -z "$domain" ]; then break; fi
	done

	hostname="$host.$domain"
	yesNoBox "The full name of your system is $hostname . Correct?" \
	 "Confirm"
	if [ $? -ne 0 ]; then return 255; fi

	ipaddr="`inputBox \
	 "What is the IP address of system \"$host\"?" "Please Enter IP Address" \
	 "$ipaddr"`"
	if [ $? -ne 0 -o -z "$ipaddr" ]; then return 255; fi
	ipa=`echo $ipaddr | sed 's/\./ /g'`
	I1=`first $ipa`
	I2=`second $ipa`
	I3=`third $ipa`
	I4=`fourth $ipa`

	netmask="`inputBox "What is your netmask?" "Please Enter Netmask" \
	 "$netmask"`"
	if [ $? -ne 0 -o -z "$netmask" ]; then return 255; fi
	netm=`echo $netmask | sed 's/\./ /g'`
	N1=`first $netm`
	N2=`second $netm`
	N3=`third $netm`
	N4=`fourth $netm`

	R1=`math $I1 $N1 and`
	R2=`math $I2 $N2 and`
	R3=`math $I3 $N3 and`
	R4=`math $I4 $N4 and`
	network="$R1.$R2.$R3.$R4"
	network="`inputBox "What is the IP address of your network?" \
	 "Please Enter Network Address" "$network"`"
	if [ $? -ne 0 -o -z "$network" ]; then return 255; fi

	R1=`math $N1 not 255 and $I1 or`
	R2=`math $N2 not 255 and $I2 or`
	R3=`math $N3 not 255 and $I3 or`
	R4=`math $N4 not 255 and $I4 or`
	broadcast="$R1.$R2.$R3.$R4"
	broadcast="`inputBox "What is your IP broadcast address?" \
	 "Please Enter Broadcast Address" "$broadcast"`"
	if [ $? -ne 0 -o -z "$broadcast" ]; then return 255; fi

	gateway="none"
	yesNoBox \
"A gateway system is one that connects your network to
other networks such as your company wide-area net or the
Internet. Is there a gateway system on your network?" "Is there a Gateway?"
	if [ $? -eq 0 ]; then
		R1=`math $I1 $N1 and`
		R2=`math $I2 $N2 and`
		R3=`math $I3 $N3 and`
		gateway="$R1.$R2.$R3.1"
		gateway="`inputBox "What is your IP gateway address?" \
		 "Please Enter Gateway Address" "$gateway"`"
		if [ $? -ne 0 -o -z "$gateway" ]; then return 255; fi
	fi

	local choice
	choice="`menu \
"Where is the DNS (Domain Name Service) server?" \
"Locate DNS Server" \
	"1" "System \"$host\" will be its own DNS server." \
	"2" "Another system will be the DNS server for system \"$host\"." \
	"3" "There will be no DNS server."`"
	if [ $? -ne 0 ]; then return 255; fi

	nameserver="none"

	case $choice in
	1)
		nameserver="127.0.0.1"
		;;
	2)
		nameserver="`inputBox \
"Please enter the IP addresses (not host names) of up to 5 name
servers. The input line will scroll to allow you to enter a long
line. The servers will be queried in the order in which you enter
them." "Please Enter Name Server Address" "$gateway"`"
		;;
	*)
		nameserver="none"
		;;
	esac


	yesNoBox \
"IP Address:        $ipaddr
Netmask:            $netmask
Network Address:    $network
Broadcast Address:  $broadcast
Gateway Address:    $gateway
Nameserver Addresses: $nameserver

Correct?" "Please Confirm"
	if [ $? -ne 0 ]; then return 1; fi

	return 0
}

set_file_mode ()
{
	chown root.root $1
	chmod 644 $1
	return 0
}

write_network_configuration ()
{
	# This uses the following variables
	#
	# $broadcast
	# $domain
	# $ethernet
	# $gateway
	# $host
	# $hostname
	# $ipaddr
	# $nameserver
	# $netmask
	# $network

	echo $host >/target/etc/hostname
	set_file_mode /target/etc/hostname
	
	echo "localnet	$network" > /target/etc/networks
	set_file_mode /target/etc/networks

	if [ "$domain" != "none" ]; then
		cat >/target/etc/resolv.conf << EOF
domain $domain
search $domain
EOF
		if [ "$nameserver" != "none" ]
		then
			echo "nameserver	$nameserver" >> /target/etc/resolv.conf
		fi
		set_file_mode /target/etc/resolv.conf
	fi


	cat > /target/etc/init.d/network << EOF
#!	/bin/sh
ifconfig lo 127.0.0.1
route add 127.0.0.1
EOF
	set_file_mode /target/etc/init.d/network
	chmod 755 /target/etc/init.d/network

	if [ "$ethernet" -eq 0 ]; then
		cat > /target/etc/hosts << EOF
127.0.0.1	localhost
$ipaddr		$hostname	$host
EOF
		cat >> /target/etc/init.d/network << EOF
IPADDR=$ipaddr
NETMASK=$netmask
NETWORK=$network
BROADCAST=$broadcast
GATEWAY=$gateway
ifconfig eth0 \${IPADDR} netmask \${NETMASK} broadcast \${BROADCAST}
route add -net \${NETWORK}
route add default gw \${GATEWAY} metric 1
EOF
	else
		echo "127.0.0.1	$host	localhost" > /target/etc/hosts
		set_file_mode /target/etc/hosts
	fi

	return 0
}

config_network () {
	require_root
	if [ $? -ne 0 ]; then return 1; fi

	local broadcast ethernet gateway host hostname ipaddr nameserver \
	 netmask network

	while true; do
		get_required_parameters
		local status=$?
		if [ $status -eq 255 ]; then return 255; fi
		if [ $status -eq 0 ]; then break; fi
	done

	yesNoBox \
"Is your system connected to a network?" "Use a Network?"
	if [ $? -ne 0 ]; then
		broadcast="127.0.0.255"
		domain="none"
		ethernet=1
		gateway="none"
		hostname="$host"
		ipaddr="127.0.0.1"
		nameserver="none"
		netmask="255.255.255.0"
		network="127.0.0.0"
	else
		while true; do
			ipaddr="123.123.123.123"
			netmask="255.255.255.0"
			get_net_parameters
			local status=$?
			if [ $status -eq 255 ]; then return 255; fi
			if [ $status -eq 0 ]; then break; fi
		done

		yesNoBox "Are you connected to the network via Ethernet?" \
		 "Use Ethernet?"
		ethernet=$?
		if [ "$ethernet" -ne 0 -a "$ethernet" -ne 1 ]; then return 255; fi
	fi

	write_network_configuration

	return 0
}
