#!	/bin/sh
# Root Disk maker. Bruce Perens, December 1995
# This is free software under the GNU General Public License.

set -e
set -v

(modprobe minix floppy; exit 0)

first () {
	echo $1
}

last () {
	eval 'echo $'$#
}

# Abort on any non-zero return.
umask 022

if [ $# != 3 ]; then
echo "Usage: "$0" archive floppy-drive blocks" 1>&2
	cat 1>&2 << EOF

	archive: the directory containing the Debian binary packages.
	floppy-drive: the block device file for the floppy drive.
	blocks: the size of the floppy in 1K blocks, use 720, 1200, or 1440.

	/mnt must be available for mounting the floppy disk.

EOF

	exit -1
fi

# Set this to the location of the package archive.
archive=$1

# Set this to the block device for the floppy disk.
floppy=$2

# Set to the number of blocks per floppy.
blocks=$3
if [ ! -d $archive/. ]; then
	echo "Error: "$archive": not a directory." 1>&2
	exit -1
fi

if [ ! -b $floppy ]; then
	echo "Error: "$floppy": not a block device. Should be the floppy disk device." \
		1>&2
	exit -1
fi

(cd utilities; make)

# Try to unmount anything that should not be mounted.
(umount /mnt; umount $floppy; true)2>/dev/null >/dev/null

# Zero the entire disk, so that when I compress the raw disk image,
# unused blocks will compress well.
dd if=/dev/zero of=$floppy bs=1k count=${blocks}

# Make a Minix filesystem.
mkfs.minix -n30 -i 1024 $floppy ${blocks}

# Mount the disk.
mount -t minix $floppy /mnt

# Temporary directories
E=/var/tmp/extract-tmp-$$

# The home of the scripts used by this script.
scripts=`pwd`/scripts/rootdisk

for i in \
	$scripts/EXTRACT_LIST \
	$scripts/SMALL_BASE_LIST \
	$scripts/LINKS \
	;do
	if [ ! -f $i ]; then
		echo "Can't open $i"
		exit -1
	fi
done

# A list of all the packages that are the source of files in the base archive.
EXTRACT="`cat $scripts/EXTRACT_LIST`"

# A list of all the hard links to make to the "busybox" program.
LINKS="`cat $scripts/LINKS`"

# Expand the package names into full pathnames.
PACKAGE_PATHS=""
for i in $EXTRACT; do
	p=`last $archive/$i-*.deb`
	if [ ! -f $p ]; then
		echo "Can't find package" $p 1>& 2
		exit -1;
	fi
	PACKAGE_PATHS=$PACKAGE_PATHS" "$p
done

if [ -d $E ]; then
	mv -f $E $E.old
	rm -f -r $E.old &
fi

mkdir -p -m 755 $E

for i in $PACKAGE_PATHS; do
	echo Extracting $i 1>&2
	dpkg-deb --extract $i $E
done

(cd $scripts/prototype; tar clf - .)|(cd /mnt;tar xlpf -)
# Use tar to do the copying because it preserves hard links.
(cd $E; tar --files-from=$scripts/SMALL_BASE_LIST -cf -)|(cd /mnt;tar xlpf -)
(cd $E/lib; cp \
	`last ld-linux.so.*` \
	`last libcom_err.so.*` \
	`last libe2p.so.*` \
	`last libext2fs.so.*` \
	`last libm.so.*` \
 /mnt/lib )

rm -f -r $E &

(cd /mnt/bin; mv gzip-new gzip)
(cd /mnt/lib; for j in lib*.new; do mv $j ${j%%.new}; done)
cp utilities/busybox/busybox /mnt/sbin/init
(cd /mnt; for j in ${LINKS}; do { ln sbin/init $j }; done)
(cd /mnt/bin; ln ash sh)
(cd /mnt/bin; ln ae edit)
(cd /mnt/lib; ln `last ld-linux.*` ld-linux.so.1)

EXECUTABLES="/mnt/bin/* /mnt/sbin/* /mnt/usr/bin/*"
# $scripts/generate_library /usr/lib/libmenu3.0_pic.a \
#  /mnt/lib/libmenu.so.3.0 $EXECUTABLES
# $scripts/generate_library /usr/lib/libpanel3.0_pic.a \
#  /mnt/lib/libpanel.so.3.0 $EXECUTABLES
# $scripts/generate_library /usr/lib/libform3.0_pic.a \
#  /mnt/lib/libform.so.3.0 $EXECUTABLES
$scripts/generate_library /usr/lib/libncurses3.0_pic.a \
 /mnt/lib/libncurses.so.3.0 $EXECUTABLES \
	# /mnt/lib/libmenu.so.3.0 /mnt/lib/libpanel.so.3.0 /mnt/lib/libform.so.3.0
$scripts/generate_library /usr/lib/libc5_pic.a /mnt/lib/libc.so.5 \
	$EXECUTABLES /mnt/lib/libncurses.so.3.0 \
	# /mnt/lib/libmenu.so.3.0 /mnt/lib/libpanel.so.3.0 /mnt/lib/libform.so.3.0

chroot /mnt /sbin/ldconfig.new -v
rm -f /mnt/sbin/ldconfig.new &

# Replace symbolic links on the floppy with hard links! This saves one block
# per link.
(cd /mnt;find . -type l -printf '(cd `dirname %p`;if [ ! -d %l ]; then rm %f; ln %l %f; fi)\n')

# Umount the floppy and copy it to a compressed raw disk image file.
umount $floppy
(rm -f -r root.bin;true)
gzip < $floppy > root.bin
ls -l root.bin
exit 0
