#!	/bin/bash

set -e
set -v

umask 022

if [ $# != 1 ]; then
	echo "Usage:	"$0 "debian-archive-directory" 1>& 2
	cat 1>&2 << EOF

	Creates a new base archive.

	debian-archive-directory: the local copy of the Debian archive.

	Warning: If there is more than one version of each package in the
	base archive, the one that comes out last (highest) in an ASCII
	sort will be used.

EOF
	exit -1;
fi

last () {
	eval 'echo $'$#''
}

(modprobe floppy; exit 0)

make_paths() {
	local PATHS=""
	for i in $*; do
		p=`last $archive/$i-[^a-zA-Z]*.deb`
		if [ ! -f $p ]; then
			echo "Can't find package" $p 1>& 2
			exit -1;
		fi
		PATHS=$PATHS" "$p
	done
	echo $PATHS
}

# Set this to the location of the package archive.
archive=$1

# Temporary directories
B=/var/tmp/base-tmp-$$
P=/var/tmp/partial-tmp-$$

# The home of the scripts used by this script.
scripts=`pwd`/scripts/basedisks

for i in $archive/Packages $scripts/PACKAGES $scripts/PARTIAL_PACKAGES; do
	if [ ! -f $i ]; then
		echo "Can't open $i"
		exit -1
	fi
done

# Expand the package names into full pathnames.
PACKAGE_PATHS=`make_paths \`cat $scripts/PACKAGES\``
PARTIAL_PACKAGE_PATHS=`make_paths \`cat $scripts/PARTIAL_PACKAGES\``

rm -f -r $B $P # Paranoia.

for i in $PACKAGE_PATHS; do
	echo Extracting $i 1>&2
	dpkg-deb --extract $i $B
done

for i in $PARTIAL_PACKAGE_PATHS; do
	echo Extracting $i 1>&2
	dpkg-deb --extract $i $P
done

(cd $P; tar -cf - `cat $scripts/PARTIAL_PACKAGE_FILES`) \
 |(cd $B;tar xvlpf -)

cp $archive/Packages $B/var/lib/dpkg/available

ROOT=$B $B/tmp/base.postinst
rm -f $B/tmp/base.postinst

# Miscelaneous links normaly done by the postinst scripts.
if [ ! -f $B/etc/ld.so.cache ]; then
	cp /etc/ld.so.cache $B/etc/ld.so.cache
	chmod 644 $B/etc/ld.so.cache
	chown root.root $B/etc/ld.so.cache
fi

if [ ! -f $B/lib/ld-linux.so.1 ]; then
	(cd $B/lib; ln -s ld-linux.so.1.* ld-linux.so.1)
fi

if [ ! -f $B/usr/bin/perl -a -f $B/usr/bin/perl* ]; then
	(cd $B/usr/bin; mv perl* perl)
fi

(cd $B; chroot $B sbin/ldconfig*)
trap "umount $B/proc" 0
chroot $B mount -t proc proc /proc
(cd $B;dpkg --root=. --install `make_paths base/ld.so`)
(cd $B;dpkg --root=. --force-depends --install `make_paths base/dpkg`)
(cd $B;dpkg --root=. --install `make_paths base/libc5`)

chroot $B /sbin/ldconfig
(cd $B;dpkg --root=. --unpack --force-auto-select \
 --force-depends --force-overwrite $PACKAGE_PATHS)
mv $B/usr/sbin/start-stop-daemon $B/usr/sbin/start-stop-daemon.REAL
cp $B/bin/true $B/usr/sbin/start-stop-daemon
(cd $B/etc; ln -s ../usr/lib/zoneinfo/Factory localtime)
echo America/Los_Angeles > $B/etc/timezone # Avoid post-inst question.
chmod 644 $B/etc/localtime $B/etc/timezone
(cd $B;yes N | dpkg --root=. --configure --pending --force-configure-any \
 --force-depends)
mv $B/usr/sbin/start-stop-daemon.REAL $B/usr/sbin/start-stop-daemon
echo Factory > $B/etc/timezone
chroot $B umount /proc
trap 0

(find $B -name '*.dpkg-old' -exec rm -f \{\} \; ; true)
rm -f $B/var/lib/dpkg/status-old
(cd $B; tar clf - .)| gzip --best > base1_1.tgz
rm -f -r $B $P &
./utilities/floppy_split base1_1.tgz base14 1440
./utilities/floppy_split base1_1.tgz base12 1200
exit 0
