/*
 * dmnt.c - PTX mount support functions for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1995 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dmnt.c,v 1.3 95/10/23 13:04:30 abe Exp $";
#endif


#include "lsof.h"


/*
 * readvfs() - read vfs structure
 */

struct l_vfs *
readvfs(ka)
	struct vfs *ka;			/* vfs structure kernel address */
{
	dev_t d;
	struct mount m;
	struct vfs tv;
	struct vnode v;
	struct l_vfs *vp;

#if	defined(HAS_NFS)
	struct mntinfo mi;
#endif	/* defined(HAS_NFS) */

	if (!ka)
		return(NULL);
	for (vp = Lvfs; vp; vp = vp->next) {
		if (ka == vp->addr)
			return(vp);
	}
	if ((vp = (struct l_vfs *)malloc(sizeof(struct l_vfs))) == NULL) {
		(void) fprintf(stderr, "%s: PID %d, no space for vfs\n",
			Pn, Lp->pid);
		exit(1);
	}
	vp->dir = NULL;
	vp->fsname = NULL;
	if (kread((KA_T)ka, (char *)&tv, sizeof(tv))) {
		(void) free((FREE_P *)vp);
		return(NULL);
	}

#if	defined(HASFSINO)
	vp->fs_ino = 0;
#endif	/* defined(HASFSINO) */

	d = 0;
	if (tv.vfs_data) {

	/*
	 * Get device number.
	 */

#if	defined(HAS_NFS)
	    if (Ntype == N_NFS) {

	    /*
	     * PTX NFS devices have a major device number of 255.  The minor
	     * device number is a serial found in the mntinfo structure
	     * addressed by the virtual file system's vfs_data pointer.
	     */
		if (kread((KA_T)tv.vfs_data, (char *)&mi, sizeof(mi)) == 0)
		    d = (dev_t)makedev(255, (int)mi.mi_mntno);
	    } else
#endif	/* defined(HAS_NFS) */

	    {

	    /*
	     * The device number for non-NFS devices comes from the vnode
	     * of the block device on which the file system is mounted.
	     */
		if (kread((KA_T)tv.vfs_data, (char *)&m, sizeof(m)) == 0
		&&  m.m_devvp
		&&  kread((KA_T)m.m_devvp, (char *)&v, sizeof(v)) == 0)
		    d = v.v_rdev;
	    }
	}
	(void) completevfs(vp, &d);
	vp->next = Lvfs;
	vp->addr = ka;
	Lvfs = vp;
	return(vp);
}


/*
 * The readmnt() function is obtained from ../common/rmnt.frag.
 * The completevfs() function is obtained from ../common/cvfs.frag.
 */

#define	CVFS_DEVSAVE 	1
#define	EXPDEV(n)	n
/* MNTSKIP is not defined. */
#define	USECVFS		1
