// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/
#ifndef _LYXSCREEN_H
#define _LYXSCREEN_H

#include "forms.h"
#include <X11/Xlib.h>
#include "lyxtext.h"

typedef unsigned short Dimension;

/* The class LyXScreen is used for the main Textbody. Because of the
 * powerful Text-Class the implementation is not too difficult.
 * Variations of the Screen-class can be used to implement an
 * easy-to-use editor for tabulars.
 */

class LyXScreen {
private:
  Dimension height;
  Dimension width;
  FL_OBJECT* canvas;
   
  long screen_refresh_y;
   
  Row *screen_refresh_row;
   

   
  friend class InsetFormula;  
public:
   
  /* Konstruktor needs only the DrawingArea, because screen will 
   * use its full size. */
//   LyXScreen(Window drawingarea, int h, int w, LyXText *text_ptr);
  LyXScreen(FL_OBJECT* ob, LyXText *text_ptr);
  ~LyXScreen();

  void LyXExpose(int x, int y, int exp_width, int exp_height); 

  long first;		       /* first visible pixel-row  */


  /* y1 and y2 are coordinates of the screen */ 
  void DrawFromTo(int y1, int y2);
   
  /* y is a coordinate of the text */ 
  void DrawOneRow(Row* row, long &y_text);
   
   
   
   
  LyXText *text;
   
  void Draw(long y );
  
  void Redraw();
   
  /* returns a new top so that the cursor is visible */
  long TopCursorVisible(); 
  int FitCursor();
  void ShowCursor();
  void HideCursor();
  void CursorHi();
  void CursorLo();
  void CursorToggle();

  void DrawManualCursor(long x, long y, int asc, int desc);
  /* returns 1 if first has changed, otherwise 0 */ 
  int  FitManualCursor(long, long, int, int);
  void DrawManualSelection(int x, int y, int w, int h);
    
  bool cursor_visible;		       /* just a boolean flag  */

  void ToggleSelection();
  void ToggleToggle();

  void Update();
  void SmallUpdate();
};

#endif
