/****************************************************************************
** $Id: qtooltip.h,v 2.13 1997/03/20 21:11:47 agulbra Exp $
**
** Tool Tips (or Balloon Help) for any widget or rectangle
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.2.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the one in the commercial distribution of
** Qt only by this comment.)
**
*****************************************************************************/

#ifndef QTOOLTIP_H
#define QTOOLTIP_H

#include "qobject.h"
#include "qrect.h"
#include "qtimer.h"
#include "qintdict.h"

class QWidget;
class QTipManager;
class QLabel;

class QToolTipGroup: public QObject
{
    Q_OBJECT
public:
    QToolTipGroup( QObject *parent, const char *name = 0 );
   ~QToolTipGroup();

signals:
    void showTip( const char * );
    void removeTip();

private:
    friend class QTipManager;
};


class QToolTip
{
public:
    QToolTip( QWidget *, QToolTipGroup * = 0 );

    static void add( QWidget *, const char * );
    static void add( QWidget *, const char *,
		     QToolTipGroup *, const char * );
    static void remove( QWidget * );

    static void add( QWidget *, const QRect &, const char * );
    static void add( QWidget *, const QRect &, const char *,
		     QToolTipGroup *, const char * );
    static void remove( QWidget *, const QRect & );

protected:
    virtual void maybeTip( const QPoint & ) = 0;
    void tip( const QRect &, const char * );
    void tip( const QRect &, const char *, const char * );
    void clear();

public:
    QWidget * parentWidget() const { return p; }
    QToolTipGroup * group() const { return g; }

private:
    QWidget * p;
    QToolTipGroup * g;

    friend class QTipManager;
};

#endif
