/****************************************************************************
** $Id: qtabbar.h,v 2.4 1997/02/14 22:22:22 agulbra Exp $
**
** Definition of QTabBar class
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.2.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the one in the commercial distribution of
** Qt only by this comment.)
**
*****************************************************************************/

#ifndef QTABBAR_H
#define QTABBAR_H

#include "qwidget.h"
#include "qpainter.h"
#include "qlist.h"

struct QTabPrivate;


struct QTab
{
    virtual ~QTab();

    QString label;
    // the bounding rectangle of this - may overlap with others
    QRect r;
    bool enabled;
    int id;
};


class QTabBar: public QWidget
{
    Q_OBJECT

public:
    QTabBar( QWidget * parent = 0, const char * name = 0 );
   ~QTabBar();

    void  show();

    virtual int addTab( QTab * );

    void  setTabEnabled( int, bool );
    bool  isTabEnabled( int ) const;

    QSize sizeHint() const;

    int currentTab() const;
    int keyboardFocusTab() const;

signals:
    void  selected( int );

protected:
    virtual void paint( QPainter *, QTab *, bool ) const;
    virtual QTab * selectTab( const QPoint & p ) const;

    void paintEvent( QPaintEvent * );
    void mousePressEvent ( QMouseEvent * );
    void mouseReleaseEvent ( QMouseEvent * );
    void keyPressEvent( QKeyEvent * );

private:
    QListT<QTab> * l;
    QTabPrivate * d;
};


#endif // QTABBAR_H
