/**********************************************************************
** $Id: qgrpbox.h,v 2.0 1996/09/24 10:16:18 agulbra Exp $
**
** Definition of QGroupBox widget class
**
** Created : 950203
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.2.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the one in the commercial distribution of
** Qt only by this comment.)
**
*****************************************************************************/

#ifndef QGRPBOX_H
#define QGRPBOX_H

#include "qframe.h"


class QGroupBox : public QFrame
{
    Q_OBJECT
public:
    QGroupBox( QWidget *parent=0, const char *name=0 );
    QGroupBox( const char *title, QWidget *parent=0, const char *name=0 );

    const char *title()		const	{ return str; }

    void	setTitle( const char * );

    int		alignment()	const	{ return align; }
    void	setAlignment( int );

protected:
    void	paintEvent( QPaintEvent * );

private:
    void	init();
    QString	str;
    int		align;

private:	// Disabled copy constructor and operator=
    QGroupBox( const QGroupBox & ) {}
    QGroupBox &operator=( const QGroupBox & ) { return *this; }
};


#endif // QGRPBOX_H
