/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef traitRefNodeLIST_H
# define traitRefNodeLIST_H

typedef /*@only@*/ traitRefNode o_traitRefNode;

abst_typedef struct _traitRefNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_traitRefNode  *elements;
} *traitRefNodeList ;

/*@iter traitRefNodeList_elements (sef traitRefNodeList x, yield exposed traitRefNode el); @*/
# define traitRefNodeList_elements(x, m_el) \
   { int m_ind; traitRefNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { traitRefNode m_el = *(m_elements++); 

# define end_traitRefNodeList_elements }}

extern /*@only@*/ traitRefNodeList traitRefNodeList_new(void);
extern traitRefNodeList 
  traitRefNodeList_add (/*@returned@*/ traitRefNodeList s, /*@only@*/ traitRefNode el);

extern /*@only@*/ cstring traitRefNodeList_unparse (traitRefNodeList s) ;
extern void traitRefNodeList_free (/*@only@*/ traitRefNodeList s) ;

/*@constant int traitRefNodeListBASESIZE;@*/
# define traitRefNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




