/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*   Llib/error.scm                                                    */
/*   Bigloo (v1.8)                                                     */
/*   Manuel Serrano (c)       Thu Apr 11 10:48:22 PDT 1996             */
/*=====================================================================*/
#define THE_GC BOEHM_GC
#define BIGLOO_DEBUG 1

#include <bigloo.h>
#include <signal.h>

/* The C generated type (for typed structures) */
extern obj_t _notify_error___error_188( obj_t, obj_t, obj_t, obj_t );
extern obj_t close_input_port( obj_t );
DEFINE_STRING( string1223___error, aux1718, "#", 1 );
static obj_t symbol1217___error = BUNSPEC;
extern obj_t string_to_bstring( char * );
obj_t __error_notifier____error_43 = BUNSPEC;
static obj_t symbol1245___error = BUNSPEC;
extern obj_t the_failure( obj_t, obj_t, obj_t );
extern obj_t warning___error( obj_t );
static obj_t sigill_error_handler___error_101( obj_t );
extern obj_t _type_error_msg___error_185( obj_t, obj_t, obj_t );
DEFINE_STRING( string1225___error, aux1719, "# *** WARNING:bigloo:", 21 );
static obj_t sigsegv_error_handler___error_53( obj_t );
DEFINE_STRING( string1224___error, aux1720, "^", 1 );
DEFINE_STRING( string1243___error, aux1721, "Not an error handler", 20 );
static obj_t *__cnst;
extern obj_t check_version____bigloo_18( obj_t, char *, obj_t );
DEFINE_STRING( string1239___error, aux1722, "' expected, `", 13 );
static obj_t lambda1148_local1214( obj_t, obj_t, obj_t, obj_t );
extern obj_t current_output_port;
extern bool_t bigloo_strcmp( obj_t, obj_t );
extern obj_t error___error( obj_t, obj_t, obj_t );
DEFINE_STRING( string1226___error, aux1723, "# *** ERROR:bigloo:", 19 );
DEFINE_STRING( string1221___error, aux1724, ", character ", 12 );
static obj_t tvectors_declarations____error_145();
DEFINE_STRING( string1218___error, aux1725, "", 0 );
extern obj_t current_error_port;
DEFINE_STRING( string1219___error, aux1732, "File \"", 6 );
obj_t __trace_stack_depth____error_68 = BUNSPEC;
extern obj_t dump_trace_stack( obj_t, long );
extern obj_t initialization___error();
extern obj_t initialization___r4_input_6_10_2();
extern long get_write_length___r4_output_6_10_3_33();
extern obj_t _remove_error_handler____error_91( obj_t );
extern obj_t fprint___r4_output_6_10_3( obj_t, obj_t );
DEFINE_STRING( string1229___error, aux1733, "[string]", 8 );
extern obj_t set_write_length____r4_output_6_10_3_231( long );
DEFINE_STRING( string1220___error, aux1734, "\", line ", 8 );
extern obj_t notify_error___error_79( obj_t, obj_t, obj_t );
extern obj_t make_string( long, unsigned char );
extern obj_t error_location___error_27( obj_t, obj_t, obj_t, obj_t, obj_t );
DEFINE_STRING( string1231___error, aux1735, "bigloo", 6 );
static obj_t _sigsegv_error_handler___error_73( obj_t, obj_t );
extern obj_t string_to_symbol( char * );
extern obj_t newline___r4_output_6_10_3( obj_t );
DEFINE_STRING( string1235___error, aux1736, "`illegal instruction' exception", 31 );
obj_t __warning____error_23 = BUNSPEC;
static obj_t nice_fname___error_199( obj_t );
extern obj_t display___r4_output_6_10_3( obj_t, obj_t );
extern obj_t signal___unix( int, obj_t );
DEFINE_STRING( string1236___error, aux1737, "arithmetic procedure", 20 );
DEFINE_STRING( string1241___error, aux1738, "*** ERROR:bigloo:", 17 );
static obj_t sigfpe_error_handler___error_53( obj_t );
static obj_t _sigbus_error_handler___error_220( obj_t, obj_t );
extern obj_t type_error_msg___error_34( obj_t, obj_t );
static obj_t fix_tabulation____error_157( obj_t, obj_t, obj_t );
extern obj_t _error___error( obj_t, obj_t, obj_t, obj_t );
DEFINE_STRING( string1238___error, aux1739, "`", 1 );
extern obj_t _warning___error( obj_t, obj_t );
extern obj_t read_line___r4_input_6_10_2_179( obj_t );
extern obj_t open_input_file___r4_ports_6_10_1_217( obj_t, obj_t );
static obj_t _sigfpe_error_handler___error_141( obj_t, obj_t );
DEFINE_STRING( string1230___error, aux1740, "[stdin]", 7 );
extern obj_t _error_location_file___error_37( obj_t, obj_t, obj_t );
extern obj_t add_error_handler____error_177( obj_t, obj_t );
DEFINE_STRING( string1237___error, aux1741, "`floating point' exception", 26 );
extern obj_t exit___error( long );
DEFINE_STRING( string1240___error, aux1742, "' provided.", 11 );
static obj_t do_warn_location___error_83( obj_t, long, obj_t, obj_t, long, obj_t );
extern obj_t reader_reset____reader_111();
DEFINE_STRING( string1234___error, aux1743, "`bus error' exception", 21 );
extern obj_t remove_error_handler____error_182();
DEFINE_STRING( string1232___error, aux1744, "`segmentation violation' exception", 34 );
extern obj_t string_append___r4_strings_6_7_48( obj_t );
DEFINE_STRING( string1242___error, aux1745, "error", 5 );
extern obj_t _add_error_handler____error_22( obj_t, obj_t, obj_t );
extern obj_t error_location_file___error_127( obj_t, obj_t );
extern obj_t _the_c_failure___error( obj_t, obj_t, obj_t, obj_t );
static obj_t initialize_constants____error_137();
extern obj_t _warning_location___error_194( obj_t, obj_t, obj_t, obj_t );
extern obj_t _error_location___error_121( obj_t, obj_t, obj_t, obj_t, obj_t, obj_t );
DEFINE_STRING( string1222___error, aux1746, ":", 1 );
DEFINE_STRING( string1227___error, aux1747, "# ", 2 );
DEFINE_STRING( string1228___error, aux1748, " -- ", 4 );
DEFINE_STRING( string1244___error, aux1749, "*** WARNING:bigloo:", 19 );
extern obj_t warning_location___error_232( obj_t, obj_t, obj_t );
extern obj_t c_substring( obj_t, long, long );
extern obj_t the_c_failure( char *, char *, obj_t );
static obj_t initialize_imported_modules____error_54();
extern obj_t pwd___unix();
static obj_t _sigill_error_handler___error_139( obj_t, obj_t );
extern obj_t _exit___error( obj_t, obj_t );
extern obj_t _the_failure___error( obj_t, obj_t, obj_t, obj_t );
DEFINE_STRING( string1233___error, aux1750, "reached", 7 );
static obj_t require_initialization____error_227 = BUNSPEC;
static obj_t __error_handler____error_55 = BUNSPEC;
static obj_t sigbus_error_handler___error_153( obj_t );
obj_t __debug____error_22 = BUNSPEC;

DEFINE_EXPORT_PROCEDURE( remove_error_handler__env___error_114, aux1751, _remove_error_handler____error_91, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( type_error_msg_env___error_70, aux1752, _type_error_msg___error_185, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( notify_error_env___error_195, aux1753, _notify_error___error_188, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( error_env___error_216, aux1754, _error___error, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( warning_location_env___error_237, aux1755, va_generic_entry, _warning_location___error_194, -3 );
DEFINE_STATIC_PROCEDURE( sigfpe_error_handler_env___error_162, aux1756, _sigfpe_error_handler___error_141, 0L, 1 );
DEFINE_STATIC_PROCEDURE( sigbus_error_handler_env___error_80, aux1758, _sigbus_error_handler___error_220, 0L, 1 );
DEFINE_STATIC_PROCEDURE( sigill_error_handler_env___error_108, aux1759, _sigill_error_handler___error_139, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( error_location_env___error_117, aux1761, _error_location___error_121, 0L, 5 );
DEFINE_STATIC_PROCEDURE( sigsegv_error_handler_env___error_162, aux1762, _sigsegv_error_handler___error_73, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( exit_env___error_233, aux1763, _exit___error, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( error_location_file_env___error_127, aux1764, _error_location_file___error_37, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( the_c_failure_env___error_41, aux1765, _the_c_failure___error, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( add_error_handler__env___error_173, aux1766, _add_error_handler____error_22, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( warning_env___error_56, aux1767, va_generic_entry, _warning___error, -1 );
DEFINE_EXPORT_PROCEDURE( the_failure_env___error_115, aux1768, _the_failure___error, 0L, 3 );

obj_t initialization___error()
{if(CBOOL(require_initialization____error_227)){require_initialization____error_227 = BFALSE;
initialize_imported_modules____error_54();
tvectors_declarations____error_145();
initialize_constants____error_137();
{obj_t aux1209_981;
aux1209_981 = symbol1245___error;
check_version____bigloo_18(aux1209_981, "Bigloo (v1.8)", BCHAR(((unsigned char)'b')));
}require_initialization____error_227 = BFALSE;
__debug____error_22 = BINT(0);
__warning____error_23 = BTRUE;
__trace_stack_depth____error_68 = BINT(10);
__error_handler____error_55 = BNIL;
__error_notifier____error_43 = BUNSPEC;
signal___unix(SIGFPE, sigfpe_error_handler_env___error_162);
signal___unix(SIGILL, sigill_error_handler_env___error_108);
signal___unix(SIGBUS, sigbus_error_handler_env___error_80);
signal___unix(SIGSEGV, sigsegv_error_handler_env___error_162);
return BUNSPEC;
} else {return BUNSPEC;
}}

obj_t initialize_imported_modules____error_54()
{initialization___r4_input_6_10_2();
return BUNSPEC;
}

obj_t initialize_constants____error_137()
{symbol1217___error = string_to_symbol("DONE");
symbol1245___error = string_to_symbol("__ERROR");
return BUNSPEC;
}

obj_t tvectors_declarations____error_145()
{return BUNSPEC;
}

obj_t exit___error(long n_791)
{exit(n_791);
return BINT(n_791);
}

obj_t _exit___error(obj_t env_1321, obj_t n_1322)
{return exit___error((long)CINT(n_1322));
}

obj_t add_error_handler____error_177(obj_t handler_794, obj_t escape_795)
{{obj_t aux1104_796;
aux1104_796 = MAKE_PAIR(handler_794, escape_795);
{obj_t obj2_1146;
obj2_1146 = __error_handler____error_55;
return (__error_handler____error_55 = MAKE_PAIR(aux1104_796, obj2_1146),
BUNSPEC);
}}}

obj_t _add_error_handler____error_22(obj_t env_1323, obj_t handler_1324, obj_t escape_1325)
{return add_error_handler____error_177(handler_1324, escape_1325);
}

obj_t remove_error_handler____error_182()
{{bool_t test1691_1723;
{obj_t obj_1147;
obj_1147 = __error_handler____error_55;
test1691_1723 = PAIRP(obj_1147);
}if(test1691_1723){obj_t pair_1148;
pair_1148 = __error_handler____error_55;
__error_handler____error_55 = CDR(pair_1148);
} else {BUNSPEC;
}}return __error_handler____error_55;
}

obj_t _remove_error_handler____error_91(obj_t env_1326)
{return remove_error_handler____error_182();
}

obj_t error___error(obj_t proc_797, obj_t message_798, obj_t object_799)
{FAILURE(proc_797,message_798,object_799);}

obj_t _error___error(obj_t env_1327, obj_t proc_1328, obj_t message_1329, obj_t object_1330)
{return error___error(proc_1328, message_1329, object_1330);
}

obj_t warning___error(obj_t args_800)
{if(CBOOL(__warning____error_23)){{obj_t aux1105_801;
aux1105_801 = current_output_port;
FLUSH_OUTPUT_PORT(aux1105_801);
}{obj_t aux1106_802;
aux1106_802 = current_error_port;
newline___r4_output_6_10_3(MAKE_PAIR(aux1106_802, BNIL));
}{obj_t aux1110_803;
aux1110_803 = current_error_port;
display___r4_output_6_10_3(string1244___error, MAKE_PAIR(aux1110_803, BNIL));
}if(NULLP(args_800)){BUNSPEC;
} else {{obj_t aux1111_804;
aux1111_804 = current_error_port;
{obj_t aux1112_805;
aux1112_805 = CAR(args_800);
fprint___r4_output_6_10_3(aux1111_804, MAKE_PAIR(aux1112_805, BNIL));
}}{obj_t l1003_807;
{obj_t aux1116_811;
aux1116_811 = CDR(args_800);
{bool_t aux1678_1709;
l1003_807 = aux1116_811;
lname1004_806:
if(PAIRP(l1003_807)){{obj_t a_808;
a_808 = CAR(l1003_807);
{obj_t aux1113_809;
aux1113_809 = current_error_port;
display___r4_output_6_10_3(a_808, MAKE_PAIR(aux1113_809, BNIL));
}}{obj_t aux1115_810;
aux1115_810 = CDR(l1003_807);
{obj_t l1003_1716;
l1003_1716 = aux1115_810;
l1003_807 = l1003_1716;
goto lname1004_806;
}}} else {aux1678_1709 = ((bool_t)1);
}BBOOL(aux1678_1709);
}}}}{obj_t aux1117_812;
aux1117_812 = current_error_port;
return newline___r4_output_6_10_3(MAKE_PAIR(aux1117_812, BNIL));
}} else {return BUNSPEC;
}}

obj_t _warning___error(obj_t env_1331, obj_t args_1332)
{return warning___error(args_1332);
}

obj_t warning_location___error_232(obj_t fname_813, obj_t location_814, obj_t args_815)
{if(CBOOL(__warning____error_23)){bool_t test1631_1663;
{obj_t string2_1155;
string2_1155 = string1229___error;
test1631_1663 = bigloo_strcmp(fname_813, string2_1155);
}if(test1631_1663){return warning___error(args_815);
} else {bool_t test1634_1666;
{obj_t string2_1157;
string2_1157 = string1230___error;
test1634_1666 = bigloo_strcmp(fname_813, string2_1157);
}if(test1634_1666){return warning___error(args_815);
} else {obj_t port_1158;
port_1158 = open_input_file___r4_ports_6_10_1_217(fname_813, BNIL);
if(INPUT_PORTP(port_1158)){obj_t line_string_1161_13;
long line_num_1162_200;
{obj_t aux1173_1160;
aux1173_1160 = read_line___r4_input_6_10_2_179(port_1158);
line_string_1161_13 = aux1173_1160;
line_num_1162_200 = 1;
loop_1159:
if(EOF_OBJECTP(line_string_1161_13)){close_input_port(port_1158);
return warning___error(args_815);
} else {bool_t test1645_1677;
{long aux1157_1163;
aux1157_1163 = INPUT_PORT_FILEPOS(port_1158);
test1645_1677 = (aux1157_1163>=(long)CINT(location_814));
}if(test1645_1677){close_input_port(port_1158);
{long aux1159_1164;
{long aux1160_1165;
{long aux1162_1166;
aux1162_1166 = STRING_LENGTH(line_string_1161_13);
{long aux1164_1167;
{long aux1166_1168;
aux1166_1168 = INPUT_PORT_FILEPOS(port_1158);
aux1164_1167 = (aux1166_1168-(long)CINT(location_814));
}aux1160_1165 = (aux1162_1166-aux1164_1167);
}}aux1159_1164 = (aux1160_1165+1);
}return do_warn_location___error_83(fname_813, line_num_1162_200, location_814, line_string_1161_13, aux1159_1164, args_815);
}} else {long old_pos_1169_144;
old_pos_1169_144 = INPUT_PORT_FILEPOS(port_1158);
{obj_t aux1168_1170;
aux1168_1170 = read_line___r4_input_6_10_2_179(port_1158);
{long aux1169_1171;
aux1169_1171 = (line_num_1162_200+1);
{long line_num_1693_113;
obj_t line_string_1692_33;
line_string_1692_33 = aux1168_1170;
line_num_1693_113 = aux1169_1171;
line_num_1162_200 = line_num_1693_113;
line_string_1161_13 = line_string_1692_33;
goto loop_1159;
}}}}}}} else {return warning___error(args_815);
}}}} else {return BUNSPEC;
}}

obj_t _warning_location___error_194(obj_t env_1333, obj_t fname_1334, obj_t location_1335, obj_t args_1336)
{return warning_location___error_232(fname_1334, location_1335, args_1336);
}

obj_t the_failure(obj_t proc_816, obj_t message_817, obj_t object_818)
{reader_reset____reader_111();
{bool_t test1604_1640;
{obj_t obj_1185;
obj_1185 = __error_handler____error_55;
test1604_1640 = PAIRP(obj_1185);
}if(test1604_1640){obj_t handler_819;
obj_t escape_820;
{obj_t aux1608_1642;
{obj_t pair_1186;
pair_1186 = __error_handler____error_55;
aux1608_1642 = CAR(pair_1186);
}handler_819 = CAR(aux1608_1642);
}{obj_t aux1612_1645;
{obj_t pair_1188;
pair_1188 = __error_handler____error_55;
aux1612_1645 = CAR(pair_1188);
}escape_820 = CDR(aux1612_1645);
}remove_error_handler____error_182();
{bool_t test1616_1649;
if(PROCEDUREP(handler_819)){long aux1119_821;
aux1119_821 = PROCEDURE_ARITY(handler_819);
test1616_1649 = (aux1119_821==4);
} else test1616_1649 = ((bool_t)0);
if(test1616_1649){return PROCEDURE_ENTRY(handler_819)(handler_819, escape_820, proc_816, message_817, object_818, BEOA);
} else {notify_error___error_79(string1242___error, string1243___error, handler_819);
return BINT(-1);
}}} else {notify_error___error_79(proc_816, message_817, object_818);
return BINT(-1);
}}}

obj_t _the_failure___error(obj_t env_1337, obj_t proc_1338, obj_t message_1339, obj_t object_1340)
{return the_failure(proc_1338, message_1339, object_1340);
}

obj_t the_c_failure(char * proc_824, char * message_825, obj_t object_826)
{return the_failure(string_to_bstring(proc_824), string_to_bstring(message_825), object_826);
}

obj_t _the_c_failure___error(obj_t env_1341, obj_t proc_1342, obj_t message_1343, obj_t object_1344)
{return the_c_failure(BSTRING_TO_STRING(proc_1342), BSTRING_TO_STRING(message_1343), object_1344);
}

obj_t notify_error___error_79(obj_t proc_827, obj_t mes_828, obj_t obj_829)
{{bool_t test1564_1602;
{obj_t obj_1192;
obj_1192 = __error_notifier____error_43;
test1564_1602 = PROCEDUREP(obj_1192);
}if(test1564_1602){return PROCEDURE_ENTRY(__error_notifier____error_43)(__error_notifier____error_43, proc_827, mes_828, obj_829, BEOA);
} else {{obj_t aux1124_830;
aux1124_830 = current_output_port;
FLUSH_OUTPUT_PORT(aux1124_830);
}{obj_t aux1125_831;
aux1125_831 = current_error_port;
newline___r4_output_6_10_3(MAKE_PAIR(aux1125_831, BNIL));
}{long old_length_832_124;
old_length_832_124 = get_write_length___r4_output_6_10_3_33();
set_write_length____r4_output_6_10_3_231(80);
{obj_t aux1128_833;
aux1128_833 = current_error_port;
display___r4_output_6_10_3(string1241___error, MAKE_PAIR(aux1128_833, BNIL));
}{obj_t aux1129_834;
aux1129_834 = current_error_port;
fprint___r4_output_6_10_3(aux1129_834, MAKE_PAIR(proc_827, MAKE_PAIR(string1222___error, MAKE_PAIR(BCHAR(((unsigned char)'\n')), MAKE_PAIR(mes_828, MAKE_PAIR(string1228___error, MAKE_PAIR(obj_829, BNIL)))))));
}{bool_t test1585_1621;
{bool_t test1586_1622;
{obj_t obj_1194;
obj_1194 = __debug____error_22;
test1586_1622 = INTEGERP(obj_1194);
}if(test1586_1622)test1585_1621 = ((long)CINT(__debug____error_22)>0);
 else test1585_1621 = ((bool_t)0);
}if(test1585_1621){obj_t depth_1197;
{bool_t test1590_1626;
{obj_t obj_1198;
obj_1198 = __trace_stack_depth____error_68;
test1590_1626 = INTEGERP(obj_1198);
}if(test1590_1626){depth_1197 = __trace_stack_depth____error_68;
} else {depth_1197 = BINT(10);
}}{obj_t aux1103_1199;
aux1103_1199 = current_error_port;
dump_trace_stack(aux1103_1199, (long)CINT(depth_1197));
}} else {BUNSPEC;
}}return set_write_length____r4_output_6_10_3_231(old_length_832_124);
}}}}

obj_t _notify_error___error_188(obj_t env_1345, obj_t proc_1346, obj_t mes_1347, obj_t obj_1348)
{return notify_error___error_79(proc_1346, mes_1347, obj_1348);
}

obj_t type_error_msg___error_34(obj_t from_835, obj_t to_836)
{{obj_t aux1131_837;
aux1131_837 = SYMBOL_TO_STRING(to_836);
{obj_t aux1132_838;
aux1132_838 = SYMBOL_TO_STRING(from_835);
return string_append___r4_strings_6_7_48(MAKE_PAIR(string1238___error, MAKE_PAIR(aux1131_837, MAKE_PAIR(string1239___error, MAKE_PAIR(aux1132_838, MAKE_PAIR(string1240___error, BNIL))))));
}}}

obj_t _type_error_msg___error_185(obj_t env_1349, obj_t from_1350, obj_t to_1351)
{return type_error_msg___error_34(from_1350, to_1351);
}

obj_t sigfpe_error_handler___error_53(obj_t n_848)
{FAILURE(string1236___error,string1237___error,string1233___error);}

obj_t _sigfpe_error_handler___error_141(obj_t env_1313, obj_t n_1314)
{return sigfpe_error_handler___error_53(n_1314);
}

obj_t sigill_error_handler___error_101(obj_t n_850)
{FAILURE(string1231___error,string1235___error,string1233___error);}

obj_t _sigill_error_handler___error_139(obj_t env_1315, obj_t n_1316)
{return sigill_error_handler___error_101(n_1316);
}

obj_t sigbus_error_handler___error_153(obj_t n_852)
{FAILURE(string1231___error,string1234___error,string1233___error);}

obj_t _sigbus_error_handler___error_220(obj_t env_1317, obj_t n_1318)
{return sigbus_error_handler___error_153(n_1318);
}

obj_t sigsegv_error_handler___error_53(obj_t n_854)
{FAILURE(string1231___error,string1232___error,string1233___error);}

obj_t _sigsegv_error_handler___error_73(obj_t env_1319, obj_t n_1320)
{return sigsegv_error_handler___error_53(n_1320);
}

obj_t error_location___error_27(obj_t proc_855, obj_t message_856, obj_t object_857, obj_t fname_858, obj_t location_859)
{if(STRINGP(fname_858)){if(INTEGERP(location_859)){bool_t test1523_1574;
{obj_t string2_1203;
string2_1203 = string1229___error;
test1523_1574 = bigloo_strcmp(fname_858, string2_1203);
}if(test1523_1574){FAILURE(proc_855,message_856,object_857);} else {bool_t test1528_1577;
{obj_t string2_1205;
string2_1205 = string1230___error;
test1528_1577 = bigloo_strcmp(fname_858, string2_1205);
}if(test1528_1577){FAILURE(proc_855,message_856,object_857);} else {__error_notifier____error_43 = error_location_file___error_127(fname_858, location_859);
FAILURE(proc_855,message_856,object_857);}}} else {FAILURE(proc_855,message_856,object_857);}} else {FAILURE(proc_855,message_856,object_857);}}

obj_t _error_location___error_121(obj_t env_1352, obj_t proc_1353, obj_t message_1354, obj_t object_1355, obj_t fname_1356, obj_t location_1357)
{return error_location___error_27(proc_1353, message_1354, object_1355, fname_1356, location_1357);
}

obj_t error_location_file___error_127(obj_t file_name_860_238, obj_t location_861)
{{obj_t port_862;
port_862 = open_input_file___r4_ports_6_10_1_217(file_name_860_238, BNIL);
if(INPUT_PORTP(port_862)){obj_t line_string_864_56;
obj_t line_num_865_236;
{obj_t aux1147_875;
aux1147_875 = read_line___r4_input_6_10_2_179(port_862);
line_string_864_56 = aux1147_875;
line_num_865_236 = BINT(1);
loop_863:
if(EOF_OBJECTP(line_string_864_56)){close_input_port(port_862);
return BFALSE;
} else {bool_t test1483_1543;
{long aux1133_866;
aux1133_866 = INPUT_PORT_FILEPOS(port_862);
test1483_1543 = (aux1133_866>=(long)CINT(location_861));
}if(test1483_1543){close_input_port(port_862);
{obj_t aux1134_867;
{long aux1137_868;
{long aux1138_869;
aux1138_869 = STRING_LENGTH(line_string_864_56);
{long aux1142_870;
{long aux1143_871;
aux1143_871 = INPUT_PORT_FILEPOS(port_862);
aux1142_870 = (aux1143_871-(long)CINT(location_861));
}aux1137_868 = (aux1138_869-aux1142_870);
}}aux1134_867 = BINT((aux1137_868+1));
}{obj_t lambda1148_1370;
lambda1148_1370 = make_fx_procedure(lambda1148_local1214, 3, 5);
PROCEDURE_SET(lambda1148_1370, 0, aux1134_867);
PROCEDURE_SET(lambda1148_1370, 1, line_string_864_56);
PROCEDURE_SET(lambda1148_1370, 2, file_name_860_238);
PROCEDURE_SET(lambda1148_1370, 3, line_num_865_236);
PROCEDURE_SET(lambda1148_1370, 4, location_861);
{return lambda1148_1370;
}}}} else {long old_pos_872_97;
old_pos_872_97 = INPUT_PORT_FILEPOS(port_862);
{obj_t aux1145_873;
aux1145_873 = read_line___r4_input_6_10_2_179(port_862);
{long aux1146_874;
aux1146_874 = ((long)CINT(line_num_865_236)+1);
{obj_t line_num_1566_18;
obj_t line_string_1565_101;
line_string_1565_101 = aux1145_873;
line_num_1566_18 = BINT(aux1146_874);
line_num_865_236 = line_num_1566_18;
line_string_864_56 = line_string_1565_101;
goto loop_863;
}}}}}}} else {return BFALSE;
}}}

obj_t _error_location_file___error_37(obj_t env_1358, obj_t file_name_1359_177, obj_t location_1360)
{return error_location_file___error_127(file_name_1359_177, location_1360);
}

obj_t lambda1148_local1214(obj_t env_1361, obj_t proc_1367, obj_t msg_1368, obj_t obj_1369)
{{obj_t aux1134_1362;
obj_t line_string_1363_163;
obj_t file_name_1364_244;
obj_t line_num_1365_18;
obj_t location_1366;
aux1134_1362 = PROCEDURE_REF(env_1361, 0);
line_string_1363_163 = PROCEDURE_REF(env_1361, 1);
file_name_1364_244 = PROCEDURE_REF(env_1361, 2);
line_num_1365_18 = PROCEDURE_REF(env_1361, 3);
location_1366 = PROCEDURE_REF(env_1361, 4);
{obj_t proc_1218;
obj_t msg_1219;
obj_t obj_1220;
proc_1218 = proc_1367;
msg_1219 = msg_1368;
obj_1220 = obj_1369;
__error_notifier____error_43 = BFALSE;
{obj_t aux1151_1221;
aux1151_1221 = current_output_port;
FLUSH_OUTPUT_PORT(aux1151_1221);
}{obj_t aux1152_1222;
aux1152_1222 = current_error_port;
newline___r4_output_6_10_3(MAKE_PAIR(aux1152_1222, BNIL));
}{long old_length_1223_92;
obj_t space_string_1224_143;
old_length_1223_92 = get_write_length___r4_output_6_10_3_33();
if(((long)CINT(aux1134_1362)>0)){long aux1156_1225;
aux1156_1225 = ((long)CINT(aux1134_1362)-1);
{int k_1233;
obj_t char_1234;
k_1233 = (int)(aux1156_1225);
char_1234 = MAKE_PAIR(BCHAR(((unsigned char)' ')), BNIL);
if(NULLP(char_1234)){space_string_1224_143 = make_string((long)(k_1233), ((unsigned char)' '));
} else {obj_t aux1017_1235;
aux1017_1235 = CAR(char_1234);
space_string_1224_143 = make_string((long)(k_1233), (unsigned char)CCHAR(aux1017_1235));
}}} else {space_string_1224_143 = string1218___error;
}fix_tabulation____error_157(aux1134_1362, line_string_1363_163, space_string_1224_143);
{obj_t aux1196_1237;
aux1196_1237 = current_error_port;
{obj_t aux1197_1238;
aux1197_1238 = nice_fname___error_199(file_name_1364_244);
fprint___r4_output_6_10_3(aux1196_1237, MAKE_PAIR(string1219___error, MAKE_PAIR(aux1197_1238, MAKE_PAIR(string1220___error, MAKE_PAIR(line_num_1365_18, MAKE_PAIR(string1221___error, MAKE_PAIR(location_1366, MAKE_PAIR(string1222___error, MAKE_PAIR(BCHAR(((unsigned char)'\n')), MAKE_PAIR(string1223___error, MAKE_PAIR(line_string_1363_163, MAKE_PAIR(BCHAR(((unsigned char)'\n')), MAKE_PAIR(string1223___error, MAKE_PAIR(space_string_1224_143, MAKE_PAIR(string1224___error, BNIL)))))))))))))));
}}set_write_length____r4_output_6_10_3_231(80);
{obj_t aux1154_1226;
aux1154_1226 = current_error_port;
fprint___r4_output_6_10_3(aux1154_1226, MAKE_PAIR(string1226___error, MAKE_PAIR(proc_1218, BNIL)));
}{obj_t aux1155_1227;
aux1155_1227 = current_error_port;
fprint___r4_output_6_10_3(aux1155_1227, MAKE_PAIR(string1227___error, MAKE_PAIR(msg_1219, MAKE_PAIR(string1228___error, MAKE_PAIR(obj_1220, BNIL)))));
}{bool_t test1458_1524;
{bool_t test1459_1525;
{obj_t obj_1239;
obj_1239 = __debug____error_22;
test1459_1525 = INTEGERP(obj_1239);
}if(test1459_1525)test1458_1524 = ((long)CINT(__debug____error_22)>0);
 else test1458_1524 = ((bool_t)0);
}if(test1458_1524){obj_t depth_1242;
{bool_t test1464_1529;
{obj_t obj_1243;
obj_1243 = __trace_stack_depth____error_68;
test1464_1529 = INTEGERP(obj_1243);
}if(test1464_1529){depth_1242 = __trace_stack_depth____error_68;
} else {depth_1242 = BINT(10);
}}{obj_t aux1103_1244;
aux1103_1244 = current_error_port;
dump_trace_stack(aux1103_1244, (long)CINT(depth_1242));
}} else {BUNSPEC;
}}return set_write_length____r4_output_6_10_3_231(old_length_1223_92);
}}}}

obj_t do_warn_location___error_83(obj_t fname_923, long line_924, obj_t char_925, obj_t string_926, long marker_927, obj_t args_928)
{{obj_t aux1177_929;
aux1177_929 = current_output_port;
FLUSH_OUTPUT_PORT(aux1177_929);
}{obj_t aux1179_930;
aux1179_930 = current_error_port;
newline___r4_output_6_10_3(MAKE_PAIR(aux1179_930, BNIL));
}{long old_length_931_248;
obj_t space_string_932_182;
old_length_931_248 = get_write_length___r4_output_6_10_3_33();
if((marker_927>0)){long aux1190_943;
aux1190_943 = (marker_927-1);
{int k_1252;
obj_t char_1253;
k_1252 = (int)(aux1190_943);
char_1253 = MAKE_PAIR(BCHAR(((unsigned char)' ')), BNIL);
if(NULLP(char_1253)){space_string_932_182 = make_string((long)(k_1252), ((unsigned char)' '));
} else {obj_t aux1017_1254;
aux1017_1254 = CAR(char_1253);
space_string_932_182 = make_string((long)(k_1252), (unsigned char)CCHAR(aux1017_1254));
}}} else {space_string_932_182 = string1218___error;
}fix_tabulation____error_157(BINT(marker_927), string_926, space_string_932_182);
{obj_t aux1196_1256;
aux1196_1256 = current_error_port;
{obj_t aux1197_1257;
aux1197_1257 = nice_fname___error_199(fname_923);
fprint___r4_output_6_10_3(aux1196_1256, MAKE_PAIR(string1219___error, MAKE_PAIR(aux1197_1257, MAKE_PAIR(string1220___error, MAKE_PAIR(BINT(line_924), MAKE_PAIR(string1221___error, MAKE_PAIR(char_925, MAKE_PAIR(string1222___error, MAKE_PAIR(BCHAR(((unsigned char)'\n')), MAKE_PAIR(string1223___error, MAKE_PAIR(string_926, MAKE_PAIR(BCHAR(((unsigned char)'\n')), MAKE_PAIR(string1223___error, MAKE_PAIR(space_string_932_182, MAKE_PAIR(string1224___error, BNIL)))))))))))))));
}}{obj_t aux1182_933;
aux1182_933 = current_error_port;
display___r4_output_6_10_3(string1225___error, MAKE_PAIR(aux1182_933, BNIL));
}if(NULLP(args_928)){BUNSPEC;
} else {{obj_t aux1183_934;
aux1183_934 = current_error_port;
{obj_t aux1184_935;
aux1184_935 = CAR(args_928);
fprint___r4_output_6_10_3(aux1183_934, MAKE_PAIR(aux1184_935, BNIL));
}}{obj_t l1005_937;
{obj_t aux1188_941;
aux1188_941 = CDR(args_928);
{bool_t aux1371_1460;
l1005_937 = aux1188_941;
lname1006_936:
if(PAIRP(l1005_937)){{obj_t a_938;
a_938 = CAR(l1005_937);
{obj_t aux1185_939;
aux1185_939 = current_error_port;
display___r4_output_6_10_3(a_938, MAKE_PAIR(aux1185_939, BNIL));
}}{obj_t aux1187_940;
aux1187_940 = CDR(l1005_937);
{obj_t l1005_1467;
l1005_1467 = aux1187_940;
l1005_937 = l1005_1467;
goto lname1006_936;
}}} else {aux1371_1460 = ((bool_t)1);
}BBOOL(aux1371_1460);
}}}}{obj_t aux1189_942;
aux1189_942 = current_error_port;
return newline___r4_output_6_10_3(MAKE_PAIR(aux1189_942, BNIL));
}}}

obj_t fix_tabulation____error_157(obj_t marker_947, obj_t src_948, obj_t dst_949)
{{long read_951;
{long aux1194_955;
aux1194_955 = ((long)CINT(marker_947)-1);
read_951 = aux1194_955;
loop_950:
if((read_951==-1)){return symbol1217___error;
} else {bool_t test1297_1405;
{unsigned char aux1191_952;
aux1191_952 = STRING_REF(src_948, read_951);
{unsigned char char2_1269;
char2_1269 = ((unsigned char)'\t');
test1297_1405 = (aux1191_952==char2_1269);
}}if(test1297_1405){{unsigned char char_1272;
char_1272 = ((unsigned char)'\t');
STRING_SET(dst_949, read_951, char_1272);
}{long aux1192_953;
aux1192_953 = (read_951-1);
{long read_1410;
read_1410 = aux1192_953;
read_951 = read_1410;
goto loop_950;
}}} else {long aux1193_954;
aux1193_954 = (read_951-1);
{long read_1412;
read_1412 = aux1193_954;
read_951 = read_1412;
goto loop_950;
}}}}}}

obj_t nice_fname___error_199(obj_t fname_969)
{{obj_t pwd_970;
{obj_t vpwd_980;
{char * string_1277;
string_1277 = "PWD";
if(getenv(string_1277)){vpwd_980 = string_to_bstring(getenv(string_1277));
} else {vpwd_980 = BFALSE;
}}if(STRINGP(vpwd_980)){pwd_970 = vpwd_980;
} else {pwd_970 = pwd___unix();
}}if(STRINGP(pwd_970)){long lend_971;
long lenf_972;
lend_971 = STRING_LENGTH(pwd_970);
lenf_972 = STRING_LENGTH(fname_969);
if((lenf_972<lend_971)){return fname_969;
} else {long r_974;
r_974 = 0;
loop_973:
if((r_974==lend_971)){bool_t test1268_1386;
if((r_974<lenf_972)){unsigned char aux1200_975;
aux1200_975 = STRING_REF(fname_969, r_974);
{unsigned char char2_1289;
char2_1289 = ((unsigned char)'/');
test1268_1386 = (aux1200_975==char2_1289);
}} else test1268_1386 = ((bool_t)0);
if(test1268_1386){long aux1201_976;
aux1201_976 = (r_974+1);
return c_substring(fname_969, aux1201_976, lenf_972);
} else {return c_substring(fname_969, r_974, lenf_972);
}} else {bool_t test1278_1394;
{unsigned char aux1204_977;
aux1204_977 = STRING_REF(fname_969, r_974);
{unsigned char aux1207_978;
aux1207_978 = STRING_REF(pwd_970, r_974);
test1278_1394 = (aux1204_977==aux1207_978);
}}if(test1278_1394){long aux1208_979;
aux1208_979 = (r_974+1);
{long r_1399;
r_1399 = aux1208_979;
r_974 = r_1399;
goto loop_973;
}} else {return c_substring(fname_969, r_974, lenf_972);
}}}} else {return fname_969;
}}}

