;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Tools/shape.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 17:02:04 1994                          */
;*    Last change :  Wed Sep 13 16:19:48 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    In order to print human readable messages, we designed this      */
;*    tool.                                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_shape
   (include "Type/type.sch"
	    "Ast/node.sch"
	    "Reduce/common.sch")
   (import  engine_param
	    ast_dump
	    ast_global
	    ast_local)
   (export  (shape exp)))

;*---------------------------------------------------------------------*/
;*    shape ...                                                        */
;*---------------------------------------------------------------------*/
(define (shape exp)
   (cond
      ((var? exp)
       (shape (var-variable exp)))
      ((global? exp)
       (global-shape exp))
      ((local? exp)
       (local-shape exp))
      ((type? exp)
       (type-id exp))
      ((common? exp)
       (common (shape (common-ast exp))
	       (shape (common-variable exp))
	       (common-bool-value exp)))
      ((vector? exp)
       (let* ((len (vector-length exp))
	      (res (make-vector len '())))
	  (let loop ((indice 0))
	     (if (=fx indice len)
		 res
		 (begin
		    (vector-set! res
				 indice
				 (shape (vector-ref exp indice)))
		    (loop (+fx indice 1)))))))
      ((ast? exp)
       (ast->sexp exp))
      ((not (pair? exp))
       exp)
      (else
       (let loop ((exp exp))
	  (cond
	     ((null? exp)
	      '())
	     ((not (pair? exp))
	      (shape exp))
	     (else
	      (cons (shape (car exp)) (loop (cdr exp)))))))))
   



