;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Misc/union.sch ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 25 10:45:26 1994                          */
;*    Last change :  Mon Dec 26 10:24:55 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The union facility                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    directives                                                       */
;*---------------------------------------------------------------------*/
(directives
   (import tools_error))

;*---------------------------------------------------------------------*/
;*    define-union ...                                                 */
;*---------------------------------------------------------------------*/
(define-macro (define-union name . definitions)
   ;; the make-getter utility function
   (define (make-getter names field)
      `(define-inline (,(symbol-append name '- field) o)
	  ,(let loop ((names names))
	      (if (null? names)
		  `(internal-error "Illegal object type" ',name o)
		  `(if (,(symbol-append (car names) '?) o)
		       (,(symbol-append (car names) '- field) o)
		       ,(loop (cdr names)))))))
   ;; the make-setter utility function
   (define (make-setter names field)
      `(define-inline (,(symbol-append name '- field '-set!) o v)
	  ,(let loop ((names names))
	      (if (null? names)
		  `(internal-error "Illegal object type" ',name o)
		  `(if (,(symbol-append (car names) '?) o)
		       (,(symbol-append (car names) '- field '-set!) o v)
		       ,(loop (cdr names)))))))
   ;; the make-predicate utility function
   (define (make-tester names)
      `(define-inline (,(symbol-append name '?) o)
	  ,(let loop ((names names))
	      (if (null? names)
		  #f
		  `(if (,(symbol-append (car names) '?) o)
		       #t
		       ,(loop (cdr names)))))))
   ;; first we check that all definition are `struct' definitions
   (for-each (lambda (def)
		(match-case def
		   ((define-struct ?- . ?-)
		    'ok)
		   (else
		    (internal-error "define-union"
				    "Illegal define-union definition"
				    definitions))))
		definitions)
   ;; build the list of getter and setter for the union
   (let ((names  (map cadr definitions))
	 (fields (map cddr definitions)))
      ;; we iterate on the first structure definition.
      (let loop ((struct-fields (cddr (car definitions)))
		 (res          '()))
	 (if (null? struct-fields)
	     (cons 'begin (append definitions (cons (make-tester names) res)))
	     (let ((field (car struct-fields)))
		;; is field available on all structure ?
		(let liip ((fields fields))
		   (cond
		      ((null? fields)
		       ;; yes it is, we define global getter and setter
		       (loop (cdr struct-fields)
			     (cons (make-getter names field)
				   (cons (make-setter names field)
					 res))))
		      ((not (memq field (car fields)))
		       ;; no, it is not
		       (loop (cdr struct-fields)
			     res))
		      (else
		       (liip (cdr fields))))))))))
	     
	  
