;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Integrate/g.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 15 14:53:50 1995                          */
;*    Last change :  Thu Mar 30 14:18:25 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We compute the set of globalized functions.                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_g
   (include "Tools/trace.sch"
	    "Ast/ast.sch"
	    "Integrate/integrate.sch")
   (import  tools_shape
	    integrate_a)
   (export  (G! <local>*)))

;*---------------------------------------------------------------------*/
;*    G! ...                                                           */
;*    -------------------------------------------------------------    */
;*    The globalized function due to Cn property have already          */
;*    been computed during the Cn computation. Now, we just            */
;*    perform a fix-point iteration with the Ct property.              */
;*---------------------------------------------------------------------*/
(define (G! G/cn)
   (trace integrate "G/cn (dans G!): " (shape G/cn) #\Newline)
   (let loop ((stop? #f)
	      (stamp 0)
	      (Gs    G/cn))
      (if stop?
	  (begin
	     (for-each
	      (lambda (f)
		 (if (and (local? f)
			  (not (ifun-G? (local-info f)))
			  (not (variable? (ifun-L (local-info f)))))
		     (ifun-L-set! (local-info f) (ifun-owner (local-info f)))))
	      *phi*)
	     (trace integrate "G: " (shape Gs) #\Newline)
	     (trace (integrate loop)
		    "   " stamp " iteration(s) to fix point"
		    #\Newline)
	     Gs)
	  (let liip ((phi     *phi*)
		     (stop?   #t)
		     (Gs      Gs))
	     (if (null? phi)
		 (loop stop? (+fx stamp 1) Gs)
		 (let* ((f   (car phi))
			(fif (variable-info f)))
		    (let laap ((Ct       (ifun-Ct fif))
			       (stop?    stop?)
			       (Gs       Gs))
		       (if (null? Ct)
			   (liip (cdr phi) stop? Gs)
			   (let* ((g  (car Ct))
				  (gif (local-info g)))
			      (trace (integrate loop)
				     " Ct( " (shape f) ", " (shape g) " )"
				     #\Newline)
			      (cond
				 ((eq? f g)
				  (laap (cdr Ct) stop? Gs))
				 ((ifun-G? gif)
				  (laap (cdr Ct) stop? Gs))
				 ((ifun-G? fif)
				  (cond
				     ((not (variable? (ifun-L gif)))
				      (trace (integrate loop)
					     "   trying L.1( "
					     (shape f) ", " (shape g) " )"
					     #\Newline)
				      (ifun-L-set! gif f)
				      (laap (cdr Ct) #f Gs))
				     ((eq? (ifun-L gif) f)
				      (laap (cdr Ct) stop? Gs))
				     (else
				      (ifun-G?-set! gif #t)
				      (trace (integrate loop)
					     "   G.1( " (shape g) " )"
					     #\Newline)
				      (laap (cdr Ct) #f (cons g Gs)))))
				 ((not (variable? (ifun-L gif)))
				  (cond
				     ((variable? (ifun-L fif))
				      (ifun-L-set! gif (ifun-L fif))
				      (trace (integrate loop)
					     "   trying L.2( "
					     (shape (ifun-L fif)) ", "
					     (shape g) " )"
					     #\Newline)
				      (laap (cdr Ct) #f Gs))
				     (else
				      (let ((stop? (and
						    stop?
						    (integer? (ifun-istamp
							       fif))
						    (<=fx (ifun-istamp fif)
							  stamp))))
					 (ifun-istamp-set! fif stamp)
					 (laap (cdr Ct) stop? Gs)))))
				 ((not (variable? (ifun-L fif)))
				  (trace (integrate loop)
					 "   trying L.3( "
					 (shape (ifun-L gif)) ", " (shape f)
					 " )" #\Newline)
				  (ifun-L-set! fif (ifun-L gif))
				  (laap (cdr Ct) #f Gs))
				 ((eq? (ifun-L fif) (ifun-L gif))
				  (laap (cdr Ct) stop? Gs))
				 (else
				  (ifun-G?-set! gif #t)
				  (trace (integrate loop)
					 "   G.3( " (shape g) " )" #\Newline)
				  (laap (cdr Ct) #f (cons g Gs)))))))))))))
		       
      
