;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Integrate/free.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 16 08:27:49 1995                          */
;*    Last change :  Wed Oct 11 11:38:58 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This module implement a function which collect the free          */
;*    variables of a global function.                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_free
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Integrate/integrate.sch")
   (import  tools_shape
	    ast_dump)
   (export  (get-free-vars <ast> <local>)
	    (free-from     <local>** <local>)))

;*---------------------------------------------------------------------*/
;*    *round* ...                                                      */
;*---------------------------------------------------------------------*/
(define *round* 0)

;*---------------------------------------------------------------------*/
;*    mark-var! ...                                                    */
;*---------------------------------------------------------------------*/
(define (mark-var! local)
   (let ((info  (local-info local)))
      (ivar-f-mark-set! info *round*)))

;*---------------------------------------------------------------------*/
;*    bind-var! ...                                                    */
;*---------------------------------------------------------------------*/
(define (bind-var! local integrator)
   (let ((finfo (local-info integrator)))
      (ifun-bound-set! finfo (cons local (ifun-bound finfo)))
      (mark-var! local)))

;*---------------------------------------------------------------------*/
;*    free-var? ...                                                    */
;*---------------------------------------------------------------------*/
(define (free-var? local)
   (let ((info (local-info local)))
      (not (eq? (ivar-f-mark info) *round*))))
       
;*---------------------------------------------------------------------*/
;*    get-free-vars ...                                                */
;*    -------------------------------------------------------------    */
;*    We don't need a stack, we just have to mark all bound and free   */
;*    variables.                                                       */
;*---------------------------------------------------------------------*/
(define (get-free-vars ast integrator)
   (let ((free (ifun-free (local-info integrator))))
      (if (or (null? free) (pair? free))
	  free
	  (let ((free (internal-get-free-vars! ast integrator)))
	     (ifun-free-set! (local-info integrator) free)
	     free))))

;*---------------------------------------------------------------------*/
;*    internal-get-free-vars! ...                                      */
;*    -------------------------------------------------------------    */
;*    This function, makes a side effect on integrator because,        */
;*    it maintain `bound' variables list.                              */
;*---------------------------------------------------------------------*/
(define (internal-get-free-vars!  ast integrator)
   (set! *round* (+fx *round* 1))
   (for-each (lambda (l) (bind-var! l integrator))
	     (function-args (local-value integrator)))
   ;; we can now walk across the body
   (let loop ((ast   ast)
	      (free  '()))
      [assert check (free) (or (null? free) (pair? free))]
      (ast-case ast
	 ((atom)
	  free)
	 ((kwote)
	  free)
	 ((var)
	  (let ((var (var-variable ast)))
	     (cond
		((global? var)
		 free)
		((free-var? var)
		 (mark-var! var)
		 (cons var free))
		(else
		 free))))
	 ((make-box)
	  (loop (make-box-value ast) free))
	 ((box-ref)
	  (loop (box-ref-var ast) free))
	 ((box-set!)
	  (loop (box-set!-var ast)
		(loop (box-set!-value ast)
		      free)))
	 ((fun)
	  (internal-error "a-graph"
			  "Illegal node (see Globalize)"
			  (ast->sexp ast)))
	 ((prag-ma)
	  (let liip ((asts (prag-ma-values ast))
		     (free free))
	     (if (null? asts)
		 free
		 (liip (cdr asts) (loop (car asts) free)))))
	 ((fail)
	  (loop (fail-proc ast)
		(loop (fail-msg ast)
		      (loop (fail-obj ast)
			    free))))
	 ((sequence)
	  (let liip ((asts (sequence-exp ast))
		     (free free))
	     (if (null? asts)
		 free
		 (liip (cdr asts) (loop (car asts) free)))))
	 ((conditional)
	  (loop (conditional-test ast)
		(loop (conditional-then ast)
		      (loop (conditional-else ast)
			    free))))
	 ((setq)
	  (loop (setq-val ast)
		(loop (setq-var ast) free)))
	 ((let-var)
	  (let liip ((bindings  (let-var-bindings ast))
		     (free      free))
	     (if (null? bindings)
		 (loop (let-var-body ast) free)
		 (begin
		    (bind-var! (car (car bindings)) integrator)
		    (liip (cdr bindings)
			  (loop (cdr (car bindings))
				free))))))
	 ((let-fun)
	  ;; we mark all locals functions
	  (let liip ((locals (let-fun-locals ast))
		     (free   free))
	     (if (null? locals)
		 (loop (let-fun-body ast) free)
		 (let* ((local (car locals))
			(fun   (local-value local))
			(info  (local-info local)))
		    (for-each (lambda (l) (bind-var! l integrator))
			      (function-args fun))
		    (liip (cdr locals)
			  (loop (function-body fun)
				free))))))
	 ((set-ex-it)
	  (bind-var! (var-variable (set-ex-it-exit ast)) integrator)
	  (loop (set-ex-it-body ast) free))
	 ((jump-ex-it)
	  (loop (jump-ex-it-exit ast)
		(loop (jump-ex-it-value ast)
		      free)))
	 ((funcall)
	  (let liip ((asts (funcall-actuals ast))
		     (free free))
	     (if (null? asts)
		 (loop (funcall-fun ast)
		       free)
		 (liip (cdr asts)
		       (loop (car asts)
			     free)))))
	 ((app-ly)
	  (loop (app-ly-fun ast)
		(loop (app-ly-value ast)
		      free)))
	 ((app)
	  (let liip ((asts (app-actuals ast))
		     (free free))
	     (if (null? asts)
		 free
		 (liip (cdr asts)
		       (loop (car asts)
			     free)))))
	 ((switch)
	  (let liip ((clauses (switch-clauses ast))
		     (free    free))
	     (if (null? clauses)
		 (loop (switch-test ast) free)
		 (liip (cdr clauses)
		       (loop (cdr (car clauses))
			     free))))))))

;*---------------------------------------------------------------------*/
;*    free-from ...                                                    */
;*---------------------------------------------------------------------*/
(define (free-from sets integrator)
   (set! *round* (+fx *round* 1))
   ;; we re-mark all bound variables.
   (let ((finfo (local-info integrator)))
      (trace (integrate loop)
	     "   bound(" (shape integrator) ") : "
	     (shape (ifun-bound finfo))
	     #\Newline
	     "   sets: " (shape sets)
	     #\Newline)
      (for-each mark-var! (ifun-bound finfo)))
   ;; then, we scan sets
   (map (lambda (set)
	   (let loop ((set set)
		      (res '()))
	      (cond
		 ((null? set)
		  res)
		 ((free-var? (car set))
		  (loop (cdr set) (cons (car set) res)))
		 (else
		  (loop (cdr set) res)))))
	sets))
