;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Fail/walk.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 13 13:53:58 1995                          */
;*    Last change :  Wed Oct 11 11:30:12 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The introduction of fail in debuggin mode.                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module fail_walk
   (include "Tools/pass.sch"
	    "Ast/node.sch")
   (import  tools_shape
	    tools_location
	    ast_global
	    ast_local
	    ast_dump
	    engine_param)
   (export  (fail-walk! tree)))

;*---------------------------------------------------------------------*/
;*    *error* ...                                                      */
;*---------------------------------------------------------------------*/
(define *error* #unspecified)

;*---------------------------------------------------------------------*/
;*    fail-walk! ...                                                   */
;*---------------------------------------------------------------------*/
(define (fail-walk! ast)
   (pass-prelude "Fail")
   (set! *error* (require-global 'error/location '__error #f))
   (global-occurrence-set! *error* 1000)
   (for-each fail-fun! ast)
   (set! *error* #unspecified)
   ast)

;*---------------------------------------------------------------------*/
;*    fail-fun! ...                                                    */
;*---------------------------------------------------------------------*/
(define (fail-fun! var)
   (let* ((fun  (variable-value var))
	  (body (function-body fun))
	  (type (function-type-res fun)))
      (enter-function (shape var))
      (function-body-set! fun (fail-ast body))
      (leave-function)))
   
;*---------------------------------------------------------------------*/
;*    fail-ast ...                                                     */
;*---------------------------------------------------------------------*/
(define (fail-ast ast)
   (ast-case ast
      ((atom)
       ast)
      ((var)
       ast)
      ((kwote)
       ast)
      ((sequence)
       (let loop ((asts (sequence-exp ast)))
          (if (null? asts)
              ast
              (begin
                 (set-car! asts (fail-ast (car asts)))
                 (loop (cdr asts))))))
      ((make-box)
       (make-box-value-set! ast (fail-ast (make-box-value ast)))
       ast)
      ((box-ref)
       (box-ref-var-set! ast (fail-ast (box-ref-var ast)))
       ast)
      ((box-set!)
       (box-set!-var-set! ast (fail-ast (box-set!-var ast)))
       (box-set!-value-set! ast (fail-ast (box-set!-value ast)))
       ast)
      ((setq)
       (setq-val-set! ast (fail-ast (setq-val ast)))
       ast)
      ((conditional)
       (conditional-test-set! ast (fail-ast (conditional-test ast)))
       (conditional-then-set! ast (fail-ast (conditional-then ast)))
       (conditional-else-set! ast (fail-ast (conditional-else ast)))
       ast)
      ((fail)
       (fail-proc-set! ast (fail-ast (fail-proc ast)))
       (fail-msg-set! ast (fail-ast (fail-msg ast)))
       (fail-obj-set! ast (fail-ast (fail-obj ast)))
       (let ((loc (ast-location ast)))
	  (if (loc? loc)
	      (ast-app loc
		       #f
		       #f
		       (ast-var loc #f #f *error*)
		       (list (fail-ast (fail-proc ast))
			     (fail-ast (fail-msg ast))
			     (fail-ast (fail-obj ast))
			     (ast-atom loc #f #f (loc-full-fname loc))
			     (ast-atom loc #f #f (loc-pos loc)))
			 
		       #f
		       #f
		       #f
		       #f)
	      ast)))
      ((let-fun)
       (let-fun-body-set! ast (fail-ast (let-fun-body ast)))
       (for-each fail-fun! (let-fun-locals ast))
       ast)
      ((let-var)
       (for-each (lambda (binding)
		    (set-cdr! binding (fail-ast (cdr binding))))
		 (let-var-bindings ast))
       (let-var-body-set! ast (fail-ast (let-var-body ast)))
       ast)
      ((app-ly)
       (app-ly-fun-set! ast (fail-ast (app-ly-fun ast)))
       (app-ly-value-set! ast (fail-ast (app-ly-value ast)))
       ast) 
      ((funcall)
       (funcall-fun-set! ast (fail-ast (funcall-fun ast)))
       (let loop ((actuals (funcall-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (fail-ast (car actuals)))
		 (loop (cdr actuals))))))
      ((fun)
       (internal-error "do-set-recursive-call!"
		       "Illegal node (see `Bivaluation' pass)"
		       (ast->sexp ast)))
      ((app)
       (let loop ((actuals (app-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (fail-ast (car actuals)))
		 (loop (cdr actuals))))))
      ((set-ex-it)
       (set-ex-it-body-set! ast (fail-ast (set-ex-it-body ast)))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (fail-ast (jump-ex-it-exit ast)))
       (jump-ex-it-value-set! ast (fail-ast (jump-ex-it-value ast)))
       ast)
      ((switch)
       (switch-test-set! ast (fail-ast (switch-test ast)))
       (for-each (lambda (clause)
                    (set-cdr! clause (fail-ast (cdr clause))))
                 (switch-clauses ast))
       ast)
      ((prag-ma)
       (let loop ((values (prag-ma-values ast)))
	  (if (null? values)
	      ast
	      (begin
		 (set-car! values (fail-ast (car values)))
		 (loop (cdr values))))))))
   
