;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/funcall.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar  9 15:42:17 1995                          */
;*    Last change :  Wed Apr 12 14:10:12 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The funcall management.                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_funcall
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch")
   (import  cfa_approx
	    cfa_cache
	    cfa_app
	    cfa_top
	    cfa_special
	    cfa_procedure
	    cfa_ast
	    ast_dump
	    type_cache
	    tools_set
	    tools_shape)
   (export  (cfa-funcall! <ast>)))

;*---------------------------------------------------------------------*/
;*    cfa-funcall! ...                                                 */
;*    -------------------------------------------------------------    */
;*    First, we compute the possible function called. Then for         */
;*    each of them, we compute the result of evaluating its            */
;*    body with the actual approximations.                             */
;*---------------------------------------------------------------------*/
(define (cfa-funcall! ast)
   [assert check (ast) (approx? (get-approx ast))]
   (let* ((fun-A          (cfa-ast! (funcall-fun ast)))
	  (fun-approx     (approx-alloc fun-A))
	  (actuals-approx (map cfa-ast! (funcall-actuals ast))))
      (trace (cfa loop)
	     "          cfa-funcall: " (ast->sexp ast) #\Newline
	     "                  fun: " (approx-shape fun-A) #\Newline
	     "              actuals: " (map ast->sexp (funcall-actuals ast))
	     #\Newline
	     "       actuals-approx: " (map approx-shape actuals-approx)
	     #\Newline)
      ;; then, we try each possible function.
      (let ((approx (get-approx ast)))
	 ;; first, we check top.
	 (if (approx-top? fun-A)
	     (begin
		(for-each spread-top! actuals-approx)
		(add-obj! approx)
		(add-top! approx)))
	 (for-each-set (lambda (fun-approx)
			  (union-approx! approx
					 (cfa-try-app! ast
						       fun-approx
						       actuals-approx)))
		       fun-approx)
	 ;; it is finished, we return
	 (trace (cfa loop) "       new-res: " (approx-shape approx) #\Newline)
	 approx)))

;*---------------------------------------------------------------------*/
;*    cfa-try-app! ...                                                 */
;*---------------------------------------------------------------------*/
(define (cfa-try-app! call-ast fun-approx actuals-approx)
   [assert check (call-ast) (funcall? call-ast)]
   [assert check (fun-approx) (is-alloc? fun-approx)]
   (cond
      ((not (is-closure-alloc? fun-approx))
       ;; when encoutering an error, we just warn and don't add
       ;; new approximation. We _don't_ introduce top on error
       (app-type-error call-ast fun-approx))
      (else
       (cfa-app! call-ast (closure->function fun-approx) actuals-approx))))
	       
