;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/dead.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 10 09:31:39 1995                          */
;*    Last change :  Wed Oct 11 11:16:12 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The dead call removal.                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_dead
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch")
   (import  ast_typeof
	    ast_dump
	    ast_env
	    cfa_special
	    cfa_cache
	    cfa_procedure
	    cfa_closure
	    type_cache
	    tools_speek
	    tools_shape
	    tools_set)
   (export (dead-code-removal! globals)
	   (alive-function?    var)
	   (dead-function?     var)))

;*---------------------------------------------------------------------*/
;*    *dead-code-removal!* ...                                         */
;*---------------------------------------------------------------------*/
(define *dead-code-removal!* #f)

;*---------------------------------------------------------------------*/
;*    dead-function? ...                                               */
;*---------------------------------------------------------------------*/
(define (dead-function? var)
   [assert check (*dead-code-removal!*) *dead-code-removal!*]
   (let ((ifun (variable-cfa-info var)))
      (and (ifun? ifun) (not (ifun-alive? ifun)))))

;*---------------------------------------------------------------------*/
;*    alive-function? ...                                              */
;*    -------------------------------------------------------------    */
;*    Alive is _not_ the negation of dead. Zombie function does not    */
;*    satisfies neither alive nor dead.                                */
;*---------------------------------------------------------------------*/
(define (alive-function? var)
   [assert check (*dead-code-removal!*) *dead-code-removal!*]
   (let ((ifun (variable-cfa-info var)))
      (and (ifun? ifun)
	   (ifun-alive? ifun)
	   (boolean? (ifun-alive? ifun)))))

;*---------------------------------------------------------------------*/
;*    dead-code-removal! ...                                           */
;*    -------------------------------------------------------------    */
;*    It is very difficult to remove dead closure (because, it is      */
;*    necessary to remove all the closure construction, including,     */
;*    the procedure-set!, make-??-procedure). Because, I don't want    */
;*    to do this, there is a special state for dead closure: the       */
;*    zombie state. When a function is in zombie state, its body is    */
;*    replaced by `#unspecified'.                                      */
;*---------------------------------------------------------------------*/
(define (dead-code-removal! globals)
   [assert check (*dead-code-removal!*) (begin (set! *dead-code-removal!* #t) #t)]
   ;; we mark that all closures are (semi) alive
   (for-each (lambda (clo-ast)
		(let* ((fun  (closure->function clo-ast))
		       (ifun (global-cfa-info fun)))
		   (if (and (ifun? ifun) (not (ifun-alive? ifun)))
		       (ifun-alive?-set! ifun 'zombie))))
	     (get-closure-list))
   (let loop ((old globals)
	      (new '()))
      (cond
	 ((null? old)
	  new)
	 ((dead-function? (car old))
	  ;; this function is never used
	  (show-remove (car old))
	  (loop (cdr old) new))
	 (else
	  ;; this function is used.
	  (let* ((var  (car old))
		 (fun  (global-value var))
		 (body (function-body fun)))
	     (if (eq? (ifun-alive? (variable-cfa-info var)) 'zombie)
		 (begin
		    (show-remove (car old))
		    (function-type-res-set! fun *obj*)
		    (function-body-set! fun (ast-atom (ast-location body)
						      #f
						      #f
						      #unspecified)))
		 (function-body-set! fun
				     (ast-dead-code-removal! body)))
	     (loop (cdr old)
		   (cons var new)))))))

;*---------------------------------------------------------------------*/
;*    ast-dead-code-removal! ...                                       */
;*---------------------------------------------------------------------*/
(define (ast-dead-code-removal! ast)
   (let loop ((ast ast))
      (ast-case ast
	 ((atom)
	  ast)
	 ((kwote)
	  ast)
	 ((var)
	  ast)
	 ((prag-ma)
	  (let liip ((values (prag-ma-values ast)))
	     (if (null? values)
		 ast
		 (begin
		    (set-car! values (loop (car values)))
		    (liip (cdr values))))))
	 ((fail)
	  (fail-proc-set! ast (loop (fail-proc ast)))
	  (fail-msg-set! ast (loop (fail-msg ast)))
	  (fail-obj-set! ast (loop (fail-obj ast)))
	  ast)
	 ((sequence)
	  (let liip ((asts (sequence-exp ast)))
	     (if (null? asts)
		 ast
		 (begin
		    (set-car! asts (loop (car asts)))
		    (liip (cdr asts))))))
	 ((conditional)
	  (conditional-test-set! ast (loop (conditional-test ast)))
	  (conditional-then-set! ast (loop (conditional-then ast)))
	  (conditional-else-set! ast (loop (conditional-else ast)))
	  ast)
	 ((switch)
	  (switch-test-set! ast (loop (switch-test ast)))
	  (for-each (lambda (clause)
		       (set-cdr! clause (loop (cdr clause))))
		    (switch-clauses ast))
	  ast)
	 ((setq)
	  (setq-val-set! ast (loop (setq-val ast)))
	  ast)
	 ((let-var)
	  (for-each (lambda (binding)
		       (let ((var (car binding))
			     (val (loop (cdr binding))))
			  (set-cdr! binding val)))
		    (let-var-bindings ast))
	  (let-var-body-set! ast (loop (let-var-body ast)))
	  ast)
	 ((let-fun)
	  (let liip ((old (let-fun-locals ast))
		     (new '()))
	     (cond
		((null? old)
		 (let-fun-locals-set! ast new)
		 (let-fun-body-set! ast (loop (let-fun-body ast)))
		 ast)
		((dead-function? (car old))
		 (show-remove (car old))
		 (liip (cdr old) new))
		(else
		 (let* ((var (car old))
			(fun (local-value var)))
		    (function-body-set! fun (loop (function-body fun)))
		    (liip (cdr old)
			  (cons var new)))))))
	 ((set-ex-it)
	  (set-ex-it-body-set! ast (loop (set-ex-it-body ast)))
	  ast)
	 ((jump-ex-it)
	  (jump-ex-it-exit-set! ast (loop (jump-ex-it-exit ast)))
	  (jump-ex-it-value-set! ast (loop (jump-ex-it-value ast)))
	  ast)
	 ((app-ly)
	  (app-ly-fun-set! ast (loop (app-ly-fun ast)))
	  (app-ly-value-set! ast (loop (app-ly-value ast)))
	  ast)
	 ((funcall)
	  (funcall-fun-set! ast (loop (funcall-fun ast)))
	  (let liip ((actuals (funcall-actuals ast)))
	     (if (null? actuals)
		 ast
		 (begin
		    (set-car! actuals (loop (car actuals)))
		    (liip (cdr actuals))))))
	 ((app)
	  (if (dead-function? (var-variable (app-fun ast)))
	      (app->nop ast)
	      (let liip ((actuals (app-actuals ast)))
		 (if (null? actuals)
		     ast
		     (begin
			(set-car! actuals (loop (car actuals)))
			(liip (cdr actuals)))))))
	 ((make-box)
	  (make-box-value-set! ast (loop (make-box-value ast)))
	  ast)
	 ((box-set!)
	  (box-set!-var-set! ast (loop (box-set!-var ast)))
	  (box-set!-value-set! ast (loop (box-set!-value ast)))
	  ast)
	 ((box-ref)
	  (box-ref-var-set! ast (loop (box-ref-var ast)))
	  ast))))

;*---------------------------------------------------------------------*/
;*    app->nop ...                                                     */
;*---------------------------------------------------------------------*/
(define (app->nop app)
   (app-actuals-set!  app '())
   (var-variable-set! (app-fun app) *nop*)
   app)

;*---------------------------------------------------------------------*/
;*    show-remove ...                                                  */
;*---------------------------------------------------------------------*/
(define show-remove
   (let ((header #f))
      (lambda (var)
	 (if (not header)
	     (begin
		(set! header #t)
		(verbose 2 "           removing: " (shape var) #\Newline))
	     (verbose 2 "                     " (shape var) #\Newline)))))
