;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Ast/walk.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 16:37:53 1994                          */
;*    Last change :  Sat Apr  6 12:07:30 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The construction of the `Ast'                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_walk
   (include "Tools/pass.sch"
	    "Ast/ast.sch")
   (import  ast_global-definition
	    ast_global-mutation
	    ast_global
	    ast_build
	    ast_env
	    ast_varinit
	    eval_init
	    read_inline
	    type_env
	    engine_param
	    tools_module)
   (export  (ast-walk <s-exp>*)))

;*---------------------------------------------------------------------*/
;*    build-ast ...                                                    */
;*    -------------------------------------------------------------    */
;*    This function returns a list of global variables which are       */
;*    composing the `ast'.                                             */
;*    -------------------------------------------------------------    */
;*    In order to build the `ast', we perform three walk on the        */
;*    code:                                                            */
;*      1. find global definitions and prototype checking              */
;*      2. find and check of global mutations                          */
;*      3. fix foreign variable and function types                     */
;*      4. building of the ast.                                        */
;*    -------------------------------------------------------------    */
;*    We add four expressions to `code' to help the module             */
;*    initialization process (see ast_build module).                   */
;*---------------------------------------------------------------------*/
(define (ast-walk code)
   (pass-prelude "Ast")
   (let* ((all-code (cons  '(define require-initialization?::obj #f)
			   ;; this form will be inserted into the
			   ;; module-init-name function as a `set!'
			   (append (get-readed-inlines)
				   code
				   (if *eval?*
				       (list '(define (initialize-eval-primop!)
						 #unspecified))
				       '()))))
	  (stage-1-2-code (let ((l (cons
				    ;; this is really a dummy code only used
				    ;; by stage 1 and 2.
				    `(define (,(module-init-name
						*module-name*))
					#unspecified)
				    (cons
				     '(define (initialize-imported-modules!)
					 #unspecified)
				     (cons
				      '(define (initialize-constants!)
					  #unspecified)
				      all-code)))))
			     (if (eq? *garbage-collector* 'bumpy)
				 (cons
				  '(define (gc-global-variables-declarations!)
				      #unspecified)
				  l)
				 l))))
      ;; first stage: global definitions
      (find-and-check-globals! stage-1-2-code)
      ;; second stage: global mutations
      (find-and-check-mutations! stage-1-2-code '())
      ;; third stage: construction
      (let ((globals (sexp*->ast all-code)))
	 ;; we prevent `require-initialization?' from been reachable from eval
	 (let ((global (find-global 'require-initialization? *module-name*)))
	    (global-eval?-set! global #f))
	 ;; we patch the `initialize-eval!' to forbidden its
	 ;; inlining. The body of the initialize-eval, will be set
	 ;; very late in the compilation in order to prevent the compiler
	 ;; to lost time in the compilation of this stupid function.
	 (if *eval?*
	     (let ((global (find-global 'initialize-eval-primop!
					*module-name*)))
		(global-occurrence-set! global 1)
		(global-eval?-set!      global #f)
		(global-import-set!     global 'static)
		(function-inline?-set! (global-value global) #f)
		(make-eval-init!)))
	 ;; we patch the initialization function, to make it exported
	 (let ((global (find-global (module-init-name *module-name*)
				    *module-name*)))
	    (global-import-set!  global 'export)
	    (global-eval?-set!   global #f)
	    (function-escape?-set! (global-value global) #f)
	    (function-type-res-set! (global-value global) (find-type 'obj)))
	 ;; we patch the `gc-global-variables-declarations!' to forbidden 
	 ;; its inlining
	 (if (eq? *garbage-collector* 'bumpy)
	     (let ((global (find-global 'gc-global-variables-declarations!
					*module-name*)))
		(global-occurrence-set! global 1)
		(global-eval?-set!      global #f)
		(global-import-set!     global 'static)
		(function-inline?-set! (global-value global) #f)))
	 ;; we patch the `initialize-importe-modules!' to forbidden its
	 ;; inlining
	 (let ((global (find-global 'initialize-imported-modules!
				    *module-name*)))
	    (global-occurrence-set! global 1)
	    (global-eval?-set!      global #f)
	    (global-import-set!     global 'static)
	    (function-inline?-set! (global-value global) #f))
	 ;; we patch the `tvectors-declarations!!' to forbidden its
	 ;; inlining
	 (let ((global (find-global 'tvectors-declarations! *module-name*)))
	    (global-occurrence-set! global 1)
	    (global-eval?-set!      global #f)
	    (global-import-set!     global 'static)
	    (function-inline?-set! (global-value global) #f))
	 ;; we patch the `initialize-constants!' to forbidden its
	 ;; inlining
	 (let ((global (find-global 'initialize-constants!
				    *module-name*)))
	    (global-occurrence-set! global 1)
	    (global-eval?-set!      global #f)
	    (global-import-set!     global 'static)
	    (function-inline?-set! (global-value global) #f))
	 ;; we ignore global definition which are never used
	 (let loop ((globals globals)
		    (res     '()))
	    (cond
	       ((null? globals)
		;; it is finished ...
		(pass-postlude (reverse! res) check-var-init?))
	       ((and (=fx (global-occurrence (car globals)) 0)
		     (eq? (global-class (car globals)) 'static))
		;; this function is never used, we skip it
		(loop (cdr globals)
		      res))
	       (else
		(loop (cdr globals)
		      (cons (car globals) res))))))))
