;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/global-def.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 16:44:18 1994                          */
;*    Last change :  Wed Jul  5 08:47:02 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    ast_global-definition                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_global-definition
   (include "Ast/ast.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    tools_shape
	    ast_global
	    ast_env
	    engine_param
	    parse_definition)
   (export  (find-and-check-globals! <s-exp>*)
	    (to-be-define!           <symbol>)))

;*---------------------------------------------------------------------*/
;*    *to-be-define* ...                                               */
;*---------------------------------------------------------------------*/
(define *to-be-define* '())

;*---------------------------------------------------------------------*/
;*    to-be-define! ...                                                */
;*---------------------------------------------------------------------*/
(define (to-be-define! global)
   (assert check (global) (global? global))
   (set! *to-be-define* (cons global *to-be-define*)))
 
;*---------------------------------------------------------------------*/
;*    find-and-check-globals! ...                                      */
;*    -------------------------------------------------------------    */
;*    We scan `code' in order to find all gobal definitions. When      */
;*    we find one, we check to see if it is comptatible with its       */
;*    prototype.                                                       */
;*    -------------------------------------------------------------    */
;*    When a variable or function definition is seen, we set           */
;*    the `global-info' slot to #t, then to check is a variable        */
;*    is not re-defined, we just have to inspect this slot value.      */
;*---------------------------------------------------------------------*/
(define (find-and-check-globals! codes)
   (letrec ((check (lambda (exp)
		      (match-case exp
			 ((begin . ?exps)
			  (for-each check exps))
			 ((define (and (? symbol?) ?var) (lambda ?args . ?-))
			  (check-function-definition! var `(,var ,@args) exp))
			 ((define (and (? symbol?) ?var) . ?-)
			  (check-variable-definition! var exp))
			 ((define (and ?proto (?var . ?args)) . ?-)
			  (check-function-definition! var proto exp))
			 ((define-inline (and ?proto (?var . ?args)) . ?-)
			  (check-inline-definition! var proto exp))
			 (else
			  'ok)))))
      (for-each check codes))
   ;; now we check that all declared static or exported
   ;; variables are defined in the module
   (let loop ((globals *to-be-define*))
      (cond
	 ((null? globals)
	  (set! *to-be-define* '())
	 'ok)
	 ((null? (global-info (car globals)))
	  (user-error "find-and-check-globals!"
		      "Unbound global variable"
		      (global-shape (car globals))))
	 (else
	  (global-info-set! (car globals) '())
	  (loop (cdr globals))))))

;*---------------------------------------------------------------------*/
;*    check-variable-definition! ...                                   */
;*---------------------------------------------------------------------*/
(define (check-variable-definition! var exp)
   (trace init "check-variable-definition!: " var #\Newline)
   (let* ((v.t       (parse-formal-ident var))
	  (var-name  (car v.t))
	  (type-type (cdr v.t)))
      (let ((global (find-global var-name *module-name*)))
	 (cond
	    ((not (global? global))
	     (let ((proto (parse-definition var)))
		(let ((global (declare-global-variable! 'static
							*module-name*
							(car proto)
							(cdr proto))))
		   (global-info-set! global #t)
		   global)))
	    ((eq? (global-info global) #t)
	     (user-error "find-and-check-globals!"
			 "Redefinition of global variable"
			 exp))
	    ((eq? (global-class global) 'variable)
	     (global-info-set! global #t)
	     (if (check-variable-definition? global
					     '()
					     'variable
					     (cdr (parse-definition var)))
		 'ok
		 (mismatch-error exp)))
	    (else
	     (mismatch-error exp))))))

;*---------------------------------------------------------------------*/
;*    check-function-definition! ...                                   */
;*---------------------------------------------------------------------*/
(define (check-function-definition! var proto exp)
   (trace init "check-function-definition!: " var #\Newline)
   (let* ((v.t      (parse-formal-ident var))
	  (var-name (car v.t))
	  (var-type (cdr v.t)))
      (let ((global (find-global var-name *module-name*)))
	 (cond
	    ((not (global? global))
	     (let ((proto (parse-definition var)))
		;; take care, we define a variable and not a function. That's
		;; why we invoke `parse-definition' only on `var'.
		(let ((global (declare-global-variable! 'static
							*module-name*
							(car proto)
							(cdr proto))))
		   (global-info-set! global #t)
		   global)))
	    ((eq? (global-info global) #t)
	     (user-error "find-and-check-globals!"
			 "Redefinition of global variable"
			 exp
			 #f))
	    ((eq? (global-class global) 'variable)
	     (global-info-set! global #t)
	     ;; we only check that the type of the variable is
	     ;; obj or procedure.
	     (or (null? (global-type global))
		 (eq? (global-type global) 'procedure)
		 (eq? (global-type global) 'obj)))
	    ((eq? (global-class global) 'inline)
	     (mismatch-error exp))
	    ((not (check-procedure-definition?
		   global
		   '()
		   'procedure
		   (cdr (parse-definition proto))))
	     (mismatch-error exp))
	    (else
	     (global-info-set! global #t)
	     'ok)))))

;*---------------------------------------------------------------------*/
;*    check-inline-definition! ...                                     */
;*    -------------------------------------------------------------    */
;*    We continue the hack starter in module read_inline about         */
;*    inline definition. The really end of this hack is in the module  */
;*    ast_build.                                                       */
;*---------------------------------------------------------------------*/
(define (check-inline-definition! var proto exp)
   (trace init "check-inline-definition!: " (shape var) #\Newline)
   (let (var-name type-type)
      (if (symbol? var)
	  (let ((v.t (parse-formal-ident var)))
	     (set! var-name (car v.t))
	     (set! type-type (cdr v.t)))
	  (begin
	     (set! var-name (global-name var))
	     (set! type-type (function-type-res (global-value var)))))
      (let ((global (if (global? var)
			var
			(find-global var-name *module-name*))))
	 (cond
	    ((not (global? global))
	     (let ((proto (parse-definition (cons 'inline proto))))
		(declare-global-procedure! 'static
					   *module-name*
					   (car proto)
					   (cdr proto))))
	    ((eq? (global-class global) 'variable)
	     (mismatch-error exp))
	    ((eq? (global-class global) 'funtion)
	     (mismatch-error exp))
	    ((global? var)
	     'ok)
	    ((not (check-procedure-definition?
		   global
		   '()
		   'inline
		   (cdr (parse-definition (cons 'inline proto)))))
	     (mismatch-error exp))
	    (else
	     (global-info-set! global #t)
	     'ok)))))

;*---------------------------------------------------------------------*/
;*    mismatch-error ...                                               */
;*---------------------------------------------------------------------*/
(define (mismatch-error exp)
   (user-error "find-and-check-globals!"
	       "Prototype and definition don't match"
	       exp))
