;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/cigloo0.1/Parser/parser.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Nov 24 11:17:34 1995                          */
;*    Last change :  Wed Feb  7 09:42:05 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The C syntax                                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module parser_parser
   (include "Translate/ast.sch")
   (import  translate_declaration
	    engine_param
	    parser_lexer
	    translate_decl)
   (export  parser))

;*---------------------------------------------------------------------*/
;*    parser ...                                                       */
;*---------------------------------------------------------------------*/
(define parser
   (lalr-grammar

      ;; tokens
      (CONSTANT PAR-OPEN PAR-CLO BRA-OPEN BRA-CLO ANGLE-OPEN ANGLE-CLO
       SEMI-COMMA COMMA DOT LDOTS -> ! % ^ & * = / + ~ - >> << | != ==
       <<= >>= += -= *= /= %= ^= &= |= ++ -- ID && || ? : TYPE-ID <= >=
       < > asm auto break case char const continue default do double else
       entry enum extern float for fortran goto if int long register return
       short signed sizeof static struct switch typedef union unsigned void
       volatile while)
 
      ;; we build the overall list in a inversed way in order to
      ;; remove a shift/reduce in the grammar.
      (file
       (()
	'())
       ((file external-definition)
	`(,external-definition ,@file)))

      (external-definition
       ((function-definition)
	function-definition)
       ((declaration)
	declaration))

      (declaration
       ((declaration-specifiers SEMI-COMMA)
	(ast-declare #f
		     declaration-specifiers
		     '()))
       ((declaration-specifiers init-declarator-list SEMI-COMMA)
	;; since the C grammar does not seem to be Lalr we are
	;; obliged to do an awful hack in order to recognize, before
	;; reading next expression, typedef form in order to change
	;; the lexer behavior.
	(if (typedef-sspec? (storage-class-spec-of-decl-spec
			     declaration-specifiers))
	    (for-each (lambda (decl)
			 ;; there is no need for a match here as in the
			 ;; translate-declaration function because
			 ;; we know that decl is not in a list
			 (let* ((t-ident (get-decl-ident decl))
				(t-id    (ident-id t-ident)))
			    (define-type-id t-id)))
		      init-declarator-list))
	(ast-declare #f
		     declaration-specifiers
		     init-declarator-list)))
      
      (declaration-specifiers
       ((storage-class-specifier)
	`(,storage-class-specifier))
       ((storage-class-specifier declaration-specifiers)
	`(,storage-class-specifier ,@declaration-specifiers))
       ((type-specifier)
	`(,type-specifier))
       ((type-specifier declaration-specifiers)
	`(,type-specifier ,@declaration-specifiers)))
      
      (init-declarator-list
       ((init-declarator)
	`(,init-declarator))
       ((init-declarator COMMA init-declarator-list)
	`(,init-declarator ,@init-declarator-list)))
      
      (init-declarator
       ((declarator)
	declarator)
       ((declarator = initializer)
	`(,declarator ,initializer)))
      
      (storage-class-specifier
       ((TYPEDEF)
	(ast-storage-class-spec (car TYPEDEF) 'TYPEDEF))
       ((EXTERN)
	(ast-storage-class-spec (car EXTERN) 'EXTERN))
       ((STATIC)
	(ast-storage-class-spec (car STATIC) 'STATIC))
       ((AUTO)
	(ast-storage-class-spec (car AUTO) 'AUTO))
       ((REGISTER)
	(ast-storage-class-spec (car REGISTER) 'REGISTER)))
      
      (type-specifier
       ((CHAR)
	(ast-type-spec (car CHAR) 'CHAR "char" #unspecified))
       ((SHORT)
	(ast-type-spec (car SHORT) 'SHORT "short" #unspecified))
       ((INT)
	(ast-type-spec (car INT) 'INT "int" #unspecified))
       ((LONG)
	(ast-type-spec (car LONG) 'LONG "long" #unspecified))
       ((SIGNED)
	(ast-type-spec (car SIGNED) 'SIGNED "signed" #unspecified))
       ((UNSIGNED)
	(ast-type-spec (car UNSIGNED) 'UNSIGNED "unsigned" #unspecified))
       ((FLOAT)
	(ast-type-spec (car FLOAT) 'FLOAT "float" #unspecified))
       ((DOUBLE)
	(ast-type-spec (car DOUBLE) 'DOUBLE "double" #unspecified))
       ((CONST)
	(ast-type-spec (car CONST) 'CONST "const" #unspecified))
       ((VOLATILE)
	(ast-type-spec (car VOLATILE) 'VOLATILE "volatile" #unspecified))
       ((VOID)
	(ast-type-spec (car VOID) 'VOID "void" #unspecified))
       ((struct-or-union-specifier)
	(ast-type-spec (ast-coord struct-or-union-specifier)
		       'struct
		       #unspecified
		       struct-or-union-specifier))
       ((enum-specifier)
	(ast-type-spec (ast-coord enum-specifier)
		       'enum
		       #unspecified
		       enum-specifier))
       ((TYPE-ID)
	(ast-type-spec (car TYPE-ID) 'TYPE-ID (cadr TYPE-ID) #unspecified)))
      
      (struct-or-union-specifier
       ((struct-or-union identifier BRA-OPEN struct-declaration-list BRA-CLO)
	(ast-struct-spec (car struct-or-union)
			 (cdr struct-or-union)
			 identifier
			 struct-declaration-list))
       ((struct-or-union BRA-OPEN struct-declaration-list BRA-CLO)
	(ast-struct-spec (car struct-or-union)
			 (cdr struct-or-union)
			 (ast-ident #f (symbol->string
					(gensym (string-append *iname*
							       "__s"))))
			 struct-declaration-list))
       ((struct-or-union identifier)
	(ast-struct-spec (car struct-or-union)
			 (cdr struct-or-union)
			 identifier
			 '())))
      
      (struct-or-union
       ((STRUCT)
	(cons (car STRUCT) 'STRUCT))
       ((UNION)
	(cons (car UNION) 'UNION)))
      
      (struct-declaration-list
       ((struct-declaration)
	`(,struct-declaration))
       ((struct-declaration struct-declaration-list)
	`(,struct-declaration ,@struct-declaration-list)))
      
      (struct-declaration
       ((type-specifier-list struct-declarator-list SEMI-COMMA)
	`(,type-specifier-list ,struct-declarator-list)))
      
      (struct-declarator-list
       ((struct-declarator)
	`(,struct-declarator))
       ((struct-declarator COMMA struct-declarator-list)
	`(,struct-declarator ,@struct-declarator-list)))
      
      (struct-declarator
       ((declarator)
	declarator)
       ((: constant-expr)
	(ast-decl : #f #f))
       ((declarator : constant-expr)
	declarator))
      
      (enum-specifier
       ((ENUM BRA-OPEN enumerator-list BRA-CLO)
	(ast-enum-spec (car ENUM) #f enumerator-list))
       ((ENUM identifier BRA-OPEN enumerator-list BRA-CLO)
	(ast-enum-spec (car ENUM) identifier enumerator-list))
       ((ENUM identifier)
	(ast-enum-spec (car ENUM) identifier #f)))
      
      (enumerator-list
       ((enumerator)
	`(,enumerator))
       ((enumerator COMMA enumerator-list)
	`(,enumerator ,@enumerator-list)))
      
      (enumerator
       ((identifier)
	identifier)
       ((identifier = constant-expr)
	identifier))
      
      (declarator
       ((declarator2)
	(ast-decl #f #f declarator2))
       ((pointer declarator2)
	(ast-decl #f pointer declarator2)))
       
      (declarator2
       ((identifier) 
	(ast-decl2 #f identifier #f #f #f #f #f))
       ((PAR-OPEN declarator PAR-CLO)
	(ast-decl2 #f #f declarator #f #f #f #f))
       ((declarator2 ANGLE-OPEN ANGLE-CLO)
	(ast-decl2 #f #f #f declarator2 '() #f #f))
       ((declarator2 ANGLE-OPEN constant-expr ANGLE-CLO)
	(ast-decl2 #f #f #f declarator2 constant-expr #f #f))
       ((declarator2 PAR-OPEN PAR-CLO)
	(ast-decl2 #f #f #f declarator2 #f '() #f))
       ((declarator2 PAR-OPEN parameter-type-list PAR-CLO)
	(ast-decl2 #f #f #f declarator2 #f parameter-type-list #f))
       ((declarator2 PAR-OPEN parameter-identifier-list PAR-CLO)
	(ast-decl2 #f #f #f declarator2 #f #f parameter-identifier-list)))
      
      (pointer
       ((*)
	(ast-ptr (car *) #f #f))
       ((* type-specifier-list)
	(ast-ptr (car *) type-specifier-list #f))
       ((* pointer)
	(ast-ptr (car *) #f pointer))
       ((* type-specifier-list pointer)
	(ast-ptr (car *) type-specifier-list pointer)))
      
      (type-specifier-list
       ((type-specifier)
	`(,type-specifier))
       ((type-specifier type-specifier-list)
	`(,type-specifier ,@type-specifier-list)))
      
      (parameter-identifier-list
       ((identifier-list)
	(reverse! identifier-list))
       ((identifier-list COMMA LDOTS)
	(reverse! (cons '... identifier-list))))

      ;; we build the list in the reverse order.
      (identifier-list
       ((identifier)
	`(,identifier))
       ((identifier-list COMMA identifier)
	`(,identifier ,@identifier-list)))
      
      (parameter-type-list
       ((parameter-list)
	(reverse! parameter-list))
       ((parameter-list COMMA LDOTS)
	(reverse! (cons '... parameter-list))))

      ;; this list is built in the reverse order
      (parameter-list
       ((parameter-declaration)
	`(,parameter-declaration))
       ((parameter-list COMMA parameter-declaration)
	`(,parameter-declaration ,@parameter-list)))
      
      (parameter-declaration
       ((type-specifier-list declarator)
	(ast-para-decl #f type-specifier-list declarator #f))
       ((type-name)
	(ast-para-decl #f #f #f type-name)))
      
      (type-name
       ((type-specifier-list)
	(ast-t-name #f type-specifier-list #f))
       ((type-specifier-list abstract-declarator)
	(ast-t-name #f type-specifier-list abstract-declarator)))
      
      (abstract-declarator
       ((pointer)
	(ast-adecl #f pointer #f))
       ((abstract-declarator2)
	(ast-adecl #f #f abstract-declarator2))
       ((pointer abstract-declarator2)
	(ast-adecl #f pointer abstract-declarator2)))
      
      (abstract-declarator2
       ((PAR-OPEN abstract-declarator PAR-CLO)
	(ast-adecl2 #f abstract-declarator #f #f #f))
       ((ANGLE-OPEN ANGLE-CLO)
	(ast-adecl2 #f #f #f '() #f))
       ((ANGLE-OPEN constant-expr ANGLE-CLO)
	(ast-adecl2 #f #f #f constant-expr #f))
       ((abstract-declarator2 ANGLE-OPEN ANGLE-CLO)
	(ast-adecl2 #f #f abstract-declarator2 '() #f))
       ((abstract-declarator2 ANGLE-OPEN constant-expr ANGLE-CLO)
	(ast-adecl2 #f #f abstract-declarator2 constant-expr #f))
       ((PAR-OPEN PAR-CLO)
	(ast-adecl2 #f #f #f #f '()))
       ((PAR-OPEN parameter-type-list PAR-CLO)
	(ast-adecl2 #f #f #f #f parameter-type-list))
       ((abstract-declarator2 PAR-OPEN PAR-CLO)
	(ast-adecl2 #f #f abstract-declarator2 #f '()))
       ((abstract-declarator2 PAR-OPEN parameter-type-list PAR-CLO)
	(ast-adecl2 #f #f abstract-declarator2 #f parameter-type-list)))
      
      (initializer
       ((assignment-expr)
	#unspecified)
       ((BRA-OPEN initializer-list BRA-CLO)
	#unspecified)
       ((BRA-OPEN initializer-list COMMA BRA-CLO)
	#unspecified))
       
      (initializer-list
       ((initializer)
	#unspecified)
       ((initializer-list COMMA initializer)
	#unspecified))
      
      (primary-expr
       ((identifier)
	(ident-id identifier))
       ((CONSTANT)
	(cadr CONSTANT))
       ((PAR-OPEN expr PAR-CLO)
	`("(" ,expr ")")))
      
      (postfix-expr
       ((primary-expr)
	primary-expr)
       ((postfix-expr ANGLE-OPEN expr ANGLE-CLO)
	`(,postfix-expr "[" ,expr "]"))
       ((postfix-expr PAR-OPEN PAR-CLO)
	`(,postfix-expr "[]"))
       ((postfix-expr PAR-OPEN argument-expr-list PAR-CLO)
	`(,postfix-expr "(" ,argument-expr-list ")"))
       ((postfix-expr DOT identifier)
	`(,postfix-expr "." ,identifier))
       ((postfix-expr -> identifier)
	`(,postfix-expr "->" ,identifier))
       ((postfix-expr ++)
	`(,postfix-expr "++"))
       ((postfix-expr --)
	`(,postfix-expr "--")))
      
      (argument-expr-list
       ((assignment-expr)
	#unspecified)
       ((argument-expr-list COMMA assignment-expr)
	#unspecified))
      
      (unary-expr
       ((postfix-expr)
	postfix-expr)
       ((++ unary-expr)
	`("++" ,unary-expr))
       ((-- unary-expr)
	`("--" ,unary-expr))
       ((unary-operator cast-expr)
	`(,unary-operator ,cast-expr))
       ((SIZEOF unary-expr)
	`("sizeof(" ,unary-expr ")"))
       ((SIZEOF PAR-OPEN type-name PAR-CLO)
	`("sizeof(" ,type-name ")")))
      
      (unary-operator
       ((&)
	&)
       ((*)
	*)
       ((+)
	+)
       ((-)
	-)
       ((~)
	~)
       ((!)
	!))
      
      (cast-expr
       ((unary-expr)
	unary-expr)
       ((PAR-OPEN type-name PAR-CLO cast-expr)
	`("(" ,type-name ,")" ,cast-expr)))
      
      (multiplicative-expr
       ((cast-expr)
	cast-expr)
       ((multiplicative-expr * cast-expr)
	`(,multiplicative-expr "*" ,cast-expr))
       ((multiplicative-expr / cast-expr)
	`(,multiplicative-expr "/" ,cast-expr))
       ((multiplicative-expr % cast-expr)
	`(,multiplicative-expr "%" ,cast-expr)))
      
      (additive-expr
       ((multiplicative-expr)
	multiplicative-expr)
       ((additive-expr + multiplicative-expr)
	`(,additive-expr "+" ,multiplicative-expr))
       ((additive-expr - multiplicative-expr)
	`(,additive-expr "-" ,multiplicative-expr)))
      
      (shift-expr
       ((additive-expr)
	additive-expr)
       ((shift-expr << additive-expr)
	`(,shift-expr "<<" ,additive-expr))
       ((shift-expr >> additive-expr)
	`(,shift-expr ">>" ,additive-expr)))
      
      (relational-expr
       ((shift-expr)
	shift-expr)
       ((relational-expr < shift-expr)
	`(,relational-expr "<" ,shift-expr))
       ((relational-expr > shift-expr)
	`(,relational-expr ">" ,shift-expr))
       ((relational-expr <= shift-expr)
	`(,relational-expr "<=" ,shift-expr))
       ((relational-expr >= shift-expr)
	`(,relational-expr ">=" ,shift-expr)))
      
      (equality-expr
       ((relational-expr)
	relational-expr)
       ((equality-expr == relational-expr)
	`(,equality-expr "==" ,relational-expr))
       ((equality-expr != relational-expr)
	`(,equality-expr "!=" ,relational-expr)))
      
      (and-expr
       ((equality-expr)
	equality-expr)
       ((and-expr & equality-expr)
	`(,and-expr "&" ,equality-expr)))
      
      (exclusive-or-expr
       ((and-expr)
	and-expr)
       ((exclusive-or-expr ^ and-expr)
	`(,exclusive-or-expr "^" ,and-expr)))
      
      (inclusive-or-expr
       ((exclusive-or-expr)
	exclusive-or-expr)
       ((inclusive-or-expr | exclusive-or-expr)
	`(,inclusive-or-expr "|" ,exclusive-or-expr)))
      
      (logical-and-expr
       ((inclusive-or-expr)
	inclusive-or-expr)
       ((logical-and-expr && inclusive-or-expr)
	`(,logical-and-expr "&&" ,inclusive-or-expr)))
      
      (logical-or-expr
       ((logical-and-expr)
	logical-and-expr)
       ((logical-or-expr || logical-and-expr)
	`(,logical-or-expr "||" ,logical-and-expr)))
      
      (conditional-expr
       ((logical-or-expr)
	logical-or-expr)
       ((logical-or-expr@lexp1 ? logical-or-expr@lexp2 : conditional-expr)
	`(,lexp1 "?" ,lexp2 ":" ,conditional-expr)))
      
      (assignment-expr
       ((conditional-expr)
	conditional-expr)
       ((unary-expr assignment-operator assignment-expr)
	`(,unary-expr ,assignment-operator ,assignment-expr)))
      
      (assignment-operator
       ((=)
	=)
       ((*=)
	*=)
       ((/=)
	/=)
       ((%=)
	%=)
       ((+=)
	+=)
       ((-=)
	-=)
       ((<<=)
	<<=)
       ((>>=)
	>>=)
       ((&=)
	&=)
       ((^=)
	^=)
       ((|=)
	|=))
      
      (expr
       ((assignment-expr)
	assignment-expr)
       ((expr COMMA assignment-expr)
	`(,expr ,assignment-expr)))
      
      (constant-expr
       ((conditional-expr)
	conditional-expr))
      
      (statement
       ((labeled-statement)
	#unspecified)
       ((compound-statement) 
	#unspecified)
       ((expression-statement) 
	#unspecified)
       ((selection-statement) 
	#unspecified)
       ((iteration-statement) 
	#unspecified)
       ((jump-statement) 
	#unspecified))
      
      (labeled-statement
       ((identifier : statement)
	#unspecified)
       ((CASE constant-expr : statement)
	#unspecified)
       ((DEFAULT : statement)
	#unspecified))
      
      (compound-statement
       ((BRA-OPEN BRA-CLO)
	#unspecified)
       ((BRA-OPEN statement-list BRA-CLO)
	#unspecified)
       ((BRA-OPEN declaration-list BRA-CLO)
	declaration-list)
       ((BRA-OPEN declaration-list statement-list BRA-CLO)
	declaration-list))
       
      (declaration-list
       ((declaration)
	`(,declaration))
       ((declaration declaration-list)
	`(,declaration ,@declaration-list)))
      
      (statement-list
       ((statement)
	#unspecified)
       ((statement-list statement)
	#unspecified))
      
      (expression-statement
       ((SEMI-COMMA)
	SEMI-COMMA)
       ((expr SEMI-COMMA)
	`(,expr ,SEMI-COMMA)))
      
      (selection-statement
       ((IF PAR-OPEN expr PAR-CLO statement)
	#unspecified)
       ((IF PAR-OPEN expr PAR-CLO statement ELSE statement)
	#unspecified)
       ((SWITCH PAR-OPEN expr PAR-CLO statement)
	#unspecified))
      
      (iteration-statement
       ((WHILE PAR-OPEN expr PAR-CLO statement)
	#unspecified)
       ((DO statement WHILE PAR-OPEN expr PAR-CLO SEMI-COMMA)
	#unspecified)
       ((FOR PAR-OPEN SEMI-COMMA SEMI-COMMA PAR-CLO statement)
	#unspecified)
       ((FOR PAR-OPEN SEMI-COMMA SEMI-COMMA expr PAR-CLO statement)
	#unspecified)
       ((FOR PAR-OPEN SEMI-COMMA expr SEMI-COMMA PAR-CLO statement)
	#unspecified)
       ((FOR PAR-OPEN SEMI-COMMA expr SEMI-COMMA expr PAR-CLO statement)
	#unspecified)
       ((FOR PAR-OPEN expr SEMI-COMMA SEMI-COMMA PAR-CLO statement)
	#unspecified)
       ((FOR PAR-OPEN expr SEMI-COMMA SEMI-COMMA expr PAR-CLO statement)
	#unspecified)
       ((FOR PAR-OPEN expr SEMI-COMMA expr SEMI-COMMA PAR-CLO statement)
	#unspecified)
       ((FOR PAR-OPEN expr SEMI-COMMA expr SEMI-COMMA expr PAR-CLO statement)
	#unspecified))
      
      (jump-statement
       ((GOTO identifier SEMI-COMMA)
	#unspecified)
       ((CONTINUE SEMI-COMMA)
	#unspecified)
       ((BREAK SEMI-COMMA)
	#unspecified)
       ((RETURN SEMI-COMMA)
	#unspecified)
       ((RETURN expr SEMI-COMMA)
	#unspecified))

      (function-definition
       ((declarator function-body)
	(ast-fun-def #f #f '() declarator function-body))
       ((declaration-specifiers declarator function-body)
	(ast-fun-def #f #f declaration-specifiers declarator function-body)))
      
      (function-body
       ((compound-statement)
	#unspecified)
       ((declaration-list compound-statement)
	declaration-list))
      
      (identifier
       ((ID)
	(ast-ident (car ID) (cadr ID))))))
