/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  netpriv.h
 * Purpose: Miscellaeous definitions for the network library
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Packet driver error return codes:
 */
#define	NO_ERROR	 0
#define	BAD_HANDLE	-1	/* invalid handle number 		*/
#define	NO_CLASS	-2	/* no interfaces of specified class	*/
#define	NO_TYPE		-3	/* no interfaces of specified type	*/
#define	NO_NUMBER	-4	/* no interfaces of specified number	*/
#define	BAD_TYPE	-5	/* bad packet type specified		*/
#define	NO_MULTICAST	-6	/* interface does not support multicast	*/
#define	CANT_TERMINATE	-7	/* packet driver cannot terminate	*/
#define	BAD_MODE	-8	/* invalid receiver mode		*/
#define	NO_SPACE	-9	/* insufficient space			*/
#define	TYPE_INUSE	-10	/* type not released			*/
#define	BAD_COMMAND	-11	/* command not implemented		*/
#define	CANT_SEND	-12	/* can't send packet (hardware error)	*/
#define CANT_SET	-13	/* can't change hardware address	*/
#define BAD_ADDRESS	-14	/* bad hardware address			*/
#define CANT_RESET	-15	/* couldn't reset interface		*/



/*
 **************************************************************************
 *
 * Usable Ethernet Protocol ID's:
 */
#define ETH_P_IP	0x0800		/* Internet Protocol packet	*/
#define ETH_P_X25	0x0805		/* CCITT X.25			*/
#define ETH_P_ARP	0x0806		/* Address Resolution packet	*/
#define ETH_P_ATALK	0x809B		/* Appletalk DDP		*/
#define ETH_P_IPX	0x8137		/* IPX over DIX			*/



/*
 **************************************************************************
 * 
 * Global variables in the network library:
 *
 */
extern unsigned char myhwaddr[ETH_ALEN]; /* my own hardware address	*/
extern unsigned char bcasthw[ETH_ALEN];  /* broadcast hardware addr	*/
extern t_ipaddr      myipaddr;           /* my own IP address		*/
extern t_ipaddr      mynetmask;		 /* netmask for my network	*/
extern char         *net_module_name;	 /* initialized module's name	*/



/*
 **************************************************************************
 *
 * Public routines of the packet driver interface:
 */

/* Initialize packet driver */
extern void init_packet(void);

/* Setup receiver routine for a packet type */
extern int reg_type(int typeval, void (* receive)());

/* Write a packet to the network */
extern int write_packet(char *buf, int bufsize, int typeval,
							unsigned char *addr);


/*
 **************************************************************************
 *
 * External routines in the utility modules:
 */

/* Compute IP header checksum */
extern int ipchksum(unsigned char *buf, int len);

