/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  boot.c
 * Purpose: Perform the actual booting process
 * Entries: do_boot
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "../../headers/general.h"
#include "../public/net.h"
#include "../public/arpa.h"
#include "../public/boot.h"
#include "../public/romlib.h"
#include "./bootpriv.h"
#include "./menu.h"
#include "./load.h"


/*
 **************************************************************************
 * 
 * Print an IP number. Note that the IP address should be in network
 * order.
 */
static void printip(t_ipaddr ip)
{
  unsigned char *cp = &(unsigned char)ip;

  printf("%u.%u.%u.%u", cp[3], cp[2], cp[1], cp[0]);
}



/*
 **************************************************************************
 * 
 * Print some information from the BOOTP answer.
 */
static void printbootp(struct bootp *bp)
{
  printf("\n\nLocal IP:  "); printip(ntohl(bp->bp_yiaddr));
  printf("\nServer IP: "); printip(ntohl(bp->bp_siaddr));
  if (bp->bp_sname[0])
	printf(" (%ls)", bp->bp_sname, sizeof(bp->bp_sname));
  printf("\nFile name: %ls\n\n\n", bp->bp_file, sizeof(bp->bp_file));
}



/*
 **************************************************************************
 * 
 * Actually perform the booting process by first calling the BOOTP client,
 * and then loading the operating system using TFTP.
 *
 */
void do_boot(void)
{
  struct bootp *bp;

  /*
   * Get BOOTP record from server, also loading an optional extension file.
   */
  if ((bp = bootp()) != NULL) {
#ifndef NOMENU
	int status;

	/* Only loop if the menu can be redisplayed */
	while (TRUE) {
		if ((status = domenu(bp)) != MENU_ABORT) {
			printbootp(bp);
			load(bp);
		}
		if (status != MENU_OK)
			break;
	}
#else
	printbootp(bp);
	load(bp);
#endif
  }

  /*
   * If the image loader returned, there was an error, so continue with the
   * normal boot process.
   */
  printf("Insert boot disk and press any key to continue\n");
  (void)getkey(0);
}
