char *helpmessage[] =
{
  "O(a^b)=o(a^b)=p-adic or power series zero with precision given by b",
  "abs(x)=absolute value (or modulus) of x",
  "acos(x)=inverse cosine of x",
  "acosh(x)=inverse hyperbolic cosine of x",
  "addell(e,z1,z2)=sum of the points z1 and z2 on elliptic curve e",
  "addprimes(x)=add primes in the vector x (with at most 20 components)\nto the prime table",
  "adj(x)=adjoint matrix of x",
  "agm(x,y)=arithmetic-geometric mean of x and y",
  "akell(e,n)=computes the n-th Fourier coefficient of the L-function of the\nelliptic curve e",
  "algdep(x,n)=algebraic relations up to degree n of x",
  "algdep2(x,n,dec)=algebraic relations up to degree n of x where dec is as in \nlindep2",
  "algtobasis(nf,x)=transforms the algebraic number x into a column vector on the\nintegral basis nf[7]",
  "allocatemem(s)=allocates a new stack of s bytes, or doubles the stack if\nsize is 0, 1 or 2, with a warning if size=0",
  "anell(e,n)=computes the first n Fourier coefficients of the L-function of\nthe elliptic curve e (n<32768)",
  "apell(e,p)=computes a_p for the elliptic curve e using Shanks-Mestre's method",
  "apell2(e,p)=computes a_p for the elliptic curve e using Jacobi symbols",
  "apprpadic(x,a)=p-adic roots of the polynomial x congruent to a mod p",
  "arg(x)=argument of x,such that -pi<arg(x)<=pi",
  "asin(x)=inverse sine of x",
  "asinh(x)=inverse hyperbolic sine of x",
  "assmat(x)=associated matrix to polynomial x",
  "atan(x)=inverse tangent of x",
  "atanh(x)=inverse hyperbolic tangent of x",
  "basis(x)=integral basis of the field Q[a], where a is a root of the\npolynomial x, using the round 4 algorithm",
  "basis2(x)=integral basis of the field Q[a], where a is a root of the\npolynomial x, using the round 2 algorithm",
  "basistoalg(nf,x)=transforms the vertical vector x on the integral basis into\nan algebraic number",
  "bernreal(x)=Bernoulli number B_x, as a real number with the current precision",
  "bernvec(x)=Vector of rational Bernoulli numbers B_0, B_2,... up to B_(2x)",
  "bestappr(x,k)=gives the best approximation to the real x with denominator\nless or equal to k",
  "bezout(x,y)= gives a 3-dimensional row vector [u,v,d] such that\nd=gcd(x,y) and u*x+v*y=d",
  "bezoutres(x,y)= gives a 3-dimensional row vector [u,v,d] such that\nd=resultant(x,y) and u*x+v*y=d, where x and y are polynomials",
  "bigomega(x)=number of repeated prime divisors of x",
  "bilhell(e,z1,z2)=canonical bilinear form for the points z1,z2 on the elliptic\ncurve e. Either z1 or z2 can also be a vector/matrix of points",
  "bin(x,y)=binomial coefficient x*(x-1)...*(x-y+1)/y! defined for y in Z and\nany x",
  "binary(x)=gives the vector formed by the binary digits of x (x C-integer)",
  "bittest(x,n)=gives bit number n (coefficient of 2^n) of the integer x",
  "boundcf(x,lmax)=continued fraction expansion of x with at most lmax terms",
  "boundfact(x,lim)=partial factorization of the integer x (using primes up\nto lim)",
  "box(w,x2,y2)=if the cursor is at position (x1,y1), draw a box with diagonal\n(x1,y1) and (x2,y2) in rectwindow w (cursor does not move)",
  "buchcertify(bnf)=certify the correctness (i.e. remove the GRH) of the bnf\ndata output by buchinit or buchinitfu",
  "buchfu(bnf)=compute the fundamental units of the number field bnf output by\nbuchinit",
  "buchgen(P,...)=compute the structure of the class group and the\nregulator for the number field defined by the polynomial P. See manual\nfor the other parameters (which can be omitted)",
  "buchgenforcefu(P,...)=compute the structure of the class group, the regulator\na primitive root of unity and a system of fundamental units for the number\nfield defined by the polynomial P, and insist until the units are obtained.\nSee manual for the other parameters (which can be omitted)",
  "buchgenfu(P,...)=compute the structure of the class group, the regulator\na primitive root of unity and a system of fundamental units (if they are\nnot too large) for the number field defined by the polynomial P. See manual for the other parameters (which can be omitted)",
  "buchimag(D,...)=compute the structure of the class group of the complex\nquadratic field of discriminant D<0. See manual for the other parameters\n(which can be omitted)",
  "buchinit(P,...)=compute the necessary data for future use in ideal and\nunit group computations. See manual for details",
  "buchinitforcefu(P,...)=compute the necessary data for future use in ideal and\nunit group computations, and insist on having fundamental units.\nSee manual for details",
  "buchinitfu(P,...)=compute the necessary data for future use in ideal and unit\ngroup computations, including fundamental units if they are not too large.\nSee manual for details",
  "buchnarrow(bnf)=given a big number field as output by buchinitxx, gives as a\n3-component vector the structure of the narrow class group",
  "buchray(bnf,ideal)=given a big number field as output by buchinitfu (only) and\n an ideal or a 2-component row vector formed by an ideal and a list of R1\nzeros or ones representing a module, finds the ray class group structure\ncorresponding to this module",
  "buchrayinit(bnf,ideal)=given a big number field as output by buchinitfu (only) and\n an ideal or a 2-component row vector formed by an ideal and a list of R1\nzeros or ones representing a module, initializes data for computing in the ray class group \ncorresponding to this module",
  "buchreal(D,...)=compute the structure of the class group and the\nregulator of the real quadratic field of discriminant D>0 in the wide sense.\nSee manual for the other parameters (which can be omitted)",
  "bytesize(x)=number of bytes occupied by the complete tree of the object x",
  "ceil(x)=ceiling of x=smallest integer>=x",
  "centerlift(x)=centered lift of x. Same as lift except for integermods",
  "cf(x)=continued fraction expansion of x (x rational,real or rational function)",
  "cf2(b,x)=continued fraction expansion of x (x rational,real or rational\nfunction), where b is the vector of numerators of the continued fraction",
  "changevar(x,y)=change variables of x according to the vector y",
  "char(x,y)=det(y*I-x)=characteristic polynomial of the matrix x using the\ncomatrix",
  "char1(x,y)=det(y*I-x)=characteristic polynomial of the matrix x using Lagrange\ninterpolation",
  "char2(x,y)=characteristic polynomial of the matrix x expressed with variable y,\nusing the Hessenberg form. Can be much faster or much slower than char,\ndepending on the base ring",
  "chell(x,y)=change data on elliptic curve according to y=[u,r,s,t]",
  "chinese(x,y)=x,y being integers modulo mx and my,finds z such that\nz is congruent to x mod mx and y mod my",
  "chptell(x,y)=change data on point or vector of points x on an elliptic curve\naccording to y=[u,r,s,t]",
  "classno(x)=class number of discriminant x",
  "classno2(x)=class number of discriminant x",
  "coeff(x,s)=coefficient of degree s of x, or the s-th component for vectors\nor matrices (for which it is simpler to use x[])",
  "compimag(x,y)=Gaussian composition of the binary quadratic forms x and y\nof negative discriminant",
  "compo(x,s)=the s'th component of the internal representation of x.\nFor vectors or matrices, it is simpler to use x[]",
  "compositum(pol1,pol2)=compositum of the number fields defined by the polynomials pol1\nand pol2",
  "comprealraw(x,y)=Gaussian composition without reduction of the binary quadratic\nforms x and y of positive discriminant",
  "concat(x,y)=concatenation of x and y",
  "conj(x)=the algebraic conjugate of x",
  "conjvec(x)=conjugate vector of the algebraic number x",
  "content(x)=gcd of all the components of x, when this makes sense",
  "convol(x,y)=convolution (or Hadamard product) of two power series",
  "cos(x)=cosine of x",
  "cosh(x)=hyperbolic cosine of x",
  "cursor(w)=current position of cursor in rectwindow w",
  "cvtoi(x)=truncation of x, without taking into account loss of integer part\nprecision",
  "cyclo(n)=n-th cyclotomic polynomial",
  "denom(x)=denominator of x (or lowest common denominator in case of an array)",
  "deplin(x)=finds a linear dependence between the columns of the matrix x",
  "deriv(x,y)=derivative of x with respect to the main variable of y",
  "det(x)=determinant of the matrix x",
  "det2(x)=determinant of the matrix x (better for integer entries)",
  "detint(x)=some multiple of the determinant of the lattice generated by the\ncolumns of x (0 if not of maximal rank). Useful with hermitemod",
  "detr(x)=determinant of the matrix x having real entries",
  "dilog(x)=dilogarithm of x",
  "dirdiv(x,y)=division of the Dirichlet series x by the Dir. series y",
  "dirmul(x,y)=multiplication of the Dirichlet series x by the Dir. series y",
  "dirzetak(nf,b)=Dirichlet series of the Dedekind zeta function of the\nnumber field nf up to the bound b-1",
  "disc(x)=discriminant of the polynomial x",
  "discf(x)=discriminant of the number field defined by the polynomial x using round 4",
  "discf2(x)=discriminant of the number field defined by the polynomial x using round 2",
  "divisors(x)=gives a vector formed by the divisors of x in increasing order",
  "divres(x,y)=euclidean division of x by y giving as a 2-dimensional column\nvector the quotient and the remainder",
  "divsum(n,X,expr)=sum of expression expr, X running over the divisors of n",
  "draw(list)=draw vector of rectwindows list at indicated x,y positions;\nlist is a vector w1,x1,y1,w2,x2,y2,etc...",
  "eigen(x)=eigenvectors of the matrix x given as columns of a matrix",
  "eint1(x)=exponential integral E1(x)",
  "erfc(x)=complementary error function",
  "eta(x)=eta function without the q^(1/24)",
  "euler=euler()=euler's constant with current precision",
  "eval(x)=evaluation of x, replacing variables by their value",
  "exp(x)=exponential of x",
  "extract(x,y)=extraction of the components of the vector x according to the\nvector or mask y, from left to right (1, 2, 4, 8, ...for the first, second,\nthird, fourth,...component)",
  "fact(x)=factorial of x (x C-integer), the result being given as a real number",
  "factcantor(x,p)=factorization mod p of the polynomial x using Cantor-Zassenhaus",
  "factfq(x,p,a)=factorization of the polynomial x in the finite field\nF_p[X]/a(X)F_p[X]",
  "factmod(x,p)=factorization mod p of the polynomial x using Berlekamp",
  "factor(x)=factorization of x",
  "factoredbasis(x,p)=integral basis of the maximal order defined by the polynomial\nx, where p is the matrix of the factorization of the discriminant of x",
  "factoreddiscf(x,p)=discriminant of the maximal order defined by the polynomial\nx, where p is the matrix of the factorization of the discriminant of x",
  "factoredpolred(x,p)=reduction of the polynomial x, where p is the matrix of the\nfactorization of the discriminant of x (gives minimal polynomials only)",
  "factoredpolred2(x,p)=reduction of the polynomial x, where p is the matrix of\nthe factorization of the discriminant of x (gives elements and minimal\npolynomials)",
  "factornf(x,t)=factorization of the polynomial x over the number field defined\nby the polynomial t",
  "factorpadic(x,p,r)=p-adic factorization of the polynomial x to precision r,\nusing the round 4 algorithm",
  "factorpadic2(x,p,r)=p-adic factorization of the polynomial x to precision r,\nusing Buchmann-Lenstra",
  "factpol(x,l,hint)=factorization over Z of the polynomial x up to degree l\n(complete if l=0) using Hensel lift, knowing that the degree of each factor is a multiple of hint",
  "factpol2(x,l)=factorization over Z of the polynomial x up to degree l\n(complete if l=0) using root finding",
  "fibo(x)=fibonacci number of index x (x C-integer)",
  "floor(x)=floor of x=largest integer<=x",
  "for(X=a,b,seq)=the sequence is evaluated, X going from a up to b",
  "fordiv(n,X,seq)=the sequence is evaluated, X running over the divisors of n",
  "forprime(X=a,b,seq)=the sequence is evaluated, X running over the primes\nbetween a and b",
  "forstep(X=a,b,s,seq)=the sequence is evaluated, X going from a to b in\nsteps of s",
  "forvec(x=v,seq)=v being a vector of two-component vectors of length n, the\nsequence is evaluated with x[i] going from v[i][1] to v[i][2] for\ni=n,..,1",
  "frac(x)=fractional part of x=x-floor(x)",
  "galois(x)=Galois group of the polynomial x (see manual for group coding)",
  "galoisapply(nf,aut,x)=Apply the Galois automorphism sigma (polynomial or\npolymod) to the object x (element or ideal) in the number field nf",
  "galoisconj(nf)=list of conjugates of a root of the polynomial x=nf[1] in the\nsame number field, using p-adics, LLL on integral basis (not always complete)",
  "galoisconj1(nf)=list of conjugates of a root of the polynomial x=nf[1] in the\nsame number field nf, using complex numbers, LLL on integral basis (not\nalways complete)",  
  "galoisconjforce(nf)=list of conjugates of a root of the polynomial x=nf[1] in\nthe Galois number field nf, using p-adics, LLL on integral basis. Guaranteed\nto be complete if the field is Galois, otherwise there is an infinite loop",
  "gamh(x)=gamma of x+1/2 (x integer)",
  "gamma(x)=gamma function at x",
  "gauss(a,b)=gaussian solution of ax=b (a matrix,b vector)",
  "gcd(x,y)=greatest common divisor of x and y",
  "getheap()=2-component vector giving the current number of objects in the heap\nand the space they occupy",
  "getrand()=current value of random number seed",
  "getstack()=current value of stack pointer avma",
  "gettime()=time (in milliseconds) since last call to gettime",
  "globalred(e)=e being an elliptic curve, returns [N,[u,r,s,t],c], where N is the\nconductor of e, [u,r,s,t] leads to the standard model for e, and c is the\nproduct of the local Tamagawa numbers c_p",
  "goto(n)=go to label number n",
  "hclassno(x)=Hurwitz-Kronecker class number of x>0",
  "hell(e,x)=canonical height of point x on elliptic curve E defined by the\nvector e computed using theta-functions",
  "hell2(e,x)=canonical height of point x on elliptic curve E defined by the\nvector e computed using Tate's method",
  "hermite(x)=(upper triangular) Hermite normal form of x, basis for the lattice\nformed by the columns of x, using a naive algorithm",
  "hermitebatut(x)=2-component vector [H,U] such that H is an (upper\ntriangular) Hermite normal form of x, basis for the lattice formed by the\ncolumns of x, and U is a unimodular matrix such that xU=H, using Batut's\nalgorithm",
  "hermitehavas(x)=3-component vector [H,U,P] such that H is an (upper\ntriangular) Hermite normal form of x with extra zero columns, U is a\nunimodular matrix and P is a permutation of the rows such that\nP applied to xU gives H, using Havas's algorithm",
  "hermitemod(x,d)=(upper triangular) Hermite normal form of x, basis for the\nlattice formed by the columns of x, where d is the non-zero determinant of this\nlattice",
  "hermitemodid(x,d)=(upper triangular) Hermite normal form of x concatenated\nwith d times the identity matrix",
  "hermiteperm(x)=3-component vector [H,U,P] such that H is an (upper\ntriangular) Hermite normal form of x with extra zero columns, U is a\nunimodular matrix and P is a permutation of the rows such that\nP applied to xU gives H, using Batut's algorithm",
  "hess(x)=Hessenberg form of x",
  "hilb(x,y,p)=Hilbert symbol at p of x,y (integers or fractions)",
  "hilbert(n)=Hilbert matrix of order n (n C-integer)",
  "hilbp(x,y)=Hilbert symbol of x,y (where x or y is integermod or p-adic)",
  "hvector(n,X,expr)=row vector with n components of expression expr, the\nvariable X ranging from 1 to n",
  "hyperu(a,b,x)=U-confluent hypergeometric function",
  "i=i()=square root of -1",
  "idealadd(nf,x,y)=sum of two ideals x and y in the number field defined by nf",
  "idealaddone(nf,x,y)=when the sum of two ideals x and y in the number field K\ndefined by nf is equal to Z_K, gives a two-component vector [a,b] such\nthat a is in x, b is in y and a+b=1",
  "idealaddmultone(nf,list)=when the sum of the ideals in the number field K\ndefined by nf and given in the vector list is equal to Z_K, gives a vector\nof elements of the corresponding ideals who sum to 1",
  "idealappr(nf,x)=x being a fractional ideal, gives an element b such that\nv_p(b)=v_p(x) for all prime ideals p dividing x, and v_p(b)>=0 for all other p",
  "idealapprfact(nf,x)=x being a prime ideal factorization with possibly zero\nor negative exponents, gives an element b such that v_p(b)=v_p(x) for\nall prime ideals p dividing x, and v_p(b)>=0 for all other p",
  "idealchinese(nf,x,y)=x being a prime ideal factorization and y a vector of elements, gives an element b such that\nv_p(b-y_p)>=v_p(x) for all prime ideals p dividing x, and v_p(b)>=0 for all other p",
  "idealcoprime(nf,x,y)=gives an element b in nf such that b.x is an integral\nideal coprime to the integral ideal y",
  "idealdiv(nf,x,y)=quotient x/y of two ideals x and y in HNF in the number\nfield nf",
  "idealdivexact(nf,x,y)=quotient x/y of two ideals x and y in HNF in the\nnumber field nf when the quotient is known to be an integral ideal",
  "idealfactor(nf,x)=factorization of the ideal x given in HNF into prime\nideals in the number field nf",
  "idealhermite(nf,x)=hermite normal form of the ideal x in the number field\nnf, whatever form x may have",
  "idealhermite2(nf,a,b)=hermite normal form of the ideal aZ_K+bZ_K in the\nnumber field K defined by nf, where a and b are elements",
  "idealintersect(nf,x,y)=intersection of two ideals x and y in HNF in the\nnumber field defined by nf",
  "idealinv(nf,x)=inverse of the ideal x in the number field nf not using\nthe different",
  "idealinv2(nf,x)=inverse of the ideal x in the number field nf using the\ndifferent",
  "ideallllred(nf,x,vdir)=LLL reduction of the ideal x in the number field nf\nalong direction vdir, in HNF",
  "idealmul(nf,x,y)=product of the two ideals x and y in the number field nf",
  "idealmulred(nf,x,y)=reduced product of the two ideals x and y in the number\nfield nf",
  "idealnorm(nf,x)=norm of the ideal x in the number field nf",
  "idealpow(nf,x,n)=n-th power of the ideal x in HNF in the number field nf",
  "idealpowred(nf,x,n)=reduced n-th power of the ideal x in HNF in the number\nfield nf",
  "idealtwoelt(nf,x)=two-element representation of an ideal x in the number\nfield nf",
  "idealtwoelt2(nf,x,a)=two-element representation of an ideal x in the\nnumber field nf, with the first element equal to a",
  "idealval(nf,x,p)=valuation at p given in primedec format of the ideal x\nin the number field nf",
  "idmat(n)=identity matrix of order n (n C-integer)",
  "if(a,seq1,seq2)= if a is nonzero, seq1 is evaluated, otherwise seq2",
  "imag(x)=imaginary part of x",
  "image(x)=basis of the image of the matrix x",
  "image2(x)=basis of the image of the matrix x",
  "imagecompl(x)=vector of column indices not corresponding to the indices\ngiven by the function image",
  "imager(x)=basis of the image of the matrix x with real or nonexact complex\nentries",
  "incgam(s,x)=incomplete gamma function",
  "incgam1(s,x)=incomplete gamma function (for debugging only)",
  "incgam2(s,x)=incomplete gamma function (for debugging only)",
  "incgam3(s,x)=complementary incomplete gamma function",
  "incgam4(s,x,y)=incomplete gamma function where y=gamma(s) is precomputed",
  "indexrank(x)=gives two extraction vectors (rows and columns) for the matrix\nx such that the exracted matrix is square of maximal rank",
  "indsort(x)=indirect sorting of the vector x",
  "initalg(x)=x being a nonconstant irreducible polynomial, gives the vector:\n[x,[r1,r2],discf,index,[M,MC,T2,T,different] (see manual),r1+r2 first roots,\nintegral basis, matrix of power basis in terms of integral basis,\nmultiplication table of basis]",
  "initalgred(x)=x being a nonconstant irreducible polynomial, finds (using\npolred) a simpler polynomial pol defining the same number field, and gives\nthe vector: [pol,[r1,r2],discf,index,[M,MC,T2,T,different] (see manual),\nr1+r2 first roots, integral basis, matrix of power basis in terms of\nintegral basis, multiplication table of basis]",
  "initalgred2(P)=P being a nonconstant irreducible polynomial, gives a two-element\nvector [nf,mod(a,pol)], where nf is as output by initalgred and mod(a,pol) is\na polymod equal to mod(x,P) and pol=nf[1]",
  "initell(x)=x being the vector [a1,a2,a3,a4,a6], gives the vector:\n[a1,a2,a3,a4,a6,b2,b4,b6,b8,c4,c6,delta,j,[e1,e2,e3],w1,w2,eta1,eta2,q,area]",
  "initell2(x)=x being the vector [a1,a2,a3,a4,a6], gives the vector:\n[a1,a2,a3,a4,a6,b2,b4,b6,b8,c4,c6,delta,j,[e1,e2,e3],w1,w2,eta1,eta2,q,area]",
  "initrect(w,x,y)=initialize rectwindow w to size x,y",
  "initzeta(x)=compute number field information necessary to use zetak, where\nx is an irreducible polynomial",
  "integ(x,y)=formal integration of x with respect to the main variable of y",
  "intersect(x,y)=intersection of the vector spaces whose bases are the\ncolumns of x and y",
  "intgen(X=a,b,s)=general numerical integration of s from a to b with respect\nto X, to be used after removing singularities",
  "intinf(X=a,b,s)=numerical integration of s from a to b with respect to X,\nwhere a or b can be plus or minus infinity (1.0e4000), but of same sign",
  "intnum(X=a,b,s)=numerical integration of s from a to b with respect to X",
  "intopen(X=a,b,s)=numerical integration of s from a to b with respect to X,\nwhere s has only limits at a or b",
  "inverseimage(x,y)=an element of the inverse image of the vector y by the\nmatrix x if one exists, the empty vector otherwise",
  "isfund(x)=true(1) if x is a fundamental discriminant (including 1),\nfalse(0) if not",
  "isideal(nf,x)=true(1) if x is an ideal in the number field nf, false(0)\nif not",
  "isincl(x,y)=tests whether the number field defined by the polynomial x is\nisomorphic to a subfield of the one defined by y; 0 if not, otherwise all\nthe isomorphisms",
  "isinclfast(nf1,nf2)=tests whether the number nf1 is isomorphic to a subfield\nof nf2 or not. If it gives a non-zero result, this proves that this is the case.\nHowever if it gives zero, nf1 may still be isomorphic to a subfield of nf2\nso you have to use the much slower isincl to be sure",  
  "isirreducible(x)=true(1) if x is an irreducible non-constant polynomial,\nfalse(0) if x is reducible or constant",
  "isisom(x,y)=tests whether the number field defined by the polynomial x is\nisomorphic to the one defined by y; 0 if not, otherwise all the isomorphisms",
  "isisomfast(nf1,nf2)=tests whether the number fields nf1 and nf2 are isomorphic\nor not. If it gives a non-zero result, this proves that they are isomorphic.\nHowever if it gives zero, nf1 and nf2 may still be isomorphic so you have to\nuse the much slower isisom to be sure",
  "isoncurve(e,x)=true(1) if x is on elliptic curve e, false(0) if not",
  "isprime(x)=true(1) if x is a strong pseudoprime for 10 random bases,\nfalse(0) if not",
  "isprincipal(bnf,x)=bnf being output by buchinit, gives the vector of exponents on the\nclass group generators of x. In particular x is principal if and only if the result is\nthe zero vector",
  "isprincipalgen(bnf,x)=bnf being output by buchinit, gives [v,alpha,bitaccuracy],\nwhere v is the vector of exponents on the class group generators and alpha is the\ngenerator of the resulting principal ideal. In particular x is principal\nif and only if v is the zero vector",
  "isprincipalray(bnf,x)=bnf being output by buchrayinit, gives the vector of exponents on the\nray class group generators of x. In particular x is principal if and only if the result is\nthe zero vector",
  "isprincipalraygen(bnf,x)=bnf being output by buchrayinit, gives [v,alpha,bitaccuracy],\nwhere v is the vector of exponents on the class group generators and alpha is the\ngenerator of the resulting principal ideal. In particular x is principal\nif and only if v is the zero vector",
  "ispsp(x)=true(1) if x is a strong pseudoprime, false(0) if not",
  "isqrt(x)=integer square root of x (x integer)",
  "isset(x)=true(1) if x is a set (row vector with strictly increasing entries),\nfalse(0) if not",
  "issqfree(x)=true(1) if x is squarefree, false(0) if not",
  "issquare(x)=true(1) if x is a square, false(0) if not",
  "isunit(bnf,x)=bnf being output by buchinit, gives the vector of exponents of x on\nthe fundamental units and the roots of unity if x is a unit,\nthe empty vector otherwise",
  "jacobi(x)=eigenvalues and orthogonal matrix of eigenvectors of the real\nsymmetric matrix x",
  "jbesselh(n,x)=J-bessel function of index n+1/2 and argument x, where n is a\nnon-negative integer",
  "jell(x)=elliptic j invariant of x",
  "karamul(x,y,k)=karatsuba multiplication of polynomials x and y, recursively\ncalled k times",
  "kbessel(nu,x)=K-bessel function of index nu and argument x (x positive real\nof type real, nu of any scalar type)",
  "kbessel2(nu,x)=K-bessel function of index nu and argument x (x positive real\nof type real, nu of any scalar type)",
  "ker(x)=basis of the kernel of the matrix x",
  "keri(x)=basis of the kernel of the matrix x with integer entries",
  "kerint(x)=LLL-reduced Z-basis of the kernel of the matrix x with integral\nentries using a modified LLL",
  "kerint1(x)=LLL-reduced Z-basis of the kernel of the matrix x with rational\nentries using matrixqz3 and the HNF",
  "kerint2(x)=LLL-reduced Z-basis of the kernel of the matrix x with integral\nentries using a modified LLL",
  "kerr(x)=basis of the kernel of the matrix x with real or nonexact complex\nentries",
  "kill(x)= kills the present value of the variable or function x. Returns new\nvalue or 0",
  "killrect(w)=erase the rectwindow w",
  "kro(x,y)=kronecker symbol (x/y)",
  "label(n)=place at this point label number n",
  "lambdak(nfz,s)=Dedekind lambda function of the number field nfz at s, where\nnfz is the vector computed by initzeta (NOT by initalg)",
  "laplace(x)=replaces the power series sum of a_n*x^n/n! by sum of a_n*x^n",
  "lcm(x,y)=least common multiple of x and y=x*y/gcd(x,y)",
  "legendre(n)=legendre polynomial of degree n (n C-integer)",
  "length(x)=number of non code words in x",
  "lex(x,y)=compare x and y lexicographically (1 if x>y, 0 if x=y, -1 if x<y)",
  "lexsort(x)=sort the elements of the vector x in ascending lexicographic order",
  "lift(x)=lifts every element of Z/nZ to Z or Z[x]/PZ[x] to Z[x]",
  "lindep(x)=Z-linear dependencies between components of x (Hastad et al)",
  "lindep2(x,dec)=Z-linear dependencies between components of x using LLL, where\ndec should be about one half the number of decimal digits of precision",
  "line(w,x2,y2)=if cursor is at position (x1,y1), draw a line from (x1,y1) to\n(x2,y2) (and move the cursor) in the rectwindow w",
  "lines(w,listx,listy)=draws an open polygon in rectwindow w where listx and\nlisty contain the x (resp. y) coordinates of the vertices",
  "lll(x)=lll reduction of the vectors forming the matrix x (gives the\nunimodular transformation matrix)",
  "lll1(x)=old version of lll reduction of the vectors forming the matrix x\n(gives the unimodular transformation matrix)",
  "lllgen(x)=lll reduction of the vectors forming the matrix x with\npolynomial coefficients (gives the unimodular transformation matrix)",
  "lllgram(x)=lll reduction of the lattice whose gram matrix is x (gives the\nunimodular transformation matrix)",
  "lllgram1(x)=old version of lll reduction of the lattice whose gram matrix\nis x (gives the\nunimodular transformation matrix)",
  "lllgramgen(x)=lll reduction of the lattice whose gram matrix is x with\npolynomial coefficients (gives the unimodular transformation matrix)",
  "lllgramint(x)=lll reduction of the lattice whose gram matrix is the integral\nmatrix x (gives the unimodular transformation matrix)",
  "lllgramkerim(x)=kernel and lll reduction of the lattice whose gram matrix is\nthe integral matrix x",
  "lllgramkerimgen(x)=kernel and lll reduction of the lattice whose gram matrix is\nthe matrix x with polynomial coefficients",
  "lllint(x)=lll reduction of the vectors forming the matrix x when the gram\nmatrix is integral (gives the unimodular transformation matrix)",
  "lllintpartial(x)=partial (hence faster) lll reduction of the vectors forming\nthe matrix x when the gram matrix is integral (gives the unimodular\ntransformation matrix)",  
  "lllkerim(x)=kernel and lll reduction of the vectors forming the integral\nmatrix x",
  "lllkerimgen(x)=kernel and lll reduction of the vectors forming the matrix x\nwith polynomial coefficients",
  "lllrat(x)=lll reduction of the vectors forming the matrix x, computations\ndone with rational numbers (gives the unimodular transformation matrix)",
  "ln(x)=log(x)=natural logarithm of x",
  "lngamma(x)=logarithm of the gamma function of x",
  "localred(e,p)= e being an ellliptic curve, returns [f,kod,[u,r,s,t],c], where\nf is the conductor's exponent, kod is the kodaira type for e at p, [u,r,s,t]\nis the change of variable needed to make e minimal at p, and c is the local\nTamagawa number c_p",
  "log(x)=ln(x)=natural logarithm of x",
  "logagm(x)=natural logarithm of x, computed using agm (faster than log for more\nthan a few hundred decimal digits)",
  "lseriesell(e,s,N,A)=L-series at s of the elliptic curve e, where |N| is the\nconductor, sign(N) the sign of the functional equation, and A a cut-off point\nclose to 1",
  "mat(x)=transforms any GEN x into a matrix",
  "matextract(x,y,z)=extraction of the components of the matrix x according to the\nvector or masks y (for the rows) and z (for the columns) from left to right\n(1,2,4,8,...for the first, second, third, fourth, ...rows or columns)",
  "mathell(e,x)=gives the height matrix for vector of points x on elliptic curve e\nusing theta functions",
  "matinvr(x)=inverse of the real matrix x",
  "matrix(m,n,X,Y,expr)=mXn matrix of expression expr, the row variable X going \nfrom 1 to m and the column variable Y going from 1 to n",
  "matrixqz(x,p)=transforms the rational or integral mxn (m>=n) matrix x into an\nintegral matrix with gcd of maximal determinants equal to 1 if p is equal to\n0, not divisible by p otherwise",
  "matrixqz2(x)=finds a basis of the intersection with Z^n of the lattice spanned\nby the columns of x",
  "matrixqz3(x)=finds a basis of the intersection with Z^n of the Q-vector space\nspanned by the columns of x",
  "matsize(x)=number of rows and columns of the vector/matrix x as a 2-vector",
  "max(x,y)=maximum of x and y",
  "min(x,y)=minimum of x and y",
  "minideal(nf,ix,vdir)=minimum of the ideal ix in the direction vdir in the\nnumber field nf",
  "minim(x,bound,maxnum)=number of vectors of square norm <= bound, maximum\nnorm and list of vectors for the integral and definite quadratic form x;\nminimal non-zero vectors if bound=0",
  "minim2(x,bound)=looks for vectors of square norm <= bound, return the first one and its norm",
  "mod(x,y)=creates the integer x modulo y on the PARI stack",
  "modp(x,y)=creates the integer x modulo y as a permanent object (on the heap)",
  "modreverse(x)=reverse polymod of the polymod x, if it exists",
  "move(w,x,y)=move cursor to position x,y in rectwindow w",
  "mu(x)=Moebius function of x",
  "newtonpoly(x,p)=Newton polygon of polynomial x with respect to the prime p",
  "nextprime(x)=smallest prime number>=x",
  "nfdetint(nf,x)=multiple of the ideal determinant of the pseudo generating set x",
  "nfdiv(nf,a,b)=element a/b in nf",
  "nfdiveuc(nf,a,b)=gives algebraic integer q such that a-bq is small",
  "nfdivres(nf,a,b)=gives [q,r] such that r=a-bq is small",
  "nfhermite(nf,x)=if x=[A,I], gives a pseudo-basis of the module sum A_jI_j",
  "nfhermitemod(nf,x,detx)=if x=[A,I], and detx is a multiple of the ideal\ndeterminant of x, gives a pseudo-basis of the module sum A_jI_j",  
  "nfmod(nf,a,b)=gives r such that r=a-bq is small with q algebraic integer",
  "nfmul(nf,a,b)=element a.b in nf",
  "nfpow(nf,a,k)=element a^k in nf",
  "nfreduce(nf,a,id)=gives r such that a-r is the ideal id and r is small",
  "nfsmith(nf,x)=if x=[A,I,J], outputs [c_1,...c_n] Smith normal form of x",
  "nfval(nf,a,pr)=valuation of element a at the prime pr",
  "norm(x)=norm of x",
  "norml2(x)=square of the L2-norm of the vector x",
  "nucomp(x,y,l)=composite of primitive positive definite quadratic forms x and y\nusing nucomp and nudupl, where l=[|D/4|^(1/4)] is precomputed",
  "numdiv(x)=number of divisors of x",
  "numer(x)=numerator of x",
  "nupow(x,n)=n-th power of primitive positive definite quadratic form x using\nnucomp and nudupl",
  "o(a^b)=O(a^b)=p-adic or power series zero with precision given by b",
  "omega(x)=number of unrepeated prime divisors of x",
  "ordell(e,x)=y-coordinates corresponding to x-ordinate x on elliptic curve e",
  "order(x)=order of the integermod x in (Z/nZ)*",
  "orderell(e,p)=order of the point p on the elliptic curve e over Q, 0 if\nnon-torsion",
  "ordred(x)=reduction of the polynomial x, staying in the same order",
  "padicprec(x,p)=absolute p-adic precision of object x",
  "pascal(n)=pascal triangle of order n (n C-integer)",
  "perf(a)=rank of matrix of xx~ for x minimal vectors of a gram matrix a",
  "permutation(n,k)=permutation number k (mod n!) of n letters (n C-integer)",
  "permutation2num(vect)=ordinal (between 1 and n!) of permutation vect",
  "pf(x,p)=returns the prime form whose first coefficient is p, of discriminant x",
  "phi(x)=Euler's totient function of x",
  "pi=pi()=the constant pi, with current precision",
  "plot(X=a,b,expr)=crude plot of expression expr, X goes from a to b",
  "ploth(X=a,b,expr)=plot of expression expr, X goes from a to b in high\nresolution",
  "ploth2(X=a,b,[expr1,expr2])=plot of points [expr1,expr2], X goes from a to\nb in high resolution",
  "plothmult(X=a,b,[expr1,...])=plot of expressions expr1,..., X goes from a to\nb in high resolution",
  "plothraw(listx,listy)=plot in high resolution points whose x (resp. y)\ncoordinates are in listx (resp. listy)",
  "pnqn(x)=[p_n,p_{n-1};q_n,q_{n-1}] corresponding to the continued fraction x",
  "point(w,x,y)=draw a point (and move cursor) at position x,y in rectwindow w",
  "pointell(e,z)=coordinates of point on the curve e corresponding to the\ncomplex number z",
  "points(w,listx,listy)=draws in rectwindow w the points whose x (resp y)\ncoordinates are in listx (resp listy)",
  "polint(xa,ya,x)=polynomial interpolation at x according to data vectors xa, ya",
  "polred(x)=reduction of the polynomial x (gives minimal polynomials only)",
  "polred2(x)=reduction of the polynomial x (gives elements and minimal\npolynomials)",
  "polredabs(x)=a smallest generating polynomial of the number field for the T2\nnorm on the roots, with smallest index for the minimal T2 norm",
  "polredabs2(x)=gives [pol,a] where pol is as in polredabs, and alpha is the\nelement whose characteristic polynomial is pol",
  "polredabsall(x)=complete list of the smallest generating polynomials of the\nnumber field for the T2 norm on the roots",
  "polredabsfast(x)=a smallest generating polynomial of the number field for the T2\nnorm on the roots",  
  "polsym(x,n)=vector of symmetric powers of the roots of x up to n",
  "polvar(x)=main variable of object x. Gives p for p-adic x, error for scalars",  
  "poly(x,v)=convert x (usually a vector or a power series) into a polynomial\nwith variable v, starting with the leading coefficient",
  "polylog(m,x)=m-th polylogarithm of x",
  "polylogd(m,x)=D_m~-modified m-th polylog of x",
  "polylogdold(m,x)=D_m-modified m-th polylog of x",
  "polylogp(m,x)=P_m-modified m-th polylog of x",
  "polyrev(x,v)=convert x (usually a vector or a power series) into a polynomial\nwith variable v, starting with the constant term",
  "postdraw(list)=same as draw, except that the output is a postscript\nprogram in the file pari.ps",
  "postploth(X=a,b,expr)=same as ploth, except that the output is a postscript\nprogram in the file pari.ps",
  "postploth2(X=a,b,[expr1,expr2])=same as ploth2, except that the output is a\npostscript program in the file pari.ps",
  "postplothraw(listx,listy)=same as plothraw, except that the output is a\npostscript program in the file pari.ps",
  "powell(e,x,n)=n times the point x on elliptic curve e (n in Z)",
  "powrealraw(x,n)=n-th power without reduction of the binary quadratic form x of\npositive discriminant",
  "pprint(a)=outputs a in beautified format ending with newline",
  "pprint1(a)=outputs a in beautified format without ending with newline",
  "prec(x,n)=change the precision of x to be n (n C-integer)",
  "prime(n)=returns the n-th prime (n C-integer)",
  "primedec(nf,p)=prime ideal decomposition of the prime number p in the number\nfield nf as a vector of 5 component vectors [p,a,e,f,b] representing the\n prime ideals pZ_K+a.Z_K, e,f as usual, a as vector of components on the\n integral basis, b Lenstra's constant",
  "primes(n)=returns the vector of the first n primes (n C-integer)",
  "primroot(n)=returns a primitive root of n when it exists",
  "principalideal(nf,x)=returns the principal ideal generated by the algebraic\nnumber x in the number field nf",
  "principalidele(nf,x)=returns the principal idele generated by the algebraic\nnumber x in the number field nf",
  "print(a)=outputs a in raw format ending with newline",
  "print1(a)=outputs a in raw format without ending with newline",
  "prod(x,X=a,b,expr)=x times the product (X runs from a to b) of expression",
  "prodeuler(X=a,b,expr)=Euler product (X runs over the primes between a and b)\nof real or complex expression",
  "prodinf(X=a,expr)=infinite product (X goes from a to infinity) of real or\ncomplex expression",
  "prodinf1(X=a,expr)=infinite product (X goes from a to infinity) of real or\ncomplex 1+expression",
  "psi(x)=psi-function at x",
  "qfi(a,b,c)=binary quadratic form a*x^2+b*x*y+c*y^2 with b^2-4*a*c<0",
  "qfr(a,b,c,d)=binary quadratic form a*x^2+b*x*y+c*y^2 with b^2-4*a*c>0 and\ndistance d",
  "quaddisc(x)=discriminant of the quadratic field Q(sqrt(x))",
  "quadgen(x)=standard generator of quadratic order of discriminant x",
  "quadpoly(x)=quadratic polynomial corresponding to the discriminant x",
  "random()=random integer between 0 and 2^31-1",
  "rank(x)=rank of the matrix x",
  "rbox(w,dx,dy)=if the cursor is at (x1,y1), draw a box with diagonal\n(x1,y1)-(x1+dx,y1+dy) in rectwindow w (cursor does not move)",
  "read()=read an expression from the input file or standard input",
  "real(x)=real part of x",
  "recip(x)=reciprocal polynomial of x",
  "redimag(x)=reduction of the binary quadratic form x with D<0",
  "redreal(x)=reduction of the binary quadratic form x with D>0",
  "redrealnod(x,sq)=reduction of the binary quadratic form x with D>0 without\ndistance function where sq=[sqrt D]",
  "regula(x)=regulator of the real quadratic field of discriminant x",
  "reorder(x)=reorder the variables for output according to the vector x",
  "resultant(x,y)=resultant of the polynomials x and y with exact entries",
  "resultant2(x,y)=resultant of the polynomials x and y",
  "reverse(x)=reversion of the power series x",
  "rhoreal(x)=single reduction step of the binary quadratic form x of positive\ndiscriminant",
  "rhorealnod(x,sq)=single reduction step of the binary quadratic form x with D>0\nwithout distance function where sq=[sqrt D]",
  "rline(w,dx,dy)=if the cursor is at (x1,y1), draw a line from (x1,y1) to\n(x1+dx,y1+dy) (and move the cursor) in the rectwindow w",
  "rmove(w,dx,dy)=move cursor to position (dx,dy) relative to the present\nposition in the rectwindow w",
  "rndtoi(x)=take the nearest integer to all the coefficients of x, without\ntaking into account loss of integer part precision",
  "rnfbasis(bnf,order)=given an order as output by rnfpseudobasis or\nrnfsteinitz, gives either a basis of the order if it is free, or an\nn+1-element generating set",
  "rnfdiscf(nf,pol)=given a pol with coefficients in nf, gives a 2-component\nvector [D,d], where D is the relative ideal discriminant, and d is the\nrelative discriminant in nf^*/nf*^2",
  "rnfhermitebasis(bnf,order)=given an order as output by rnfpseudobasis,\ngives either a true HNF basis of the order if it exists, zero otherwise",  
  "rnfisfree(bnf,order)=given an order as output by rnfpseudobasis or\nrnfsteinitz, outputs true (1) or false (0) according to whether the order\nis free or not",    
  "rnfpseudobasis(nf,pol)=given a pol with coefficients in nf, gives a 4-component\nvector [A,I,D,d] where [A,I] is a pseudo basis of the maximal order in\nHNF on the power basis, D is the relative ideal discriminant, and d is the\nrelative discriminant in nf^*/nf*^2",
  "rnfsteinitz(nf,order)=given an order as output by rnfpseudobasis, gives\n[A,I,..] where (A,I) is a pseudo basis where all the ideals except\nperhaps the last are trivial",
  "rootmod(x,p)=roots mod p of the polynomial x",
  "rootmod2(x,p)=roots mod p of the polynomial x, when p is small",
  "rootpadic(x,p,r)=p-adic roots of the polynomial x to precision r",
  "roots(x)=roots of the polynomial x using a modified Newton's method",
  "roots2(x)=roots of the polynomial x using Laguerre's method",
  "rootslong(x)=roots of the polynomial x (takes more time, but more sturdy\nthan roots)",
  "rootsof1(nf)=number of roots of unity and primitive root of unity in the\nnumber field nf",
  "round(x)=take the nearest integer to all the coefficients of x",
  "rounderror(x)=maximum error found in rounding x",
  "rpoint(w,dx,dy)=draw a point (and move cursor) at position dx,dy relative to\npresent position of the cursor in rectwindow w",
  "scale(w,x1,x2,y1,y2)=scale the coordinates in rectwindow w so that x goes from\nx1 to x2 and y from y1 to y2 (y2<y1 is allowed)",
  "series(x,v)=convert x (usually a vector) into a power series with variable v,\nstarting with the constant coefficient",
  "set(x)=convert x into a set, i.e. a row vector with strictly increasing\ncoefficients",
  "setintersect(x,y)=intersection of the sets x and y",
  "setminus(x,y)=set of elements of x not belonging to y",
  "setprecision(n)=set the current precision to n decimal digits if n>0, or\nreturn the current precision if n<=0",
  "setrand(n)=reset the seed of the random number generator to n",
  "setsearch(x,y)=looks if y belongs to the set x. Returns 0 if it is not,\notherwise returns the index j such that y==x[j]",
  "setserieslength(n)=set the default length of power series to n if n>0, or\nreturn the current default length if n<=0",
  "settype(x,t)=make a copy of x with type t (to use with extreme care)",
  "setunion(x,y)=union of the sets x and y",
  "shift(x,n)=shift x left n bits if n>=0, right -n bits if n<0",
  "shiftmul(x,n)=multiply x by 2^n (n>=0 or n<0)",
  "sigma(x)=sum of the divisors of x",
  "sigmak(k,x)=sum of the k-th powers of the divisors of x (k C-integer)",
  "sign(x)=sign of x, of type integer, real or fraction",
  "signat(x)=signature of the symmetric matrix x",
  "signunit(bnf)=matrix of signs of the real embeddings of the system of\nfundamental units found by buchinit",
  "simplefactmod(x,p)=same as factmod except that only the degrees of the\nirreducible factors are given",
  "simplify(x)=simplify the object x as much as possible",
  "sin(x)=sine of x",
  "sinh(x)=hyperbolic sine of x",
  "size(x)=maximum number of decimal digits minus one of (the coefficients of) x",
  "smallbasis(x)=integral basis of the field Q[a], where a is a root of the\npolynomial x where one assumes that no square of a prime>primelimit divides\nthe discriminant of x",
  "smalldiscf(x)=discriminant of the number field defined by the polynomial x\nwhere one assumes that no square of a prime>primelimit divides the\ndiscriminant of x",
  "smallfact(x)=partial factorization of the integer x (using only the stored\nprimes)",
  "smallinitell(x)=x being the vector [a1,a2,a3,a4,a6], gives the vector:\n[a1,a2,a3,a4,a6,b2,b4,b6,b8,c4,c6,delta,j]",
  "smallpolred(x)=partial reduction of the polynomial x (gives minimal\npolynomials only)",
  "smallpolred2(x)=partial reduction of the polynomial x (gives elements and\nminimal polynomials)",
  "smith(x)=Smith normal form (i.e. elementary divisors) of the matrix x,\nexpressed as a vector",
  "smith2(x)=gives a two element vector [u,v] where u and v are matrices such\nthat u*x*v=smith(x)",
  "smithpol(x)=Smith normal form (i.e. elementary divisors) of the matrix x\nwith polynomial coefficients, expressed as a vector",
  "solve(X=a,b,expr)=real root of expression expr (X between a and b), where\nexpr(a)*expr(b)<=0",
  "sort(x)=sort in ascending order of the vector x",
  "sqr(x)=square of x. NOT identical to x*x",
  "sqred(x)=square reduction of the (symmetric) matrix x ( returns a square\nmatrix whose i-th diagonal term is the coefficient of the i-th square in\nwhich the coefficient of the i-th variable is 1)",
  "sqrt(x)=square root of x",
  "srgcd(x,y)=polynomial gcd of x and y using the subresultant algorithm",
  "string(w,x)=draw in rectwindow w the string corresponding to x, where x is\neither a string, or a number in R, written in format 9.3",
  "sturm(x)=number of real roots of the polynomial x",
  "sturmpart(x,a,b)=number of real roots of the polynomial x in the\ninterval (a,b]",
  "subcylo(p,d)=finds an equation for the d-th degree subfield of Q(zeta_p),\nwhere p must be a prime power",
  "subell(e,z1,z2)=difference of the points z1 and z2 on elliptic curve e",
  "subst(x,y,z)=in expression x, replace the variable y by the expression z",
  "sum(x,X=a,b,expr)=x plus the sum (X goes from a to b) of expression expr",
  "sumalt(X=a,expr)=Villegas-Zagier's acceleration of alternating series expr,\nX starting at a",
  "sumalt2(X=a,expr)=Euler-Van Wijngaarden's acceleration of alternating series\nexpr, X starting at a",
  "suminf(X=a,expr)=infinite sum (X goes from a to infinity) of real or complex\nexpression expr",
  "sumpos(X=a,expr)=sum of positive series expr, the formal variable X\nstarting at a",
  "supplement(x)=supplement the columns of the matrix x to an invertible matrix",
  "sylvestermatrix(x,y)=forms the sylvester matrix associated to the two polynomials\nx and y. Warning: the polynomial coefficients are in columns, not in rows",
  "tan(x)=tangent of x",
  "tanh(x)=hyperbolic tangent of x",
  "taniyama(e)=modular parametrization of elliptic curve e",
  "taylor(x,y)=taylor expansion of x with respect to the main variable of y",
  "tchebi(n)=Tchebitcheff polynomial of degree n (n C-integer)",
  "teich(x)=teichmuller character of p-adic number x",
  "texprint(a)=outputs a in TeX format",
  "theta(q,z)=Jacobi sine theta-function",
  "thetanullk(q,k)=k'th derivative at z=0 of theta(q,z)",
  "threetotwo(nf,a,b,c)=returns a 3-component vector [d,e,U] such that U is\na unimodular 3x3 matrix with algebraic integer coefficients such that\n[a,b,c]*U=[0,d,e]",
  "threetotwo2(nf,a,b,c)=returns a 3-component vector [d,e,U] such that U is\na unimodular 3x3 matrix with algebraic integer coefficients such that\n[a,b,c]*U=[0,d,e]",  
  "torsell(e)=torsion subgroup of elliptic curve e: order, structure, generators",
  "trace(x)=trace of x",
  "trans(x)=x~=transpose of x",
  "trunc(x)=truncation of x;when x is a power series,take away the O(X^)",
  "tschirnhaus(x)=random Tschirnhausen transformation of the polynomial x",
  "twototwo(nf,a,b)=returns a 3-component vector [d,e,U] such that U is a\nunimodular 2x2 matrix with algebraic integer coefficients such that\n[a,b]*U=[d,e] and d,e are hopefully smaller",
  "type(x)=internal type number of the GEN x",
  "unit(x)=fundamental unit of the quadratic field of discriminant x where\nx must be positive",
  "until(a,seq)=evaluate the expression sequence seq until a is nonzero",
  "valuation(x,p)=valuation of x with respect to p",
  "vec(x)=transforms the object x into a vector. Used mainly if x is\na polynomial or a power series",
  "vecmax(x)=maximum of the elements of the vector/matrix x",
  "vecmin(x)=minimum of the elements of the vector/matrix x",
  "vecsort(x,k)=sorts the vector of vector (or matrix) x according to the\nvalue of its k-th component",
  "vector(n,X,expr)=row vector with n components of expression expr (X ranges\nfrom 1 to n)",
  "vvector(n,X,expr)=column vector with n components of expression expr (X ranges\nfrom 1 to n)",
  "wf(x)=Weber's f function of x (j=(f^24-16)^3/f^24)",
  "wf2(x)=Weber's f2 function of x (j=(f2^24+16)^3/f2^24)",
  "while(a,seq)= while a is nonzero evaluate the expression sequence seq.\nOtherwise 0",
  "zell(e,z)=In the complex case, lattice point corresponding to the point z on\nthe elliptic curve e",
  "zeta(s)=Riemann zeta function at s",
  "zetak(nfz,s)=Dedekind zeta function of the number field nfz at s, where nfz\nis the vector computed by initzeta (NOT by initalg)",
  "zideallog(nf,x,bid)=if bid is a big ideal as given by zidealstarinit, gives the\nvector of exponents on the generators bid[1][3]",
  "zidealstar(nf,I)=3-component vector v, giving the structure of (Z_K/I)^*. v[1] is\n the order (i.e. phi(I)), v[2] is a vector of cyclic components, and v[3]\n is a vector giving the corresponding generators",
  "zidealstarinit(nf,I)=6-component vector [I,v,fa,f2,U,V] where v is as in zidealstar\nfa is the prime ideal factorisation of I and f2, U and V are technical but\nessential to work in (Z_K/I)^*",
  "znstar(n)=3-component vector v, giving the structure of (Z/nZ)^*. v[1] is\n the order (i.e. phi(n)), v[2] is a vector of cyclic components, and v[3]\n is a vector giving the corresponding generators",
  "zzzz(...)=can be any function which is being tested. For developing purposes only",
  "zzzzz(...)=can be any function which is being tested. For developing purposes only"
};
