//=======================================================================
//@V@:Note: This file generated by vgen V1.00 (14:12:12 23 Aug 1996).
//	testcmdw.cpp:	Source for testCmdWindow class
//=======================================================================

#include <v/vnotice.h>	// for vNoticeDialog
#include <v/vkeys.h>	// to map keys

#include "testcmdw.h"	// our header
#include <v/vprintdc.h>
#include <v/vprinter.h>

//	Start defines for the main window with 100

//@V@:BeginIDs
    enum {
	m_FirstCmd = 100, // Dummy Command
	m_print,	// TestDialog menu
	blkLast		// Last item
      };
//@V@:EndIDs

//@V@:BeginPulldownMenu FileMenu
    static vMenu FileMenu[] =
      {
	{"&Print", m_print, isSens, notChk, noKeyLbl, noKey, noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{"E&xit", M_Exit, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
      };
//@V@:EndPulldownMenu



//@V@:BeginMenu StandardMenu
    static vMenu StandardMenu[] =
      {
	{"&File", M_File, isSens, notUsed, notUsed, noKey, &FileMenu[0]},
	{NULL}
      };
//@V@:EndMenu


//====================>>> testCmdWindow::testCmdWindow <<<====================
  testCmdWindow::testCmdWindow(char* name, int height, int width) :
    vCmdWindow(name, height, width)
  {
    UserDebug1(Constructor,"testCmdWindow::testCmdWindow(%s) Constructor\n",name)

    // The Menu Bar
    testMenu = new vMenuPane(StandardMenu);
    AddPane(testMenu);

    // The Canvas
    testCanvas = new testCanvasPane;
    AddPane(testCanvas);


    // Show Window

    ShowWindow();
    testCanvas->ShowVScroll(1);	// Show Vert Scroll
    testCanvas->ShowHScroll(1);	// Show Horiz Scroll
  }

//====================>>> testCmdWindow::~testCmdWindow <<<====================
  testCmdWindow::~testCmdWindow()
  {
    UserDebug(Destructor,"testCmdWindow::~testCmdWindow() destructor\n")

    // Now put a delete for each new in the constructor.

    delete testMenu;
    delete testCanvas;
  }

//====================>>> testCmdWindow::KeyIn <<<====================
  void testCmdWindow::KeyIn(vKey keysym, unsigned int shift)
  {
    vCmdWindow::KeyIn(keysym, shift);
  }

//====================>>> testCmdWindow::WindowCommand <<<====================
  void testCmdWindow::WindowCommand(ItemVal id, ItemVal val, CmdType cType)
  {
    // Default: route menu and toolbar commands here


    UserDebug1(CmdEvents,"testCmdWindow:WindowCommand(%d)\n",id)

    switch (id)
      {
	//@V@:Case M_New
	case m_print:
	  {
        vPrintDC pdc;
        vPrinter printer;

        printer.Setup ("test.ps");
        pdc.SetPrinter (printer);

        if (pdc.BeginPrinting())
          {
           pdc.SetTranslate (72, 72);
           pdc.BeginPage();
           testCanvas->draw(&pdc);
           pdc.EndPage();
           pdc.EndPrinting();
          }
        /*cerr << "Print command for canvas " << testCanvas->GetWidth()
	  << " by " << testCanvas->GetHeight() << endl;
     */ 

        break;

	  }	//@V@:EndCase

	//@V@:Case M_Open

	//@V@:Case M_Exit
	case M_Exit:
	  {
	    theApp->Exit();
	    break;
	  }	//@V@:EndCase



	default:		// route unhandled commands up
	  {
	    vCmdWindow::WindowCommand(id, val, cType);
	    break;
	  }
      }
  }
