.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutButtonBoxFunc 3GLUT "3.2" "GLUT" "GLUT"
.SH NAME
glutButtonBoxFunc - sets the dial & button box button callback for the current window. 
.SH SYNTAX
.nf
.LP
void glutButtonBoxFunc(void (*func)(int button, int state));
.fi
.SH ARGUMENTS
.IP \fIfunc\fP 1i
The new button box callback function. 
.SH DESCRIPTION
glutButtonBoxFunc sets the dial & button box button callback for the
current window. The dial & button box button callback for a window is
called when the window has dial & button box input focus (normally,
when the mouse is in the window) and the user generates dial & button
box button presses. The button parameter will be the button number
(starting at one). The number of available dial & button box buttons can
be determined with
glutDeviceGet(GLUT_NUM_BUTTON_BOX_BUTTONS). The state is
either GLUT_UP or GLUT_DOWN indicating whether the callback was due
to a release or press respectively. 

Registering a dial & button box button callback when a dial & button
box device is not available is ineffectual and not an error. In this case, no
dial & button box button callbacks will be generated. 

Passing NULL to glutButtonBoxFunc disables the generation of dial &
button box button callbacks. When a new window is created, no dial &
button box button callback is initially registered. 
.SH SEE ALSO
glutDialsFunc, glutDeviceGet, glutSpaceballButtonFunc, glutTabletButtonFunc
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
