/* Routines to provide lists of the GNATS low-level files.
   Copyright (C) 1995 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "config.h"
#include "gnats.h"
#include "query.h"

int
get_gnats_file (type, file)
     unsigned int type;
     char *file;
{
  char *outfile = NULL, *infile;
  FILE *fpout, *fpin;
  char line[STR_MAX];
  char *path = (char *) alloca (PATH_MAX);
  extern int doret;

  if (file)
    {
      outfile = (char *) xmalloc (strlen (file) + 5);
      strcpy (outfile, file);
    }
  else
    fpout = stdout;

  if (type == LIST_CATEGORIES)
    {
      if (outfile)
	strcat (outfile, ".cat");
      infile = CATEGORIES;
    }
  else if (type == LIST_SUBMITTERS)
    {
      if (outfile)
	strcat (outfile, ".sub");
      infile = SUBMITTERS;
    }
  else if (type == LIST_RESPONSIBLE)
    {
      if (outfile)
	strcat (outfile, ".res");
      infile = RESPONSIBLE_FILE;
    }
  else
    {
      if (outfile)
	xfree (outfile);
      return -1;
    }

  if (outfile)
    {
      fpout = fopen (outfile, "w");
      if (fpout == (FILE *)NULL)
	return -1; /* XXX */
    }

  sprintf (path, "%s/gnats-adm/%s", gnats_root, infile);
  fpin = fopen (path, "r");
  if (fpin == (FILE *)NULL)
    return -1; /* XXX */

  while (read_string (line, fpin) > 0)
    if (line[0] != '#' && line[0] != ' ' && line[0] != '\n')
      {
	if (! outfile && doret)
	  {
	    char *s = strchr (line, '\n');
	    if (s)
	      {
		s[0] = '\0';
		fprintf (fpout, "%s\r\n", line);
	      }
	  }
	else
	  fputs (line, fpout);
      }

  fclose (fpin);
  if (outfile)
    fclose (fpout);

  return 0;
}
