'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) open.n 1.11 96/02/15 20:02:25
'\" 
.so man.macros
.TH open n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
open \- Open a file-based or command pipeline channel
.SH SYNOPSIS
.sp
\fBopen \fIfileName\fR
.br
\fBopen \fIfileName access\fR
.br
\fBopen \fIfileName access permissions\fR
.BE

.SH DESCRIPTION
.PP
This command opens a file or command pipeline and returns a channel
identifier that may be used in future invocations of commands like
\fBread\fR, \fBputs\fR, and \fBclose\fR.
If the first character of \fIfileName\fR is not \fB|\fR then
the command opens a file:
\fIfileName\fR gives the name of the file to open, and it must conform to the
conventions described in the \fBfilename\fR manual entry.
.PP
The \fIaccess\fR argument, if present, indicates the way in which the file
(or command pipeline) is to be accessed.
In the first form \fIaccess\fR may have any of the following values:
.TP 15
\fBr\fR
Open the file for reading only; the file must already exist. This is the
default value if \fIaccess\fR is not specified.
.TP 15
\fBr+\fR
Open the file for both reading and writing; the file must
already exist.
.TP 15
\fBw\fR
Open the file for writing only.  Truncate it if it exists.  If it doesn't
exist, create a new file.
.TP 15
\fBw+\fR
Open the file for reading and writing.  Truncate it if it exists.
If it doesn't exist, create a new file.
.TP 15
\fBa\fR
Open the file for writing only.  The file must already exist, and the file
is positioned so that new data is appended to the file.
.TP 15
\fBa+\fR
Open the file for reading and writing.  If the file doesn't exist,
create a new empty file.
Set the initial access position  to the end of the file.
.PP
In the second form, \fIaccess\fR consists of a list of any of the
following flags, all of which have the standard POSIX meanings.
One of the flags must be either \fBRDONLY\fR, \fBWRONLY\fR or \fBRDWR\fR.
.TP 15
\fBRDONLY\fR
Open the file for reading only.
.TP 15
\fBWRONLY\fR
Open the file for writing only.
.TP 15
\fBRDWR\fR
Open the file for both reading and writing.
.TP 15
\fBAPPEND\fR
Set the file pointer to the end of the file prior to each write.
.TP 15
\fBCREAT\fR
Create the file if it doesn't already exist (without this flag it
is an error for the file not to exist).
.TP 15
\fBEXCL\fR
If \fBCREAT\fR is also specified, an error is returned if the
file already exists.
.TP 15
\fBNOCTTY\fR
If the file is a terminal device, this flag prevents the file from
becoming the controlling terminal of the process.
.TP 15
\fBNONBLOCK\fR
.VS
Prevents the process from blocking while opening the file, and
possibly in subsequent I/O operations.  The exact behavior of
this flag is system- and device-dependent;  its use is discouraged
(it is better to use the \fBfconfigure\fR command to put a file
in nonblocking mode).
For details refer to your system documentation on the \fBopen\fR system
call's \fBO_NONBLOCK\fR flag.
.VE
.TP 15
\fBTRUNC\fR
If the file exists it is truncated to zero length.
.PP
If a new file is created as part of opening it, \fIpermissions\fR
(an integer) is used to set the permissions for the new file in
conjunction with the process's file mode creation mask.
\fIPermissions\fR defaults to 0666.
.SH "COMMAND PIPELINES"
.PP
If the first character of \fIfileName\fR is ``|'' then the
remaining characters of \fIfileName\fR are treated as a list of arguments
that describe a command pipeline to invoke, in the same style as the
arguments for \fBexec\fR.
In this case, the channel identifier returned by \fBopen\fR may be used
to write to the command's input pipe or read from its output pipe,
depending on the value of \fIaccess\fR.
If write-only access is used (e.g. \fIaccess\fR is \fBw\fR), then
standard output for the pipeline is directed to the current standard
output unless overridden by the command.
If read-only access is used (e.g. \fIaccess\fR is \fBr\fR),
standard input for the pipeline is taken from the current standard
input unless overridden by the command.

.SH "SEE ALSO"
close(n), filename(n), gets(n), read(n), puts(n)

.SH KEYWORDS
access mode, append, create, file, non-blocking, open, permissions,
pipeline, process
