#!	/bin/sh

source cd_functions.sh

test_packages_file ()
{
	PACKAGES=`grep '^Filename:' Packages \
	 |sed -e 's/^Filename:[ 	]*//'`

	for i in $PACKAGES; do
		if [ ! -f ../$i ]; then
			echo $i is in $1/Packages file, but does not exist.
		fi
	done
}

if [ ! -d binary.mnt ]; then
	mkdir binary.mnt
fi

if [ ! -d source.mnt ]; then
	mkdir source.mnt
fi

umount binary.mnt 2>&1 >/dev/null
umount source.mnt 2>&1 >/dev/null
mount -r -o loop $TARGET/binary.iso  binary.mnt
mount -r -o loop $TARGET/source.iso  source.mnt

echo Testing binary.mnt/stable/Packages for file presence.
(cd binary.mnt/stable; test_packages_file)
echo Testing binary.mnt/contrib/Packages for file presence.
(cd binary.mnt/contrib; test_packages_file)
echo Testing binary.mnt for file readability.
(cd binary.mnt; tar cf /dev/null .)

echo testing source.mnt for file readability.
(cd source.mnt; tar cf /dev/null .)

echo creating ls-lR.gz files.
(cd binary.mnt; ls -lR | gzip > $TARGET/binary-i386-ls-lR.gz)
(cd source.mnt; ls -lR | gzip > $TARGET/source-ls-lR.gz)

umount binary.mnt
umount source.mnt
rmdir binary.mnt source.mnt
