//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#include "terminmeter.h"


TermInMeter::TermInMeter( XOSView *parent, int x, int y, 
		       int width, int height, float max )
: FieldMeter( parent, x, y, width, height, 2, "IN", "PACKETS/SEC" ){
  maxpackets_ = max;
  setfieldcolor( 0, "lightblue" );
  setfieldcolor( 1, "green" );
}

TermInMeter::~TermInMeter( void ){
}

void TermInMeter::checkevent( void ){
  TermMeter::checkevent();
  total_ = maxpackets_;
  fields_[0] = incoming();
  if ( fields_[0] < 0 ) fields_[0] = 0;
  if ( fields_[0] > total_ ) fields_[0] = total_;
  fields_[1] = total_ - fields_[0];
  drawfields();
}
