#
# Makefile for picasm (Watcom C 10.6, MS-DOS)
#
CC=wcc
CFLAGS=-bt=dos -zq -wx
LINK=wlink
RM=del
NAME=picasm
LNK=picasm.lnk

OBJS = picasm.obj devices.obj config.obj token.obj symtab.obj expr.obj
OBJS += pic12bit.obj pic14bit.obj

$(NAME).exe: $(OBJS) $(LNK)
        $(LINK) @$(LNK)

$(LNK): makefile
       %create $(LNK)
       @%append $(LNK) name $(NAME)
       @%append $(LNK) op map,quiet
       @%append $(LNK) system dos
       @for %i in ($(OBJS)) do @%append $(LNK) file %i

clean:  .symbolic
        -$(RM) *.obj
        -$(RM) $(NAME).exe
        -$(RM) $(NAME).map
        -$(RM) $(NAME).lnk

.c.obj :
	$(CC) $(CFLAGS) $[*

#----
picasm.obj: picasm.c picasm.h
devices.obj: devices.c picasm.h
config.obj: config.c picasm.h
token.obj: token.c picasm.h
symtab.obj: symtab.c picasm.h
expr.obj: expr.c picasm.h
pic12bit.obj: pic12bit.c picasm.h
pic14bit.obj: pic14bit.c picasm.h
