
/* stretch_rti.c V1.0 - Copyright (C) 1993/94/95/96 Jim Geuther */

/*
 *
 * Function:	Stretch selected rectangle to image size.
 * Author: 	Jim GEUTHER
 * Date:    	18-May-96
 * Environment: Personal Power System 850 + AIX V4.1.3.0
 *
 * This Gimp plugin stretches (very simply) a selected rectangle to 
 * image size.
 *
 * Processing options:
 *
 * Create new output image - When enabled this filter will create a new
 * output image. This will cause the selected rectangle to be resized,
 * otherwise the contents of the selected rectangle will be stretch
 * to match the selected rectangle (sort of zoom-in).
 *
 * Restrictions: doesnot care about aspect ratio.
 *
 *
 * History:
 * V1.00	Jim GEUTHER, ported from ImageKnife (Amiga) to Gimp (AIX)
 *
 */
 
/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "gimp.h"
#include "stretch.h"

/* #define	_DEBUG */

#ifdef	_DEBUG
#define	NULLP()	printf("%s.%ld: NULLPOINTER\n",__FILE__,__LINE__)
#define	DPRINTF(x) printf("%s.%ld: %s",__FILE__,__LINE__,x)
#else
#define	NULLP()	
#define	DPRINTF(x)
#endif

/* Declare a local function.
 */
static void rti(Image,Image);
static char *prog_name;

static void toggle_callback(int item_ID, void *client_data, void *call_data);

static void ok_callback (int, void *, void *);
static void cancel_callback (int, void *, void *);

int	dialog_ID;

int
main (argc, argv)
     int argc;
     char **argv;
{

Image input, output;
int 	group_ID, output_ID, new_image;

long	type;

 /* Save the program name so we can use it later in reporting errors
   */
  prog_name = argv[0];

  /* Call 'gimp_init' to initialize this filter.
   * 'gimp_init' makes sure that the filter was properly called and
   *  it opens pipes for reading and writing.
   */
  if (gimp_init (argc, argv))
    {
      input = output = 0;
      input = gimp_get_input_image (0);

      /* If input image is available and the input is color, then do some
       *  work. (Bleed). Then update the output image.
       */
      if (input)
	{
		type = gimp_image_type( input );
	  switch ( type )
	    {

    	    case GRAY_IMAGE:
	    case RGB_IMAGE:
	    case INDEXED_IMAGE:
	    	dialog_ID = gimp_new_dialog("Rect to Image");
	    	group_ID = gimp_new_row_group( dialog_ID, DEFAULT, NORMAL, "");
	    	output_ID = gimp_new_check_button( dialog_ID, group_ID, "Create new output image");
	    	new_image = 1;
		gimp_change_item( dialog_ID, output_ID, sizeof(new_image), &new_image);

		gimp_add_callback( dialog_ID, output_ID, toggle_callback, &new_image);
	      	gimp_add_callback (dialog_ID, gimp_ok_item_id (dialog_ID), ok_callback, 0);
	      	gimp_add_callback (dialog_ID, gimp_cancel_item_id (dialog_ID), cancel_callback, 0);
    	
	    	if( gimp_show_dialog( dialog_ID ) ) {
	    		if( new_image ) {
				output = gimp_new_image( 0, gimp_image_width(input),
							gimp_image_height(input), gimp_image_type(input) );
				gimp_set_image_colors(output,gimp_image_cmap(input),
				      			gimp_image_colors(input));
			} else {
				output = gimp_get_output_image( 0 );
			}			
		      	gimp_display_image( output );
		      	rti(input,output);
		      	gimp_update_image (output);
		    } else NULLP();
	      break;
	    default:
	      gimp_message ("rti: cannot operate on unknown image types");
	      break;
	    }
	}

      /* Free both images.
       */
      if (input)
	gimp_free_image (input);
      if (output)
	gimp_free_image (output);

      /* Quit
       */
      gimp_quit ();
    }

  return 0;
}

static void toggle_callback(
int item_ID, void *client_data, void *call_data)
{
  *((int *) client_data) = *((long *) call_data);

}

static void
radio_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
 
 /* fillmethod=(int)client_data;  */

}

static void
item_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  *((long*) client_data) = *((long*) call_data);
}

static void
ok_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 1);
}

static void
cancel_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 0);
}

static void
rti(input, output )
Image input, output;
{

int x1, y1, x2, y2;

gimp_image_area (input, &x1, &y1, &x2, &y2);
RectStretch( input, output, 
		x1, y1, x2, y2, 
		0, 0, gimp_image_width(output)-1, gimp_image_height(output)-1 );
      
return;    	
}

/* Agree, I don't like my coding style? either 	*/
/* Feel free to optimize this code!		*/





