
/* Copyright (C) 1994,95 - Jim Geuther */


/*
 * Functions from iffparse: Any bug fixes in this code should also
 * be affected on the iffparse: code
 */


#include "cmap_palette.h"

#define _DEBUG

#ifdef	_DEBUG
#define	NULLP()	printf("%s.%ld: NULLPOINTER\n",__FILE__,__LINE__)
#else
#define	NULLP()=09
#endif

/* FreePalette(struct palette *palette):
 *
 *	Free palette memory.
 */

void=20
FreePalette(struct palette *palette)
{
if(palette) free(palette);
return;
}

/*=20
** AllocPalette(long NumColours,int TrueColour):
**=09
**
**	Allocate palette memory.
*/

struct palette *=20
AllocPalette(long NumColours,int TrueColour)
{

struct palette	*palette=3DNULL;

if(palette=3Dmalloc(sizeof(struct palette)))
{
	palette->NumColours=3DNumColours;
}
#ifdef	_DEBUG
else
{
	fprintf(stderr,"%s.%ld: NULLPOINTER\n",__FILE__,__LINE__);
}
#endif

return(palette);
}


/*=20
** LoadPalette(struct Screen *Screen,struct palette *palette,long NumColo=
urs):
**
**	Load the screen palette.
**
** Notes:
 *
** If the screenviewport is not truecolor and the palette is, guru!
 *
 *
*/

void=20
LoadPalette(struct Screen *Screen,struct palette *palette,long NumColours=
)
{
#ifdef	NOTYET
	if(Screen && palette)
	{
			/* Set up number of colours if invalid. */

		if(NumColours > palette -> NumColours || !NumColours)
			NumColours =3D palette -> NumColours;

			/* Not too much, please. */

#ifdef	TARGET_AMIGA
		if(NumColours > Screen -> ViewPort . ColorMap -> Count)
			NumColours =3D Screen -> ViewPort . ColorMap -> Count;
#else
		NumColours =3D 0; /* NOTYET */=20
#endif

			/* v39 true colour palette? */

		if(palette -> Record)
		{
			u_long	*Colours =3D palette -> Colours;
			long	 i;

				/* Set up the colour records. */

			for(i =3D 0 ; i < NumColours ; i++)
			{
				palette -> Record -> Triplets[i] . Red		=3D (0xFFFFFFFF / 255) * ((Co=
lours[i] >> 16) & 0xFF);
				palette -> Record -> Triplets[i] . Green	=3D (0xFFFFFFFF / 255) * ((C=
olours[i] >>  8) & 0xFF);
				palette -> Record -> Triplets[i] . Blue		=3D (0xFFFFFFFF / 255) * ((C=
olours[i]      ) & 0xFF);
			}

				/* Fill in the number of colours to display. */

			palette -> Record -> NumColours =3D NumColours;

				/* Load the palette. */
			/* LoadRGB32() is a V39 function */
#ifdef	TARGET_AMIGA
			LoadRGB32(&Screen -> ViewPort,(u_long *)palette -> Record);
#endif
		}
#ifdef	TARGET_AMIGA
		else
			LoadRGB4(&Screen -> ViewPort,palette -> Colours,NumColours);
#endif
	}
#endif

}

	/* GetPaletteSize(struct palette *palette):
	 *
	 *	Query the size of the palette.
	 */

long=20
GetPaletteSize(struct palette *palette)
{
	if(palette)
		return(palette -> NumColours);
	else
		return(0);
}



	/* GetPalette(struct Screen *Screen,struct palette *palette):
	 *
	 *	Get the screen colours palette.
	 */

struct palette *=20
GetPalette(
#ifdef	TARGET_AMIGA
struct Screen *Screen,
#endif
struct palette *palette
)
{
#ifdef	TARGET_AMIGA
	if(Screen)
	{
		long i;

			/* No palette given? Allocate a new one... */

		if(!palette)
		{
			if(!(palette =3D AllocPalette((long)Screen -> ViewPort . ColorMap -> C=
ount, istruecolour( &Screen->ViewPort ) )) )
			{
				return(NULL);
			}
		}

			/* v39 true colour palette? */

		if(palette -> Record)
		{
			u_long	*Colours =3D palette -> Colours,
				 Triplet[3];

				/* Run down the table... */

			for(i =3D 0 ; i < palette -> NumColours ; i++)
			{
					/* Query the colour table entry. */
#ifdef	TARGET_AMIGA
				GetRGB32(Screen -> ViewPort . ColorMap,i,1,Triplet);
#endif

					/* Only eight colours so far. */

				Triplet[0] >>=3D 24;
				Triplet[1] >>=3D 24;
				Triplet[2] >>=3D 24;

					/* Build new entry. */

				Colours[i] =3D (Triplet[0] << 16) | (Triplet[1] << 8) | Triplet[2];
			}
		}
		else
		{
			u_short *Colours =3D palette -> Colours;
			u_short r,g,b,t;

				/* Fill the table. */

#ifdef TARGET_AMIGA
			for(i =3D 0 ; i < palette -> NumColours ; i++)
			{
				Colours[i] =3D GetRGB4(Screen -> ViewPort . ColorMap,i);
			}
#endif

			/*
			** This is not a true colour, so if the number of colours
			** is 64 we have a halfbrite image, but pens 32-63 have
			** probable incorrect rgb values. Let's correct these
			*/
			/*
			** This code will ensure that pen 32-63 have the correct
			** rgb value when the user converts to non-halfbrite mode
			** with 64 colours.
			*/
			if( palette->NumColours =3D=3D 64 )
			{
				for( i =3D 32; i < 64; i++ )
				{
					t  =3D Colours[ i - 32 ];

					r	=3D (t & 0xF00) >> 8;
   				g	=3D (t & 0xF0) >> 4;
   				b	=3D (t & 0xF) ;

					r	=3D div2( r );
					g	=3D div2( g );
					b	=3D div2( b );
				=09
					t  =3D r << 8 | g << 4 | b;
					Colours[ i ] =3D t;
				}
			}

		}

		return(palette);
	}
#endif
	return(NULL);
}

/* GetPaletteTriplet(struct palette *palette,struct ColourTriplet *Triple=
t,long Index):
*
*	Fill in a single colour triplet structure.
*/

signed char /* success */=20
GetPaletteTriplet(
	struct palette 		*palette,
	struct ColourTriplet	*Triplet,
	long Index
	)
{
	if(palette)
	{
		if(Index <=3D palette -> NumColours)
		{
			Triplet->Red=3Dpalette->Triplets[Index].Red;
			Triplet->Green=3Dpalette->Triplets[Index].Green;
			Triplet->Blue=3Dpalette->Triplets[Index].Blue;
			return(TRUE);
		}
#ifdef	_DEBUG
		else
		{
			fprintf(stderr,"%s.%ld: Index(%ld) too high\n",
				__FILE__,__LINE__,Index);
		}
#endif
	} else NULLP();
	return(FALSE);
}


/* SetPaletteTriplet(struct palette *palette,u_long R,u_long G,u_long B,l=
ong Index):
 *
 * Set a single colour triplet.
 *
 * This function doesnot do the SetRGB...()
 *
 * This function adjusts rgb entries to the palette.
 */

signed char=20
SetPaletteTriplet(
	struct palette *palette,
	u_long R,
	u_long G,
	u_long B,
	long Index
	)
{
	if(palette)
	{
		if(Index <=3D palette -> NumColours)
		{
			palette->Triplets[Index].Red=3DR;
			palette->Triplets[Index].Green=3DG;
			palette->Triplets[Index].Blue=3DB;
			return(TRUE);
		}
#ifdef	_DEBUG
		else
		{
			fprintf(stderr,"%s.%ld: Index(%ld) to large\n",
				__FILE__,__LINE__,Index);
		}
#endif

	}

	return(FALSE);
}


/*
**@NODE "copypalette"
*************************************************************************
**
** NAME
**	copypalette - Copy a palette from source to destination
**
** SYNOPSIS
** struct palette * =3D copypalette(struct palette *src)
**
** FUNCTION
** This function allocates a new palette and copies the information
** from the source palette.
**
** This function assumes that both palette have the same number of colors
** and that both palettes are either TRUE color or not.
**
** INPUTS
**	struct palette *src	Pointer to the source palette.
**
** RESULT
**	Pointer to the newly allocated palette.
**
** ADDITIONAL NOTES
**
**
** SEE ALSO
**
**
** RESTRICTIONS
** This functions works only correctly when both palettes are similar
** sized and are of the same type, so both palettes must be truecolor
** or not.
**
** AUTHOR AND COPYRIGHT
**
**	Jim Geuther
**	Ch. de la Canelaz 76
**	1602 La Croix-sur-Lutry
**	Switzerland (Europe)
**
** COPYRIGHT =A9 1993 Jim Geuther, See: copyright.c for details
**
** DATE
**	27 Dec 1993
**
** ENVIRONMENT
**
**	Amiga Workbench 3.0 and above
**
** HISTORY
**
*************************************************************************
**@ENDNODE
**
** INTERNAL USE ONLY
**
** PORTABILITY
** 	This function runs only on AmigaDOS systems.
**
** PERFORMANCE
**
** MODIFICATIONS
**
*/

struct palette * copypalette(
	struct palette *src,
	struct palette *dst
	)
{

struct palette *newpalette=3DNULL;
signed char	truecolor;

if(src)
{
	if( !dst )
	{
		newpalette =3D AllocPalette( src->NumColours, truecolor );
	}
	else
	{
		newpalette =3D dst;
	}
=09
	if( newpalette )
	{
		newpalette->NumColours =3D src->NumColours;
		memcpy(newpalette,src,sizeof(struct palette));
#ifdef	OBSOLETE
		COPYMEM(src,newpalette,sizeof(struct palette));
#endif


	} else NULLP();
} else NULLP();

return(newpalette);
}

/*
**@NODE "WritePalette"
*************************************************************************
**
** NAME
**	WritePalette - Write the palette structure to a file
**
** SYNOPSIS
** int success =3D WritePalette(struct palette *palette,FILE *fp)
**
** FUNCTION
**	This function writes the palette to a file using stdio.
**
** INPUTS
**	palette		Pointer to palette structure
**	fp				stdio filehandle which must have been opened.
**					This function requires a filehandle instead of a filename
**					so that you can imbed the palette information into your
**					own files.
**
** RESULT
**	success
**
** ADDITIONAL NOTES
**
**
** SEE ALSO
**
**
** RESTRICTIONS
**
**
** AUTHOR AND COPYRIGHT
**
**	Jim Geuther
**	Ch. de la Canelaz 76
**	1602 La Croix-sur-Lutry
**	Switzerland (Europe)
**
** COPYRIGHT =A9 1993 Jim Geuther, See: copyright.c for details
**
** DATE
**	02 Jan 1994
**
** ENVIRONMENT
**
**	Amiga Workbench 3.0 and above
**
** HISTORY
**
*************************************************************************
**@ENDNODE
**
** INTERNAL USE ONLY
**
** PORTABILITY
**
** PERFORMANCE
**
** MODIFICATIONS
**
*/

int /* success */=20
WritePalette(
	struct palette	*palette,
	FILE				*fp
	)
{

int	success =3D FALSE;

if( palette && fp )
{
	if(fwrite(palette,sizeof(struct palette),1,fp)=3D=3D1)
	{
		success =3D TRUE;
	}
}

return( success );
}

struct palette * /* */=20
ReadPalette(
	FILE				*fp
	)
{

struct palette *palette =3D NULL;

if( fp )
{
	if(palette=3DAllocPalette(MAX_TRIPLETS,TRUE))
	{
		if(fread(palette,sizeof(struct palette),1,fp)=3D=3D1)
		{
		}
	}
#ifdef	_DEBUG
	else
	{
		fprintf(stderr,"%s.%ld: NULLPOINTER\n",__FILE__,__LINE__);
	}
#endif

}

return( palette );
}

/*
**@NODE "istruecolour"
*************************************************************************
**
** NAME
**	istruecolour - Determine whether viewport is true colour
**
** SYNOPSIS
** int =3D istruecolour(struct ViewPort *vp)
**
** FUNCTION
**	This function determines whether the viewport has a truecolour
** colormap or not. TrueColour is set when number of colours is
** greater then 32 and none of the special viewmodes bits is
** set.
**
** INPUTS
**	vp			Pointer to viewport
**
** RESULT
**	int	True	truecolor
**			False not truecolor
**
** ADDITIONAL NOTES
**
**
** SEE ALSO
**
**
** RESTRICTIONS
**
**
** AUTHOR AND COPYRIGHT
**
**	Jim Geuther
**	Ch. de la Canelaz 76
**	1602 La Croix-sur-Lutry
**	Switzerland (Europe)
**
** COPYRIGHT =A9 1993 Jim Geuther, See: copyright.c for details
**
** DATE
**	04 Jan 1994
**
** ENVIRONMENT
**
**	Amiga Workbench 3.0 and above
**
** HISTORY
**
*************************************************************************
**@ENDNODE
**
** INTERNAL USE ONLY
**
** PORTABILITY
**
** PERFORMANCE
**
** MODIFICATIONS
** 06 Nov 1994 Check that ColorMap is present
*/

int=20
istruecolour(
	struct ViewPort	*vp
	)
{
#ifdef	TARGET_AMIGA

int	truecolour =3D FALSE;

long	colors;

u_long	viewmodes;

if( vp )
{
	if(vp->ColorMap)
	{
		colors =3D vp->ColorMap->Count;
		if( colors > 32 )
		{
			viewmodes=3D0;
			if( ( FlagIsClear( viewmodes, ham_key) )
			&&  ( FlagIsClear( viewmodes, ehb_key) ) )
			{
				truecolour =3D TRUE;
			}
		}
	}
	else
	{
		truecolour=3DTRUE; /* 06 Nov 1994 assume truecolour */
	}
=09
}

return( truecolour );
#else
return(TRUE);
#endif
}

/*
 * update_triplet
 */

int /* success */
UpdateTriplet(
struct palette			*palette,
u_long	index,
u_long	rvalue,
u_long	gvalue,
u_long	bvalue
)
{

struct ColourTriplet		triplet;

int	success=3DFALSE;

if(palette)
{
	if( GetPaletteTriplet( palette, &triplet, index ) )
	{
		triplet.Red =3D rvalue;
		triplet.Green =3D gvalue;
		triplet.Blue =3D bvalue;
	}

	SetPaletteTriplet( palette, triplet.Red, triplet.Green, triplet.Blue, in=
dex );
	success=3DTRUE;
} else NULLP();

return(success);
}




