/*
 * Widgets for the GNOME edition of the Midnight Commander
 *
 * Copyright (C) 1997 The Free Software Foundation
 *
 * Author: Miguel de Icaza (miguel@gnu.org)
 *
 */

#include <config.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "x.h"
#include "gwidget.h"
#include "dlg.h"

void
x_destroy_cmd (void *w)
{
	Widget *widget = (Widget *) w;

	if (!widget->wdata)
		return;
	gtk_widget_destroy (GTK_WIDGET(widget->wdata));
}

/* Buttons */
static void
gbutton_callback (GtkWidget *w, void *data)
{
	WButton *b = data;
	Dlg_head *h = (Dlg_head *) b->widget.parent;
	int stop = 0;

	if (b->callback)
		stop = (*b->callback)(b->action, b->callback_data);
	
	if (!b->callback || stop){
		h->running = 0;
		h->ret_value = b->action;
	}
}

int
x_create_button (Dlg_head *h, widget_data parent, WButton *b)
{
	GtkWidget *button;

	button = gtk_button_new_with_label (b->text);
	gtk_widget_show (button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked", (GtkSignalFunc) gbutton_callback, b);
	b->widget.wdata = (widget_data) button;
	
	return 1;
}

static void
x_set_text (GtkWidget *w, gpointer data)
{
	if (!GTK_IS_LABEL (w))
		return;
	gtk_label_set (GTK_LABEL(w), data);
}

void
x_button_set (WButton *b, char *text)
{
	GtkWidget *button = b->widget.wdata;

	gtk_container_foreach (GTK_CONTAINER (button), x_set_text, text);
}

/* Radio buttons */
int
x_create_radio (Dlg_head *h, widget_data parent, WRadio *r)
{
	return 1;
}

/* Check buttons */
int
x_create_check (Dlg_head *h, widget_data parent, WCheck *c)
{
	return 1;
}

/* Input lines */
int
x_create_input (Dlg_head *h, widget_data parent, WInput *in)
{
	GtkWidget *entry;

	entry = gtk_entry_new ();
	gtk_widget_show (entry);
	in->widget.wdata = entry;
	
	return 1;
}

void
x_update_input (WInput *in)
{
	
}

/* Listboxes */
void
x_listbox_select_nth (WListbox *l, int nth)
{
}

void
x_listbox_delete_nth (WListbox *l, int nth)
{
}

int
x_create_listbox (Dlg_head *h, widget_data parent, WListbox *l)
{
}

void
x_list_insert (WListbox *l, WLEntry *p, WLEntry *e)
{
}

/* Labels */
int
x_create_label (Dlg_head *g, widget_data parent, WLabel *l)
{
	GtkWidget *label;

	label = gtk_label_new (l->text);
	gtk_widget_show (label);
	l->widget.wdata = (void *) label;

	return 1;
}

void
x_label_set_text (WLabel *label, char *text)
{
	gtk_label_set (GTK_LABEL (label->widget.wdata), text);
}

/* Buttonbar */
int
x_create_buttonbar (Dlg_head *h, widget_data parent, WButtonBar *bb)
{
}

void
x_redefine_label (WButtonBar *bb, int idx)
{
}

int
x_find_buttonbar_check (WButtonBar *bb, Widget *paneletc)
{
}

/* Gauges */
int
x_create_gauge (Dlg_head *h, widget_data parent, WGauge *g)
{
	return 1;
}

void
x_gauge_show (WGauge *g)
{
}

void
x_gauge_set_value (WGauge *g, int max, int current)
{
}
