/*
 * ProFTPD - FTP server daemon
 * Copyright (c) 1997, Public Flood Software
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Configuration structure, server, command and associated prototypes.
 *
 * $Id: dirtree.h,v 1.8 1997/11/11 17:17:22 flood Exp $
 */

#ifndef __DIRTREE_H
#define __DIRTREE_H

#include "pool.h"
#include "sets.h"

typedef struct config_struc config_rec;
struct conn_struc;

typedef struct server_struc {
  struct server_struc *next,*prev;

  pool *pool;			/* Memory pool for this server */
  xaset_t *set;			/* Set holding all servers */
  char *ServerName;		/* This server name */
  char *ServerAddress;		/* This server address */

  int ServerPort;		/* Port # to run on */
  int tcp_rwin,tcp_swin;	/* Receive/Send windows */

  char *ServerAdmin;		/* Administrator's name */
  char *ServerMessage;		/* Server's welcome message */

  int AnonymousGreeting;	/* Do not greet until after user login */  

  in_addr_t *ipaddr;		/* Internal address of this server */
  struct conn_struc *listen;	/* Our listening connection */
  xaset_t *conf;		/* Configuration details */

} server_rec;

typedef struct cmd_struc {
  pool *pool;
  server_rec *server;
  config_rec *config;
  pool *tmp_pool;		/* Temporary pool which only exists
				 * while the cmd's handler is running
				 */
  int argc;

  char *arg;			/* entire argument (excluding command) */
  char **argv;
  char *group;			/* Command grouping */
} cmd_rec;

struct config_struc {
  struct config_struc *next,*prev;

  int config_type;
  pool *pool;			/* memory pool for this object */
  xaset_t *set;			/* The set we are stored in */
  char *name;
  int argc;
  void **argv;
  long overrides;		/* Override classes */
  long flags;			/* Flags */
  
  server_rec *server;		/* Server this config element is attached to */
  config_rec *parent;		/* Our parent configuration record */
  xaset_t *subset;		/* Sub-configuration */
};

#define CONF_ROOT		(1 << 0) /* No conf record */
#define CONF_DIR		(1 << 1) /* Per-Dir configuration */
#define CONF_ANON		(1 << 2) /* Anon. FTP configuration */
#define CONF_LIMIT		(1 << 3) /* Limits commands available */
#define CONF_VIRTUAL		(1 << 4) /* Virtual host */
#define CONF_DYNDIR		(1 << 5) /* Internal use */
#define CONF_USERDATA		(1 << 14) /* Runtime user data */
#define CONF_PARAM		(1 << 15) /* config/args pair */

/* config_rec flags */
#define CF_MERGEDOWN		(1 << 0) /* Merge option down */
#define CF_DYNAMIC		(1 << 1) /* Dynamically added entry */

/* Operation codes for dir_* funcs */
#define OP_HIDE			1	/* Op for hiding dirs/files */
#define OP_COMMAND		2	/* Command operation */

/* For the Order directive */
#define ORDER_ALLOWDENY		0
#define ORDER_DENYALLOW		1

/* The following macro determines the "highest" level available for
 * configuration directives.  If a current dir_config is available, it's
 * subset is used, otherwise anon config or main server
 */

#define CURRENT_CONF		(session.dir_config ? session.dir_config->subset \
				 : (session.anon_config ? session.anon_config->subset \
                                    : main_server->conf))

extern server_rec		*main_server;
extern int			tcpBackLog;
extern int			SocketBindTight;
extern char			ServerType;
extern int			TimeoutLogin;
extern int			TimeoutIdle;
extern int			TimeoutNoXfer;

/* Prototypes */

void init_config();
void fixup_servers();
int parse_config_file(const char*);
config_rec *add_config_set(xaset_t**,const char*);
config_rec *add_config(const char*);
config_rec *add_config_param(const char*,int,...);
config_rec *add_config_param_str(const char*,int,...);
config_rec *add_config_param_set(xaset_t**,const char*,int,...);
config_rec *find_config_next(config_rec*,int,const char*,int);
config_rec *find_config(xaset_t*,int,const char*,int);
void find_config_set_top(config_rec*);
int remove_config(xaset_t*,const char*,int);

long get_param_int(xaset_t*,const char*,int);
void *get_param_ptr(xaset_t*,const char*,int);
void init_conf_stacks();
void free_conf_stacks();
server_rec *start_new_server(const char*);
server_rec *end_new_server();
config_rec *start_sub_config(const char*);
config_rec *end_sub_config();
char *get_word(char**);

config_rec *dir_match_path(pool*,char*);
int dir_check_op_mode(pool*,char*,int,int,int,int);
int dir_check(pool*,char*,char*,char*);
int login_check_limits(xaset_t*,int,int,int*);

#endif /* __DIRTREE_H */
