/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Init and dummy functions for interface with unireg */

#include "mysql_priv.h"

void unireg_init(ulong options)
{
  uint i;
  double nr;
  DBUG_ENTER("unireg_init");

  MYSYS_PROGRAM_DONT_USE_CURSES();
  abort_loop=0;

  my_disable_async_io=1;		/* aioread is only in shared library */
  wild_many='%'; wild_one='_'; wild_prefix='\\'; /* Change to sql syntax */

  current_pid=(uint) getpid();		/* Save for later ref */
  init_time();				/* Init time-functions (read zone) */
#ifdef USE_MY_ATOF
  init_my_atof();			/* use our atof */
#endif
  my_abort_hook=unireg_abort;		/* Abort with close of databases */
  f_fyllchar=' ';			/* Input fill char */
  bfill(last_ref,MAX_REFLENGTH,(uchar) 255);  /* This is indexfile-last-ref */

  VOID(strmov(reg_ext,".frm"));
  for (i=0 ; i < 6 ; i++)		// YYMMDDHHMMSS
    dayord.pos[i]=i;
  specialflag=SPECIAL_SAME_DB_NAME;
  blob_newline='^';			/* Convert newline in blobs to this */
  /* Make a tab of powers of 10 */
  for (i=0,nr=1.0; i < array_elements(log_10) ; i++)
  {					/* It's used by filesort... */
    log_10[i]= nr ; nr*= 10.0;
  }
  specialflag|=options;			/* Set options from argv */
  DBUG_VOID_RETURN;
}


void unireg_end(int signal_number)
{
  if (my_dont_interrupt)
  {
    my_remember_signal(signal_number,unireg_end); /* purecov: inspected */
    return; /* purecov: inspected */
  }
  clean_up();
  exit(0);
}


void unireg_abort(int exit_code)
{
  clean_up(); /* purecov: inspected */
  exit(exit_code); /* purecov: inspected */
}

static int cleanup_done=0;


void clean_up(void)
{
  DBUG_ENTER("clean_up");

  if (cleanup_done++)
    return; /* purecov: inspected */
  end_key_cache();			/* This is usualy freed */
  VOID(ha_panic(HA_PANIC_CLOSE));	/* close all hash,misam and p_isam */

#if defined(_MSC_VER) && !defined(DBUG_OFF) && !defined(__WIN32__)
  if (opt_endinfo)
  {
    fprintf(stderr,"Minimum stack: %u bytes\n",min_stack);
    VOID(fflush (stderr));
  }
#endif
  x_free((gptr) errmsg[ERRMAPP]);	/* Free messages */
  my_end(opt_endinfo ? MY_CHECK_ERROR | MY_GIVE_INFO : 0);
  DBUG_POP();				/* End dbug here */
  DBUG_VOID_RETURN;
} /* clean_up */
