/* -*- c -*- */

%{

#include <malloc.h>
#include <stdio.h>
#include <string.h>

/* #define DEBUG */

FILE *out = NULL;

char buf[2048], sectname[256], labeltxt[256];
char firstname[256], outname[256];
char ssectname[256], Tmp1[4096], Tmp2[256], headname[256];
char urlname[256], Headbuf[4096], refname[256];

int filenum = 1;
int tmpfn;
int secnr = 0;
int ssecnr;
int current;
int skipnewline = 0;

#define CHAPTER 1
#define SECTION 2
#define SUBSECT 3

int getstr( char *str, int n )
  {
    int i;
#ifdef DEBUG
    fprintf( stderr, "DEBUG: yytext: <<%s>>\n", yytext );
#endif
    if( strlen( yytext ) == n )
      return 0;
    strncpy( str, yytext+n, yyleng-n);
    str[ yyleng-n ] = 0;
    return 1;
  }

struct lprec
  {
    char *label;
    int fileno;
    struct lprec *next;
  };

typedef struct lprec lprec;

lprec *putlp();
lprec *getlp();

lprec *lp_table = (lprec *)0;
lprec *tmplp;

lprec *
putlp( char *lbl, int fn )
  {
    lprec *ptr;
    ptr = (lprec *) malloc (sizeof (lprec));
    ptr->label = (char *) malloc (strlen (lbl) +1 );
    strcpy( ptr->label, lbl );
    ptr->fileno = fn;
    ptr->next = (struct lprec *)lp_table;
    lp_table = ptr;
    return ptr;
  }

lprec *
getlp( char *lbl )
  {
    lprec *ptr;
    for (ptr = lp_table; ptr != (lprec *) 0;
	 ptr = (lprec *)ptr->next)
      if (strcmp (ptr->label,lbl) == 0)
	return ptr;
    return 0;
  }

%}

%s SECT

%%

^"<@@url>".*$		{

    skipnewline=1;
    getstr( urlname, 7 ); 
    sprintf( Headbuf, "<a href=\"%s\"> ", urlname);
}

^"<@@urlnam>".*$	{
    sprintf( Tmp1, " %s </a>", urlname);
    strcat (Headbuf, Tmp1);
}

^"<@@endurl>".*$	{

    skipnewline=0;
    if (out) {
       fprintf( out, "%s", Headbuf);
    } else {
       printf( "%s", Headbuf);
    }
    strcpy (Headbuf,"");
}

^"<@@title>".*$ 	{

strcpy( sectname, yytext+9 );
printf( "<title>%s</title>\n<h1>%s</h1>\n",
       sectname, sectname );
}

^"<@@head>".*$		{

    skipnewline=1;
    getstr( headname, 8 ); 
    sprintf( Headbuf, "<h3> %s ", headname);
}

^"<@@endhead>".*$	{

  if (out) {
    fprintf( out, "%s", Headbuf );
    strcpy(Headbuf, "");
    switch (current){
    case CHAPTER:
        current=0;
        break;
    case SECTION:
        current=0;
        fprintf( out, "</h1>\n<p> <a href=\"%s.html#toc%d\"> Contents of this section</a></p>\n",firstname,secnr);
        break;
    case SUBSECT:
        current=0;
        fprintf( out, "</h2>\n");
        break;
    default:
        current=0;
	fprintf( out, "</h3>\n");
        break;
    }
  } else {
    printf("%s", Headbuf );
    strcpy(Headbuf, "");
    switch (current){
    case CHAPTER:
        current=0;
        break;
    case SECTION:
        current=0;
        printf("</h1>\n<p> <a href=\"%s.html#toc%d\"> Contents of this section</a></p>\n",firstname,secnr);
        break;
    case SUBSECT:
        current=0;
        printf("</h2>\n");
        break;
    default:
        current=0;
        printf("</h3>\n");
        break;
    }
  }
  skipnewline=0;
}

^"<@@sect>".*$		{ 

    skipnewline=1;
    getstr( sectname, 8 ) ;
    if( out ) 
      {
	fclose( out );
      }
    current=SECTION;
    secnr++;
    ssecnr=0;
    sprintf( outname, "%s-%d.html", firstname, filenum++ );
    out = fopen( outname, "w" );
    fprintf( out, "<title>%s</title>\n", sectname );
    sprintf( Headbuf, "<h1>%d <a name=\"s%d\"> %s ",secnr, secnr, sectname );
    fprintf( stdout, "<p><h2><a name=\"toc%d\">",secnr);
    fprintf( stdout, "%d. <a href=\"%s\">%s</a></h2>\n<ul>\n", secnr, outname,
	    sectname );
}

^"<@@ssect>".*$          { 

    skipnewline=1;
    getstr( ssectname, 9 ) ;
    current=SUBSECT;
    ssecnr++;
    sprintf( Headbuf, "<h2>%d.%d <A Name=\"ss%d.%d\"> %s ",secnr, ssecnr, secnr, ssecnr, ssectname );
    fprintf( stdout, "<h4><a href=\"%s#ss%d.%d\">%d.%d %s</a></h4>\n", outname, secnr, ssecnr, secnr, ssecnr,
            ssectname );
}

^"<@@chapt>".*$		{

getstr( sectname, 9 );
sectname[ yyleng-14 ] = 0;
printf( "<h1>%s</h1>\n", sectname );
}

^"<@@endchapt>".*$	;

^"<@@endsect>".*$	{

if (filenum>=3) {
  sprintf(Tmp1,"%s-%d.html",firstname, (filenum - 2));
} else {
  sprintf(Tmp1,"%s.html",firstname);
}
sprintf(Tmp2,"%s-%d.html",firstname, (filenum ));
fprintf(out, "<p><a href=\"%s\"> Next </a> Chapter, <a href=\"%s\"> Previous </a> Chapter</p>",
                   Tmp2, Tmp1);
sprintf(Tmp2,"%s.html",firstname);
fprintf(out, "<p>Table of contents of <a href=\"%s#toc%d\">this chapter</a>,\n",Tmp2, filenum-1 );
fprintf(out, " General <a href=\"%s#toc\">table of contents</a></p>\n",Tmp2);
fprintf(out, "<p><a href=\"%s\"> Top </a> of the document,\n <a href=\"#0\"> Beginning of this Chapter</a></p>",
                   Tmp2);
fprintf(stdout,"</ul>\n");
fclose(out); out = NULL;
}

^"<@@endssect>".*$       {
}

<SECT>^"<@@label>".*$	{
  
  strcpy( sectname, yytext+9 );
  if (!getlp( sectname ))
    {
      fprintf( stderr, "Problem with @@label!\n" );
    } 
  else
    {
      strcpy( labeltxt, sectname );
    }
}

^"<@@label>".*$		{
  
  strcpy( sectname, yytext+9 );
  if (!getlp( sectname ))
    {
      fprintf( stderr, "Problem with @@label!\n" );
    } 
  else
    {
      if( skipnewline ) {
        sprintf( Tmp1, "<a name=\"%s\"> %s", sectname, Headbuf);
	strcpy (Headbuf, Tmp1);
	strcpy (Tmp1,"");
      } else if( out ) {
        fprintf( out, "<A Name=\"%s\"> ", sectname );
      } else {
	printf( "<A Name=\"%s\"> ", sectname );
      }
    }
}


^"<@@labelp>".*$	{

#ifdef DEBUG
fprintf( stderr, "DEBUG: yytext = <<%s>>\n", yytext );
#endif
if (sscanf( yytext, "<@@labelp>%[^#]#%d", sectname, &tmpfn ) != 2)
{
  fprintf( stderr, "Problem with @@labelp!\n" );
#ifdef DEBUG
fprintf( stderr, "DEBUG: sectname = <<%s>>\n", sectname );
fprintf( stderr, "DEBUG: tmpfn = <<%d>>\n", tmpfn );
#endif
} else
putlp( sectname, tmpfn );

}

^"<@@ref>".*$           {

strcpy( refname, yytext+7 );
if (!(tmplp = getlp( refname )))
{
  fprintf( stderr, "Problem with @@ref!\n" );
  skipnewline++;
} else {
  
  if(tmplp->fileno==secnr) {
    sprintf( Tmp1, "<a href=\"#%s\"> ", refname );
  } else if(tmplp->fileno==0) {
    sprintf( Tmp1, "<a href=\"%s.html#%s\"> ", firstname, refname );
  } else { 
    sprintf( Tmp1, "<a href=\"%s-%d.html#%s\"> ", firstname, tmplp->fileno,
              refname );
  }

  if(skipnewline) {
     strcat( Headbuf, Tmp1);
  } else {
     strcpy( Headbuf, Tmp1);
  }
  skipnewline++ ;
}
}

^"<@@refnam>".*$	{

   sprintf( Tmp1," %s </a> ", refname );
   strcat ( Headbuf, Tmp1);
}

^"<@@endref>".*$	{

   switch (skipnewline) {
   case 1:
     if (out) {
        fprintf( out, "%s", Headbuf );
     } else { 
        printf( "%s", Headbuf);
     }
     break;
   case 2:
     break;
   default:
     fprintf( stderr, "Problem with @@endref!\n" );
     break;
   }
   skipnewline--;
}

<SECT>^.*$		{ 

getstr( sectname, 0 );

if( out ) 
{
  fclose( out );
}
sprintf( outname, "%s-%d.html", firstname, filenum++ );
out = fopen( outname, "w" );
fprintf( out, "<title>%s</title>\n", sectname );
if( strlen( labeltxt ))
{
  fprintf( out, "<A Name=\"%s\">\n", labeltxt );
  labeltxt[0] = 0;
}
fprintf( out, "<h1>%s</h1> ", sectname );
fprintf( stdout, "<h2><a href=\"%s\">%s</a></h2>\n", outname,
	sectname );

BEGIN(0);
}

.*			{

if (skipnewline) {
    strcat(Headbuf, yytext );
  } else if( out ) {
    fprintf( out, "%s", yytext );
  } else {
    ECHO;
  }
}

\n			{

if(!skipnewline) {
  if( out )
  {
    fprintf( out, "%s", yytext );
  }
  else
  {
    ECHO;
  }
}
}


%%

void
main( int argc, char **argv )
{
  if( argc >= 2 )
    {
      strncpy( firstname, argv[1], 256 );
    }
  else
    {
      strcpy( firstname, "$$" );
    }

  secnr=0;
  yylex();

  if( out ) fclose( out );      

  exit( 0 );
}
