%% $Id: xyrefer.man,v 3.0 1995/07/07 20:14:21 kris Exp kris $
%%
%% Wrapper to print ``Xy-pic Reference Manual''.
%% Copyright (c) 1994-1995 Kristoffer H. Rose <kris@diku.dk>.
%% All rights reserved.

\documentclass[twocolumn]{article}
\usepackage{xydoc}
\xyoption{knot}
\xyoption{v2}
\makeindex
\begin{document}

\title{ \Xy-pic Reference Manual }

\author{
  Kristoffer H. Rose\\<kris@diku.dk>\thanks{%
    DIKU (Computer Science dept.), University of Copenhagen,
    Universitetsparken~1, DK--2100 K{\o}benhavn {\O}, Denmark.} 
  \and
  Ross Moore\\<ross@mpce.mq.edu.au>\thanks{%
    MPCE (Mathematics dept.), Macquarie University,
    North Ryde, Sydney, Australia NSW~2109.}
}
\date{Version \xyversion\thanks{%
	Partial funding for this project has been provided by a Macquarie
	University Research Grant (MURG), by the Australian Research Council
	(ARC), and through a research agreement with the Digital Equipment
	Corporation (DEC).}\quad<\xydate>}
\maketitle

\begin{abstract}
	This manual summarises the capabilities of the \Xy-pic package for
	typesetting graphs and diagrams in \TeX.  For a general introduction
	as well as availability information and conditions refer to the
	User's Guide~\cite{R95:Xy-picUG}.

	A characteristic of \Xy-pic is that it is built around a "kernel
	drawing language" which is a concise notation for general graphics,
	\eg,
%
\begin{code}
\xy (3,0)*{A} ; (20,6)*+{B}*\cir{} **\dir{-}
    ? *_!/3pt/\dir{)} *_!/7pt/\dir{:}
    ?>* \dir{>} \endxy
\end{code}
%
$$\docode$$
%
	was drawn by the \Xy-pic kernel code
%
\displaycode\noindent
%
	It is an object-oriented graphic language in the most literal sense:
	`objects' in the picture have `methods' describing how they typeset,
	stretch, etc., however, the syntax is rather terse.

	Particular applications make use of "extensions" that enhance the
	graphic capabilities of the kernel to handle such diagrams as
%
\begin{code}
\xy *[o]=<40pt>\hbox{Round}="o"*\frm{oo}
    +<5em,-5em>@+,
    (46,11)*+\hbox{Square}="s"  *\frm{-,}
    -<5em,-5em>@+,
 "o";"s" **i\crvs{},
   ?*+\hbox{Bend}="b"*\frm{.} ?>*\dir{>},
 "o";"s"."b" **\crvs{-},
 "o"."b";"s" **\crvs{-}
\endxy
\end{code}
\vspace{-2pc}
$$\docode$$
%
	which was typeset by
%
\displaycode
\noindent
%
	using the `curve' and `frame' extensions.

	All this is made accesible through "features" that provide convenient
	notation such that users can enter special classes of diagrams in an
	intuitive form, \eg, the diagram
%
\begin{code}
\xymatrix{
 U \ar@/_/[ddr]_y \ar[dr] \ar@/^/[drr]^x \\
  & X \times_Z Y \ar[d]^q \ar[r]_p
                 & X \ar[d]_f            \\
  & Y \ar[r]^g   & Z                     }
\end{code}
$$\docode$$
%
	was typeset using the `matrix' features by the \Xy-pic input lines
%
\displaycode

	Features exist for many kinds of input; here is a knot typeset using
	the `knots and links' feature:
%
\begin{code}
\xygraph{!{0;/r1pc/:/u.7pc/::}="A"
 "A"  [u(2.5)r]!{\xcapv[-1.5]}
  [u]!{\xcaph\xcapv[1.5]|(-.15)\khole}
 "A"  [u]!{\xcapv[-3]}
  [u]!{\xcaph[3]>(-.035)\khole}[rr]!{\xcapv[3]}
 "A"  [ur] !{\xunderh}
 "A"  [r] !{\xcapv-} [ur] !{\xcapv}
 "A"  [dr] !{\xunderh}
 "A" [dd] !{\xoverh} [r]!{\xoverh}
 "A" [rddd] !{\xunderh} [r] !{\xcapv}
 "A" [ddd]   !{\xcapv-\xcaph-}  [r] !{\xcaph-}}
\end{code}
$$\docode$$
%
	The current implementation is programmed complet\-ely within
	``standard \TeX\ and \MF'', \ie, using \TeX\ macros (no |\special|s)
	and fonts designed using \MF.  Optionally a special `driver' makes it
	possible to produce DVI files with `specials' for \PS\ drivers.
\end{abstract}

\pagebreak
\tableofcontents
\listoffigures

\vfill
\noindent
	Please direct any question or suggestion for improvement directly to
	the author of the component in question, preferably by electronic
	mail using the indicated address.  Complete documents and printed
	technical documentation or software is most useful.  Please note note
	that \Xy-pic is free software (see the User's Guide or the
	accompanying file |COPYING| for details).

\ifx\xydvipsloaded\undefined\else
 \hbox to\hsize{%
  \includegraphics{kris.eps}
  \raise2em\hbox{Kristoffer Rose}\hss
  Ross Moore
  \includegraphics{ross.eps}}\fi

\goodbreak



\part{The Kernel}
??g=[kernel]
\subsubsection*{Vers. \xyversion\ by Kristoffer H. Rose <kris@diku.dk>}
\def\GROUP{part}\def\FILE{part}
\CompilePrefix{xy.doc-}
\inputdoc!{xy.doc}



\part{Extensions}
??g=[extensions]
\def\GROUP{part}\def\FILE{section}%

	This part documents the graphic capabilities added by each standard
	extension option.  For each is indicated the described version
	number, the author, and how it is loaded.

	Many of these are only fully supported when a suitable "driver"
	option (described in part~??g[:drivers]) is also loaded.

\OSECTION{xycurve.doc}
\OSECTION{xyframe.doc}
\OSECTION{xycmtip.doc}
\OSECTION{xyline.doc}
\OSECTION{xyrotate.doc}
\OSECTION{xycolor.doc}
\OSECTION{xytile.doc}
\OSECTION{xystyle.doc}
\DSECTION{xyps.doc}
\DSECTION{xytpic.doc}
\OSECTION{xyimport.doc}



\part{Features}
??g=[features]
\def\GROUP{part}\def\FILE{section}%

	This part documents the notation added by each standard feature
	option.  For each is indicated the described version number, the
	author, and how it is loaded.

	The first two, `all' and `dummy', described in~\S\S??g[:all]
	and~??g[:dummy], are trivial features that nevertheless prove useful
	sometimes.  The next two, `arrow' and `2cell', described
	in~\S??g[:arrow] and~??g[:2cell], provide special commands for
	objects that `point'.  The following, `matrix' in~\S??g[:matrix],
	`graph' in~\S??g[:graph], `poly' in~\S??g[:poly], and `knot'
	in~\S??g[:knot], are "input modes" that support different overall
	structuring of (parts of) \Xy-pictures.

\OSECTION{xyall.doc}
\OSECTION{xydummy.doc}
\OSECTION{xyarrow.doc}
\OSECTION{xy2cell.doc}
\OSECTION{xymatrix.doc}
\OSECTION{xygraph.doc}
\OSECTION{xypoly.doc}
\OSECTION{xyweb.doc}
\OSECTION{xyarc.doc}
\OSECTION{xyknot.doc}



\part{Drivers}
??g=[drivers]
\def\GROUP{part}\def\FILE{section}%

	This part describes `drivers' that customise the parts of the DVI
	file generated from \Xy-pictures to exploit special capabilities of
	particular DVI driver programs through \TeX\'s |\special| command.
	This makes the DVI files non-portable but is needed for full support
	of some of the \Xy-pic extensions (described in
	part~??g[:extensions]).

%Alphabetically...

\DSECTION{xydvips.doc}
%\DSECTION{xydvipub.doc}
%\DSECTION{xydvitops.doc}
%\DSECTION{xydviwindo.doc}
\DSECTION{xyoztex.doc}
\DSECTION{xy17oztex.doc}
\DSECTION{xytextures.doc}
\DSECTION{xy16textures.doc}



\part*{Appendices}\label{Appendices}
\addtocontents{toc}{\protect\contentsline
 {part}{Appendices}{\protect\pageref{Appendices}}}%

\appendix
\def\GROUP{appendices}\def\FILE{appendix}%

\ANSWERS

\OSECTION{xyv2.doc}

\section{Common Errors}

	In this appendix we describe some common cases where small mistakes
	in \Xy-pictures result in \TeX\ error messages that may seem cryptic.

\paragraph*{! Box expected.}
\paragraph*{! A <box> was supposed to be here.}

	This message is common when an \Xy-pic <object> is mistyped because
	then \Xy-pic expects a \TeX\ <box> construction.

\paragraph*{! LaTeX Error: Bad math environment delimiter.}

	This error happens while reading an incomplete compiled picture (such
	a beast is created when \Xy-pic crashes during compilation due to a
	syntax error or other such problem).

	\TODO: Also include the more obscure ones\dots



\ANSWERS
\BIBLIOGRAPHY
\vfill
\newpage
\INDEX

\end{document}

% $Log: xyrefer.man,v $
% Revision 3.0  1995/07/07  20:14:21  kris
% Major release w/new User's Guide!
%
% Revision 2.14  1995/07/05  22:21:32  kris
% Buglets...
%
% Revision 2.13  1995/07/04  15:11:17  kris
% Ready to release v3?
%
% Revision 2.12  1994/10/25  11:34:25  kris
% Interim release just before v3 [works with AMS-LaTeX 1.2]...
%
% Revision 2.11  1994/07/05  10:37:32  kris
% Third 3beta release [bug fixes].
% Experimental graph feature included (for ECCT-94 presentation).
%
% Revision 2.10  1994/06/15  12:55:07  kris
% Second 3beta release: bug fixes.
%
% Revision 2.9  1994/06/09  14:59:19  kris
% Release 3beta.
%
% Revision 2.8  1994/04/08  04:30:00  kris
% Second (bug fix) 3alpha release.
%
% Revision 2.7  1994/03/08  02:11:01  kris
% Release 3alpha.
%
% NEW for version 2.7.

% Tell Emacs that this is a LaTeX document and how it is formatted:
% Local Variables:
% mode:latex
% fill-prefix:"\t"
% fill-column:77
% paragraph-separate:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"
% paragraph-start:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"
% End:
