#include <assert.h>
#include "basic.h"
#include "bitvec.h"

void BitVec::init(int l) {
    assert(l >= 0);

    length = l;
    alloc = word_numb(length-1)+1;
    word = new bitvword[alloc];
    for (int i = 0; i < alloc; i++)
	word[i] = 0;
}

BitVec::BitVec(int l) {
    init(l);
}

BitVec::BitVec(BitVec const& v) {
    init(v.size());
    *this = v;
}

BitVec& BitVec::operator = (BitVec const& v) {
    assert(size() == v.size());

    for (int i = 0; i < alloc; i++)
	word[i] = v.word[i];
    return *this;
}

BitVec::~BitVec() {
    delete [] word;
}

void BitVec::clear() {
    for (int i = 0; i < alloc; i++)
	word[i] = 0;
}

int BitVec::first_set() const {
    int num = word_numb(length-1);

    for (int i = 0; i <= num; i++) {
	bitvword w = word[i];
	if (w == 0) continue;

	// Look in this word
	int result = i * word_size();
	while (1) {
	    if (result >= length) return length;
	    if (w & 1) return result;
	    result++;
	    w >>= 1;
	}
    }
    return length;
}

int BitVec::first_clear() const {
    int num = word_numb(length-1);

    for (int i = 0; i <= num; i++) {
	bitvword w = ~word[i];
	if (w == 0) continue;

	int result = i * word_size();
	while (1) {
	    if (result >= length) return length;
	    if (w & 1) return result;
	    result++;
	    w >>= 1;
	}
    }
    return length;
}
