/*
 *  pwait.h --  some macros to (hopefully) make the wait() system call
 *		a bit more portable...
 *
 *  Created by Salvatore Valente <svalente@athena.mit.edu>
 *  This file has no copyright and is in the public domain.
 *
 *  $Revision: 1.1 $
 *
 */

#ifndef PWAIT_H_INCLUDED
#define PWAIT_H_INCLUDED

#include <sys/param.h>
#include <sys/wait.h>

#if defined(BSD) || defined(ultrix)
typedef union wait wait_t;
#else
typedef int wait_t;
#endif

#ifndef WEXITSTATUS
#define WEXITSTATUS(foo) (WIFEXITED(foo) ? (foo).w_status : -1)
#endif
#ifndef WTERMSIG
#define WTERMSIG(foo) (WIFSIGNALED(foo) ? (foo).w_termsig : -1)
#endif
#ifndef WSTOPSIG
#define WSTOPSIG(foo) (WIFSTOPPED(foo) ? (foo).w_stopsig : -1)
#endif
#ifndef WCOREDUMP
#define WCOREDUMP(foo) ((foo).w_coredump)
#endif

#endif /* PWAIT_H_INCLUDED */
