#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/sockios.h>
#include <linux/if.h>
#include <linux/if_arp.h>
#include <linux/ax25.h>
#include <netinet/in.h>
#include <netdb.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


void main(int argc,char *argv[])
{
	struct arpreq arq;
	struct sockaddr_in *i;
	int sock;
	struct hostent *he;
	
	if(argc!=2)
	{
		fprintf(stderr,"%s ip_address.\n",argv[0]);
		exit(1);
	}
	
	he=gethostbyname(argv[1]);
	if(he==NULL)
	{
		fprintf(stderr,"%s: unknown host '%s'.\n",argv[0],argv[1]);
		exit(1);
	}
	
	sock=socket(AF_INET,SOCK_DGRAM,0);
	if(sock==-1)
	{
		perror("sock");
		exit(1);
	}
	
	arq.arp_flags=ATF_PERM;
	
	i=(struct sockaddr_in *)&arq.arp_pa;
	i->sin_family=AF_INET;
	i->sin_addr.s_addr=*(long *)(he->h_addr);
	
	arq.arp_ha.sa_family=ARPHRD_AX25;
	
	if(ioctl(sock,SIOCDARP,&arq)==-1)
		perror("ioctl");
	close(sock);
}


