/* options.h  94.07.03
 * Copyright 1983-1992   Albert Davis
 * all the options set by the .options card.
 */
#define oDEFAULT_acct	(NO)
#define oDEFAULT_list	(NO)
#define oDEFAULT_nomod	(NO)
#define oDEFAULT_page	(NO)
#define oDEFAULT_node	(NO)
#define oDEFAULT_opts	(NO)
#define oDEFAULT_gmin	(1e-12)
#define oDEFAULT_reltol	(.001)
#define oDEFAULT_abstol	(1e-12)
#define oDEFAULT_vntol	(1e-6)
#define oDEFAULT_trtol	(7.0)
#define oDEFAULT_chgtol	(1e-14)
#define oDEFAULT_pivtol	(1e-13)
#define oDEFAULT_pivrel	(1e-3)
#define oDEFAULT_numdgt	(4)
#define oDEFAULT_tnom	(300.0)
#define oDEFAULT_cptime	(30000)
#define oDEFAULT_limtim	(2)
#define oDEFAULT_limpts	(201)
#define oDEFAULT_lvlcod	(2)
#define oDEFAULT_lvltim	(2)
#define oDEFAULT_method	(mTRAPEZOID)
#define oDEFAULT_maxord	(2)
#define oDEFAULT_defl	(100e-6)
#define oDEFAULT_defw	(100e-6)
#define oDEFAULT_defad	(0.)
#define oDEFAULT_defas	(0.)

#define oDEFAULT_seed		(1)
#define oDEFAULT_wczero		(1e-9)
#define oDEFAULT_damp		(0.99)
#define oDEFAULT_floor		(1e-20)
#define oDEFAULT_tempamb	(oDEFAULT_tnom)
#define oDEFAULT_short		(10e-6)
#define oDEFAULT_picky		(bPICKY)
#define oDEFAULT_inwidth	(80)
#define oDEFAULT_outwidth	(80)
#define oDEFAULT_xdivisions	(4.)
#define oDEFAULT_ydivisions	(4.)
#define oDEFAULT_order		(oAUTO)
#define oDEFAULT_mode		(mMIXED)
#define	oDEFAULT_transits	(2)
#define oDEFAULT_dupcheck	(NO)
#define oDEFAULT_bypass		(YES)
#define oDEFAULT_incmode	(YES)
#define oDEFAULT_lubypass	(YES)
#define oDEFAULT_limit		(1e10)
#define oDEFAULT_vmax		(1e10)
#define oDEFAULT_vmin		(-1e10)
#define oDEFAULT_dtmin		(1e-12)
#define oDEFAULT_dtratio	(1e9)
#define oDEFAULT_rstray		(NO)
#define oDEFAULT_cstray		(YES)
#define oDEFAULT_harmonics	(9)
#define oDEFAULT_trstepgrow	(2.)
#define oDEFAULT_trstepshrink	(8.)
#define oDEFAULT_trreject	(.5)
#define oDEFAULT_showall	(NO)
#define oDEFAULT_foooo		(0)
#define oDEFAULT_diodeflags 	(0)
#define oDEFAULT_mosflags	(0)

#define oDEFAULT_lowlim	(1.-oDEFAULT_reltol)
#define oDEFAULT_uplim	(1.+oDEFAULT_reltol)

#define oDEFAULT_itl0	(100)
#define oDEFAULT_itl1	(100)
#define oDEFAULT_itl2	(50)
#define oDEFAULT_itl3	(4)
#define oDEFAULT_itl4	(10)
#define oDEFAULT_itl5	(5000)
#define oDEFAULT_itl6	(0)
#define oDEFAULT_itl7	(1)
#define oDEFAULT_itl8	(99)

#define mGEAR		1	/* values for method */
#define mSTIFF		3
#define mTRAPEZOID	2

#define oREVERSE	1	/* values for order */
#define oFORWARD	2
#define oAUTO		3

#define mANALOG		1	/* values for mode */
#define mDIGITAL	2
#define mMIXED		3

/*	NO		don't bypass */		/* values for bypass */
/*	YES		bypass on test for both voltage and current */
#define	bVOLT		2	/* test for voltage only */

#define	ITL_COUNT	9

/* struct options:
 * if you change this be sure to change initialization in globals.c
 */
struct options {
   int acct;		/* flag: print accounting info */
   int list;		/* flag: print listing */
   int nomod;		/* flag: suppress model printout */
   int page;		/* flag: do page ejects */
   int node;		/* flag: print node table */
   int opts;		/* flag: print options */
   double gmin;		/* minimum conductance allowed */
   double reltol;	/* relative error tolerance */
   double abstol;	/* absolute current error tolerance */
   double vntol;	/* absolute voltage error tolerance */
   double trtol;	/* transient error overestimation factor */
   double chgtol;	/* charge tolerance */
   double pivtol;	/* minimum acceptable pivot */
   double pivrel;	/* max to min ratio in a column? */
   int numdgt;		/* number of digits to display */
   double tnom;		/* nominal termperature */
   int cptime;		/* max allowed cpu time (seconds) */
   int limtim;		/* amt of time to reserve for plots */
   int limpts;		/* max points to print */
   int lvlcod;		/* enum: if == 2, solve fast */
   int lvltim;		/* enum: how to control time step */
   int method;		/* enum: integration method */
   int maxord;		/* max order of integration */
   double defl;		/* MOS default channel length */
   double defw;		/* MOS default channel width */
   double defad;	/* MOS default drain diffusion area */
   double defas;	/* MOS default source diffusion area */

   int seed;		/* random number seed */
   double wczero;	/* worst case zero window */
   double damp;		/* Newton-Raphson damping coefficient */
   double floor;	/* print as 0 if less than this */
   double tempamb;	/* ambient temperature */
   double shortckt;	/* short resistance */
   int picky;		/* error picky-ness */
   int inwidth;		/* width of input devices */
   int outwidth;	/* width of output devices */
   double xdivisions;	/* plot divisions, x axis */
   double ydivisions;	/* plot divisions, y axis */
   int order;		/* ordering method */
   int mode;		/* mixed-mode mode preference */
   int transits;	/* number of good transitions for digital simulation */
   int dupcheck;	/* check for duplicates on read */
   int bypass;		/* bypass model evaluation, if appropriate */
   int incmode;		/* make incremental changes to the matrix */
   int lubypass;	/* bypass parts of LU decomposition, if appropriate */
   double limit;	/* diff voltage limit for nonlinear calculations */
   double vmax;		/* + voltage limit for nonlinear calculations */
   double vmin;		/* - voltage limit for nonlinear calculations */
   double dtmin;	/* smallest internal step size in transient analysis */
   double dtratio;	/* ratio of max / min dt in transient analysis */
   int rstray;		/* include stray resistors in models */
   int cstray;		/* include stray capacitors in models */
   int harmonics;	/* number of harmonics in fourier analysis */
   double trstepgrow;	/* limit of step size growth in transient analysis */
   double trstepshrink;	/* amt to shrink tr step size on convergence failure */
   double trreject;	/* how bad trunc error has to be to reject a step */
   int showall;		/* flag: show development flags */
   int foooo;		/* a reusable value to aid development */
   int diodeflags;	/* convergence heuristic flags for diode */
   int mosflags;	/* convergence heuristic flags for mosfet */

   double lowlim;	/* 1 - reltol */
   double uplim;	/* 1 + reltol */

   int itl[ITL_COUNT];	/* 1=dc (bias) iteration limit */
			/* 2=dc transfer iteration limit */
			/* 3=lower transient iteration limit */
			/* 4=upper transient iteration limit */
			/* 5=transient total iterations allowed */
			/* 6=source stepping iteration limit */
			/* 7=worst case iteration limit */
			/* 8=trace nonconvergence start iteration */
};
