#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <limits.h>
#include "link.h"

/*
	Check if a module name is indeed an alias for another module.
	Return the real module or this one (mod) if it is not an alias
*/
const char *any_alias(const char *mod)
{
	const char *modname = stripo(mod);
	int len = strlen(modname);
	/* #Specification: /etc/conf.modules / alias / format
		The format of the alias command in /etc/conf.modules
		is
		#
		alias alias_name module_name
		#
		THe different word are separated by tabs or spaces.
	*/
	for (int i = 0; i < aliasavail; i++) {
		if (strncmp(aliaslist[i], modname, len) == 0
			&& isspace(aliaslist[i][len])) {
			return str_skip(&(aliaslist[i][len]));
		}
	}
	return mod;
}


/*
	Locate all module matching "match".
	Return the number of modules found. The caller must free the content
	of abs_path[].
*/
int config_locate (
	const char *match,
	char *abs_path[1000],
	const char *type)	// Restric search to path[type]
						// or type is NULL (No restriction)
{
	int ret=0;
	if (strchr(match,'/')!=NULL){
		abs_path[0] = strdup_err (match);
		ret = 1;
	}else{
		char *lst[1000];
		match = any_alias (match);
		if (!match || !(*match) || (strcmp(match, "off") == 0))
			return -1;
		char match_o[PATH_MAX];
		sprintf (match_o,"%s.o",match);
		int nb = config_lstmod (match_o,type,lst
			,strpbrk(match, SHELL_WILD) != NULL ? 1 : 0);
		if (nb > 0){
			// The list may contain many duplication of some module
			// for example, the module slip may be in /lib/modules/default/net
			// and in /lib/modules/x.y.z/net
			for (int i=0; i<nb; i++){
				char *found = lst[i];
				if (found != NULL){
					abs_path[ret++] = found;
					lst[i] = NULL;
					char name[PATH_MAX];
					path_extrname (found,name);
					for (int j=i+1; j<nb; j++){
						char *nxt = lst[j];
						if (nxt != NULL){
							char name2[PATH_MAX];
							path_extrname(nxt,name2);
							if (strcmp(name,name2)==0){
								free (nxt);
								lst[j] = NULL;
							}
						}
					}
				}
			}
			tbstr_free (lst,nb);
		}
	}
	return ret;
}


